<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RoadOperatorServiceDisruption StructType
 * @subpackage Structs
 */
class RoadOperatorServiceDisruption extends NonRoadEventInformation
{
    /**
     * The roadOperatorServiceDisruptionType
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 1
     * @var string[]
     */
    public $roadOperatorServiceDisruptionType;
    /**
     * The roadOperatorServiceDisruptionExtension
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\ExtensionType
     */
    public $roadOperatorServiceDisruptionExtension;
    /**
     * Constructor method for RoadOperatorServiceDisruption
     * @uses RoadOperatorServiceDisruption::setRoadOperatorServiceDisruptionType()
     * @uses RoadOperatorServiceDisruption::setRoadOperatorServiceDisruptionExtension()
     * @param string[] $roadOperatorServiceDisruptionType
     * @param \StructType\ExtensionType $roadOperatorServiceDisruptionExtension
     */
    public function __construct(array $roadOperatorServiceDisruptionType = array(), \StructType\ExtensionType $roadOperatorServiceDisruptionExtension = null)
    {
        $this
            ->setRoadOperatorServiceDisruptionType($roadOperatorServiceDisruptionType)
            ->setRoadOperatorServiceDisruptionExtension($roadOperatorServiceDisruptionExtension);
    }
    /**
     * Get roadOperatorServiceDisruptionType value
     * @return string[]
     */
    public function getRoadOperatorServiceDisruptionType()
    {
        return $this->roadOperatorServiceDisruptionType;
    }
    /**
     * Set roadOperatorServiceDisruptionType value
     * @uses \EnumType\RoadOperatorServiceDisruptionTypeEnum::valueIsValid()
     * @uses \EnumType\RoadOperatorServiceDisruptionTypeEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string[] $roadOperatorServiceDisruptionType
     * @return \StructType\RoadOperatorServiceDisruption
     */
    public function setRoadOperatorServiceDisruptionType(array $roadOperatorServiceDisruptionType = array())
    {
        $invalidValues = array();
        foreach ($roadOperatorServiceDisruptionType as $roadOperatorServiceDisruptionRoadOperatorServiceDisruptionTypeItem) {
            if (!\EnumType\RoadOperatorServiceDisruptionTypeEnum::valueIsValid($roadOperatorServiceDisruptionRoadOperatorServiceDisruptionTypeItem)) {
                $invalidValues[] = var_export($roadOperatorServiceDisruptionRoadOperatorServiceDisruptionTypeItem, true);
            }
        }
        if (!empty($invalidValues)) {
            throw new \InvalidArgumentException(sprintf('Value(s) "%s" is/are invalid, please use one of: %s', implode(', ', $invalidValues), implode(', ', \EnumType\RoadOperatorServiceDisruptionTypeEnum::getValidValues())), __LINE__);
        }
        $this->roadOperatorServiceDisruptionType = $roadOperatorServiceDisruptionType;
        return $this;
    }
    /**
     * Add item to roadOperatorServiceDisruptionType value
     * @uses \EnumType\RoadOperatorServiceDisruptionTypeEnum::valueIsValid()
     * @uses \EnumType\RoadOperatorServiceDisruptionTypeEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \StructType\RoadOperatorServiceDisruption
     */
    public function addToRoadOperatorServiceDisruptionType($item)
    {
        // validation for constraint: enumeration
        if (!\EnumType\RoadOperatorServiceDisruptionTypeEnum::valueIsValid($item)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $item, implode(', ', \EnumType\RoadOperatorServiceDisruptionTypeEnum::getValidValues())), __LINE__);
        }
        $this->roadOperatorServiceDisruptionType[] = $item;
        return $this;
    }
    /**
     * Get roadOperatorServiceDisruptionExtension value
     * @return \StructType\ExtensionType|null
     */
    public function getRoadOperatorServiceDisruptionExtension()
    {
        return $this->roadOperatorServiceDisruptionExtension;
    }
    /**
     * Set roadOperatorServiceDisruptionExtension value
     * @param \StructType\ExtensionType $roadOperatorServiceDisruptionExtension
     * @return \StructType\RoadOperatorServiceDisruption
     */
    public function setRoadOperatorServiceDisruptionExtension(\StructType\ExtensionType $roadOperatorServiceDisruptionExtension = null)
    {
        $this->roadOperatorServiceDisruptionExtension = $roadOperatorServiceDisruptionExtension;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\RoadOperatorServiceDisruption
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
