<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RequestStructure StructType
 * Meta informations extracted from the WSDL
 * - documentation: Type for General SIRI Request. | If request has been proxied by an intermediate aggregating system , tracking information relating to the original requestor. This allows the aggregation to be stateless. +SIRI 2.0
 * @subpackage Structs
 */
class RequestStructure extends AuthenticatedRequestStructure
{
    /**
     * The Address
     * Meta informations extracted from the WSDL
     * - documentation: Type for a endpoint.
     * @var string
     */
    public $Address;
    /**
     * The RequestorRef
     * @var \StructType\ParticipantRefStructure
     */
    public $RequestorRef;
    /**
     * The MessageIdentifier
     * @var \StructType\MessageQualifierStructure
     */
    public $MessageIdentifier;
    /**
     * The DelegatorAddress
     * Meta informations extracted from the WSDL
     * - documentation: Type for a endpoint.
     * @var string
     */
    public $DelegatorAddress;
    /**
     * The DelegatorRef
     * @var \StructType\ParticipantRefStructure
     */
    public $DelegatorRef;
    /**
     * Constructor method for RequestStructure
     * @uses RequestStructure::setAddress()
     * @uses RequestStructure::setRequestorRef()
     * @uses RequestStructure::setMessageIdentifier()
     * @uses RequestStructure::setDelegatorAddress()
     * @uses RequestStructure::setDelegatorRef()
     * @param string $address
     * @param \StructType\ParticipantRefStructure $requestorRef
     * @param \StructType\MessageQualifierStructure $messageIdentifier
     * @param string $delegatorAddress
     * @param \StructType\ParticipantRefStructure $delegatorRef
     */
    public function __construct($address = null, \StructType\ParticipantRefStructure $requestorRef = null, \StructType\MessageQualifierStructure $messageIdentifier = null, $delegatorAddress = null, \StructType\ParticipantRefStructure $delegatorRef = null)
    {
        $this
            ->setAddress($address)
            ->setRequestorRef($requestorRef)
            ->setMessageIdentifier($messageIdentifier)
            ->setDelegatorAddress($delegatorAddress)
            ->setDelegatorRef($delegatorRef);
    }
    /**
     * Get Address value
     * @return string|null
     */
    public function getAddress()
    {
        return $this->Address;
    }
    /**
     * Set Address value
     * @param string $address
     * @return \StructType\RequestStructure
     */
    public function setAddress($address = null)
    {
        // validation for constraint: string
        if (!is_null($address) && !is_string($address)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($address)), __LINE__);
        }
        $this->Address = $address;
        return $this;
    }
    /**
     * Get RequestorRef value
     * @return \StructType\ParticipantRefStructure|null
     */
    public function getRequestorRef()
    {
        return $this->RequestorRef;
    }
    /**
     * Set RequestorRef value
     * @param \StructType\ParticipantRefStructure $requestorRef
     * @return \StructType\RequestStructure
     */
    public function setRequestorRef(\StructType\ParticipantRefStructure $requestorRef = null)
    {
        $this->RequestorRef = $requestorRef;
        return $this;
    }
    /**
     * Get MessageIdentifier value
     * @return \StructType\MessageQualifierStructure|null
     */
    public function getMessageIdentifier()
    {
        return $this->MessageIdentifier;
    }
    /**
     * Set MessageIdentifier value
     * @param \StructType\MessageQualifierStructure $messageIdentifier
     * @return \StructType\RequestStructure
     */
    public function setMessageIdentifier(\StructType\MessageQualifierStructure $messageIdentifier = null)
    {
        $this->MessageIdentifier = $messageIdentifier;
        return $this;
    }
    /**
     * Get DelegatorAddress value
     * @return string|null
     */
    public function getDelegatorAddress()
    {
        return $this->DelegatorAddress;
    }
    /**
     * Set DelegatorAddress value
     * @param string $delegatorAddress
     * @return \StructType\RequestStructure
     */
    public function setDelegatorAddress($delegatorAddress = null)
    {
        // validation for constraint: string
        if (!is_null($delegatorAddress) && !is_string($delegatorAddress)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($delegatorAddress)), __LINE__);
        }
        $this->DelegatorAddress = $delegatorAddress;
        return $this;
    }
    /**
     * Get DelegatorRef value
     * @return \StructType\ParticipantRefStructure|null
     */
    public function getDelegatorRef()
    {
        return $this->DelegatorRef;
    }
    /**
     * Set DelegatorRef value
     * @param \StructType\ParticipantRefStructure $delegatorRef
     * @return \StructType\RequestStructure
     */
    public function setDelegatorRef(\StructType\ParticipantRefStructure $delegatorRef = null)
    {
        $this->DelegatorRef = $delegatorRef;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\RequestStructure
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
