<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RequestPolicy StructType
 * Meta informations extracted from the WSDL
 * - documentation: Request Policiy capabilities. | Request Policy capabilities. | Available Request Policy capabilities. | Request Policy capabilities. | Request Policy capabilities. | Request Policy capabilities. | Request Policy capabilities. |
 * Request Policy capabilities.
 * @subpackage Structs
 */
class RequestPolicy extends CapabilityRequestPolicyStructure
{
    /**
     * The HasDetailLevel
     * @var bool
     */
    public $HasDetailLevel;
    /**
     * The DefaultDetailLevel
     * @var string
     */
    public $DefaultDetailLevel;
    /**
     * The HasMaximumVisits
     * @var bool
     */
    public $HasMaximumVisits;
    /**
     * The HasMinimumVisitsPerLine
     * @var bool
     */
    public $HasMinimumVisitsPerLine;
    /**
     * The HasMinimumVisitsPerVia
     * @var bool
     */
    public $HasMinimumVisitsPerVia;
    /**
     * The HasNumberOfOnwardsCalls
     * @var bool
     */
    public $HasNumberOfOnwardsCalls;
    /**
     * The HasNumberOfPreviousCalls
     * @var bool
     */
    public $HasNumberOfPreviousCalls;
    /**
     * The HasMaximumVehicles
     * @var bool
     */
    public $HasMaximumVehicles;
    /**
     * The HasMaximumNumberOfCalls
     * @var bool
     */
    public $HasMaximumNumberOfCalls;
    /**
     * The ForeignJourneysOnly
     * Meta informations extracted from the WSDL
     * - default: false
     * - documentation: Whether service returns only foreign journeys. Default is 'false'. | Whether only foreign journeys are included.
     * - minOccurs: 0
     * @var bool
     */
    public $ForeignJourneysOnly;
    /**
     * The HasMaximumFacilityStatus
     * @var bool
     */
    public $HasMaximumFacilityStatus;
    /**
     * The HasMaximumNumberOfSituations
     * @var bool
     */
    public $HasMaximumNumberOfSituations;
    /**
     * Constructor method for RequestPolicy
     * @uses RequestPolicy::setHasDetailLevel()
     * @uses RequestPolicy::setDefaultDetailLevel()
     * @uses RequestPolicy::setHasMaximumVisits()
     * @uses RequestPolicy::setHasMinimumVisitsPerLine()
     * @uses RequestPolicy::setHasMinimumVisitsPerVia()
     * @uses RequestPolicy::setHasNumberOfOnwardsCalls()
     * @uses RequestPolicy::setHasNumberOfPreviousCalls()
     * @uses RequestPolicy::setHasMaximumVehicles()
     * @uses RequestPolicy::setHasMaximumNumberOfCalls()
     * @uses RequestPolicy::setForeignJourneysOnly()
     * @uses RequestPolicy::setHasMaximumFacilityStatus()
     * @uses RequestPolicy::setHasMaximumNumberOfSituations()
     * @param bool $hasDetailLevel
     * @param string $defaultDetailLevel
     * @param bool $hasMaximumVisits
     * @param bool $hasMinimumVisitsPerLine
     * @param bool $hasMinimumVisitsPerVia
     * @param bool $hasNumberOfOnwardsCalls
     * @param bool $hasNumberOfPreviousCalls
     * @param bool $hasMaximumVehicles
     * @param bool $hasMaximumNumberOfCalls
     * @param bool $foreignJourneysOnly
     * @param bool $hasMaximumFacilityStatus
     * @param bool $hasMaximumNumberOfSituations
     */
    public function __construct($hasDetailLevel = null, $defaultDetailLevel = null, $hasMaximumVisits = null, $hasMinimumVisitsPerLine = null, $hasMinimumVisitsPerVia = null, $hasNumberOfOnwardsCalls = null, $hasNumberOfPreviousCalls = null, $hasMaximumVehicles = null, $hasMaximumNumberOfCalls = null, $foreignJourneysOnly = false, $hasMaximumFacilityStatus = null, $hasMaximumNumberOfSituations = null)
    {
        $this
            ->setHasDetailLevel($hasDetailLevel)
            ->setDefaultDetailLevel($defaultDetailLevel)
            ->setHasMaximumVisits($hasMaximumVisits)
            ->setHasMinimumVisitsPerLine($hasMinimumVisitsPerLine)
            ->setHasMinimumVisitsPerVia($hasMinimumVisitsPerVia)
            ->setHasNumberOfOnwardsCalls($hasNumberOfOnwardsCalls)
            ->setHasNumberOfPreviousCalls($hasNumberOfPreviousCalls)
            ->setHasMaximumVehicles($hasMaximumVehicles)
            ->setHasMaximumNumberOfCalls($hasMaximumNumberOfCalls)
            ->setForeignJourneysOnly($foreignJourneysOnly)
            ->setHasMaximumFacilityStatus($hasMaximumFacilityStatus)
            ->setHasMaximumNumberOfSituations($hasMaximumNumberOfSituations);
    }
    /**
     * Get HasDetailLevel value
     * @return bool|null
     */
    public function getHasDetailLevel()
    {
        return $this->HasDetailLevel;
    }
    /**
     * Set HasDetailLevel value
     * @param bool $hasDetailLevel
     * @return \StructType\RequestPolicy
     */
    public function setHasDetailLevel($hasDetailLevel = null)
    {
        // validation for constraint: boolean
        if (!is_null($hasDetailLevel) && !is_bool($hasDetailLevel)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($hasDetailLevel)), __LINE__);
        }
        $this->HasDetailLevel = $hasDetailLevel;
        return $this;
    }
    /**
     * Get DefaultDetailLevel value
     * @return string|null
     */
    public function getDefaultDetailLevel()
    {
        return $this->DefaultDetailLevel;
    }
    /**
     * Set DefaultDetailLevel value
     * @uses \EnumType\StopMonitoringDetailEnumeration::valueIsValid()
     * @uses \EnumType\StopMonitoringDetailEnumeration::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $defaultDetailLevel
     * @return \StructType\RequestPolicy
     */
    public function setDefaultDetailLevel($defaultDetailLevel = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\StopMonitoringDetailEnumeration::valueIsValid($defaultDetailLevel)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $defaultDetailLevel, implode(', ', \EnumType\StopMonitoringDetailEnumeration::getValidValues())), __LINE__);
        }
        $this->DefaultDetailLevel = $defaultDetailLevel;
        return $this;
    }
    /**
     * Get HasMaximumVisits value
     * @return bool|null
     */
    public function getHasMaximumVisits()
    {
        return $this->HasMaximumVisits;
    }
    /**
     * Set HasMaximumVisits value
     * @param bool $hasMaximumVisits
     * @return \StructType\RequestPolicy
     */
    public function setHasMaximumVisits($hasMaximumVisits = null)
    {
        // validation for constraint: boolean
        if (!is_null($hasMaximumVisits) && !is_bool($hasMaximumVisits)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($hasMaximumVisits)), __LINE__);
        }
        $this->HasMaximumVisits = $hasMaximumVisits;
        return $this;
    }
    /**
     * Get HasMinimumVisitsPerLine value
     * @return bool|null
     */
    public function getHasMinimumVisitsPerLine()
    {
        return $this->HasMinimumVisitsPerLine;
    }
    /**
     * Set HasMinimumVisitsPerLine value
     * @param bool $hasMinimumVisitsPerLine
     * @return \StructType\RequestPolicy
     */
    public function setHasMinimumVisitsPerLine($hasMinimumVisitsPerLine = null)
    {
        // validation for constraint: boolean
        if (!is_null($hasMinimumVisitsPerLine) && !is_bool($hasMinimumVisitsPerLine)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($hasMinimumVisitsPerLine)), __LINE__);
        }
        $this->HasMinimumVisitsPerLine = $hasMinimumVisitsPerLine;
        return $this;
    }
    /**
     * Get HasMinimumVisitsPerVia value
     * @return bool|null
     */
    public function getHasMinimumVisitsPerVia()
    {
        return $this->HasMinimumVisitsPerVia;
    }
    /**
     * Set HasMinimumVisitsPerVia value
     * @param bool $hasMinimumVisitsPerVia
     * @return \StructType\RequestPolicy
     */
    public function setHasMinimumVisitsPerVia($hasMinimumVisitsPerVia = null)
    {
        // validation for constraint: boolean
        if (!is_null($hasMinimumVisitsPerVia) && !is_bool($hasMinimumVisitsPerVia)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($hasMinimumVisitsPerVia)), __LINE__);
        }
        $this->HasMinimumVisitsPerVia = $hasMinimumVisitsPerVia;
        return $this;
    }
    /**
     * Get HasNumberOfOnwardsCalls value
     * @return bool|null
     */
    public function getHasNumberOfOnwardsCalls()
    {
        return $this->HasNumberOfOnwardsCalls;
    }
    /**
     * Set HasNumberOfOnwardsCalls value
     * @param bool $hasNumberOfOnwardsCalls
     * @return \StructType\RequestPolicy
     */
    public function setHasNumberOfOnwardsCalls($hasNumberOfOnwardsCalls = null)
    {
        // validation for constraint: boolean
        if (!is_null($hasNumberOfOnwardsCalls) && !is_bool($hasNumberOfOnwardsCalls)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($hasNumberOfOnwardsCalls)), __LINE__);
        }
        $this->HasNumberOfOnwardsCalls = $hasNumberOfOnwardsCalls;
        return $this;
    }
    /**
     * Get HasNumberOfPreviousCalls value
     * @return bool|null
     */
    public function getHasNumberOfPreviousCalls()
    {
        return $this->HasNumberOfPreviousCalls;
    }
    /**
     * Set HasNumberOfPreviousCalls value
     * @param bool $hasNumberOfPreviousCalls
     * @return \StructType\RequestPolicy
     */
    public function setHasNumberOfPreviousCalls($hasNumberOfPreviousCalls = null)
    {
        // validation for constraint: boolean
        if (!is_null($hasNumberOfPreviousCalls) && !is_bool($hasNumberOfPreviousCalls)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($hasNumberOfPreviousCalls)), __LINE__);
        }
        $this->HasNumberOfPreviousCalls = $hasNumberOfPreviousCalls;
        return $this;
    }
    /**
     * Get HasMaximumVehicles value
     * @return bool|null
     */
    public function getHasMaximumVehicles()
    {
        return $this->HasMaximumVehicles;
    }
    /**
     * Set HasMaximumVehicles value
     * @param bool $hasMaximumVehicles
     * @return \StructType\RequestPolicy
     */
    public function setHasMaximumVehicles($hasMaximumVehicles = null)
    {
        // validation for constraint: boolean
        if (!is_null($hasMaximumVehicles) && !is_bool($hasMaximumVehicles)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($hasMaximumVehicles)), __LINE__);
        }
        $this->HasMaximumVehicles = $hasMaximumVehicles;
        return $this;
    }
    /**
     * Get HasMaximumNumberOfCalls value
     * @return bool|null
     */
    public function getHasMaximumNumberOfCalls()
    {
        return $this->HasMaximumNumberOfCalls;
    }
    /**
     * Set HasMaximumNumberOfCalls value
     * @param bool $hasMaximumNumberOfCalls
     * @return \StructType\RequestPolicy
     */
    public function setHasMaximumNumberOfCalls($hasMaximumNumberOfCalls = null)
    {
        // validation for constraint: boolean
        if (!is_null($hasMaximumNumberOfCalls) && !is_bool($hasMaximumNumberOfCalls)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($hasMaximumNumberOfCalls)), __LINE__);
        }
        $this->HasMaximumNumberOfCalls = $hasMaximumNumberOfCalls;
        return $this;
    }
    /**
     * Get ForeignJourneysOnly value
     * @return bool|null
     */
    public function getForeignJourneysOnly()
    {
        return $this->ForeignJourneysOnly;
    }
    /**
     * Set ForeignJourneysOnly value
     * @param bool $foreignJourneysOnly
     * @return \StructType\RequestPolicy
     */
    public function setForeignJourneysOnly($foreignJourneysOnly = false)
    {
        // validation for constraint: boolean
        if (!is_null($foreignJourneysOnly) && !is_bool($foreignJourneysOnly)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($foreignJourneysOnly)), __LINE__);
        }
        $this->ForeignJourneysOnly = $foreignJourneysOnly;
        return $this;
    }
    /**
     * Get HasMaximumFacilityStatus value
     * @return bool|null
     */
    public function getHasMaximumFacilityStatus()
    {
        return $this->HasMaximumFacilityStatus;
    }
    /**
     * Set HasMaximumFacilityStatus value
     * @param bool $hasMaximumFacilityStatus
     * @return \StructType\RequestPolicy
     */
    public function setHasMaximumFacilityStatus($hasMaximumFacilityStatus = null)
    {
        // validation for constraint: boolean
        if (!is_null($hasMaximumFacilityStatus) && !is_bool($hasMaximumFacilityStatus)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($hasMaximumFacilityStatus)), __LINE__);
        }
        $this->HasMaximumFacilityStatus = $hasMaximumFacilityStatus;
        return $this;
    }
    /**
     * Get HasMaximumNumberOfSituations value
     * @return bool|null
     */
    public function getHasMaximumNumberOfSituations()
    {
        return $this->HasMaximumNumberOfSituations;
    }
    /**
     * Set HasMaximumNumberOfSituations value
     * @param bool $hasMaximumNumberOfSituations
     * @return \StructType\RequestPolicy
     */
    public function setHasMaximumNumberOfSituations($hasMaximumNumberOfSituations = null)
    {
        // validation for constraint: boolean
        if (!is_null($hasMaximumNumberOfSituations) && !is_bool($hasMaximumNumberOfSituations)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($hasMaximumNumberOfSituations)), __LINE__);
        }
        $this->HasMaximumNumberOfSituations = $hasMaximumNumberOfSituations;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\RequestPolicy
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
