<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RecordedCalls StructType
 * Meta informations extracted from the WSDL
 * - documentation: Observed call times for that art of teh journey that has already been completed. (+ SIRI 2..0)
 * @subpackage Structs
 */
class RecordedCalls extends AbstractStructBase
{
    /**
     * The RecordedCall
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - ref: RecordedCall
     * @var \StructType\RecordedCallStructure[]
     */
    public $RecordedCall;
    /**
     * Constructor method for RecordedCalls
     * @uses RecordedCalls::setRecordedCall()
     * @param \StructType\RecordedCallStructure[] $recordedCall
     */
    public function __construct(array $recordedCall = array())
    {
        $this
            ->setRecordedCall($recordedCall);
    }
    /**
     * Get RecordedCall value
     * @return \StructType\RecordedCallStructure[]|null
     */
    public function getRecordedCall()
    {
        return $this->RecordedCall;
    }
    /**
     * Set RecordedCall value
     * @throws \InvalidArgumentException
     * @param \StructType\RecordedCallStructure[] $recordedCall
     * @return \StructType\RecordedCalls
     */
    public function setRecordedCall(array $recordedCall = array())
    {
        foreach ($recordedCall as $recordedCallsRecordedCallItem) {
            // validation for constraint: itemType
            if (!$recordedCallsRecordedCallItem instanceof \StructType\RecordedCallStructure) {
                throw new \InvalidArgumentException(sprintf('The RecordedCall property can only contain items of \StructType\RecordedCallStructure, "%s" given', is_object($recordedCallsRecordedCallItem) ? get_class($recordedCallsRecordedCallItem) : gettype($recordedCallsRecordedCallItem)), __LINE__);
            }
        }
        $this->RecordedCall = $recordedCall;
        return $this;
    }
    /**
     * Add item to RecordedCall value
     * @throws \InvalidArgumentException
     * @param \StructType\RecordedCallStructure $item
     * @return \StructType\RecordedCalls
     */
    public function addToRecordedCall(\StructType\RecordedCallStructure $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\RecordedCallStructure) {
            throw new \InvalidArgumentException(sprintf('The RecordedCall property can only contain items of \StructType\RecordedCallStructure, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->RecordedCall[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\RecordedCalls
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
