<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RecordedCallStructure StructType
 * Meta informations extracted from the WSDL
 * - documentation: Type for recroded Real-time info about a VEHICLE JOURNEY Stop.
 * @subpackage Structs
 */
class RecordedCallStructure extends AbstractStructBase
{
    /**
     * The StopPointRef
     * @var \StructType\StopPointRefStructure
     */
    public $StopPointRef;
    /**
     * The VisitNumber
     * Meta informations extracted from the WSDL
     * - documentation: Type for Stop Visit.
     * @var int
     */
    public $VisitNumber;
    /**
     * The Order
     * @var int
     */
    public $Order;
    /**
     * The StopPointName
     * @var \StructType\NaturalLanguageStringStructure
     */
    public $StopPointName;
    /**
     * The ExtraCall
     * Meta informations extracted from the WSDL
     * - documentation: This call is additional and unplanned. If omitted: CALL is planned.
     * - minOccurs: 0
     * @var bool
     */
    public $ExtraCall;
    /**
     * The Cancellation
     * Meta informations extracted from the WSDL
     * - documentation: This call is a cancellation of a previously announced call.
     * - minOccurs: 0
     * @var bool
     */
    public $Cancellation;
    /**
     * The PredictionInaccurate
     * @var bool
     */
    public $PredictionInaccurate;
    /**
     * The Occupancy
     * @var string
     */
    public $Occupancy;
    /**
     * The AimedArrivalTime
     * @var string
     */
    public $AimedArrivalTime;
    /**
     * The ExpectedArrivalTime
     * @var string
     */
    public $ExpectedArrivalTime;
    /**
     * The ActualArrivalTime
     * @var string
     */
    public $ActualArrivalTime;
    /**
     * The ArrivalPlatformName
     * @var \StructType\NaturalLanguageStringStructure
     */
    public $ArrivalPlatformName;
    /**
     * The AimedDepartureTime
     * @var string
     */
    public $AimedDepartureTime;
    /**
     * The ExpectedDepartureTime
     * @var string
     */
    public $ExpectedDepartureTime;
    /**
     * The DeparturePlatformName
     * @var \StructType\NaturalLanguageStringStructure
     */
    public $DeparturePlatformName;
    /**
     * The ActualDepartureTime
     * @var string
     */
    public $ActualDepartureTime;
    /**
     * The AimedHeadwayInterval
     * Meta informations extracted from the WSDL
     * - documentation: Limited version of duration. Must be positive. | Limited version of duration that allows for precise time arithmetic. Only Month, Day, Hour, Minute Second terms should be used. Milliseconds should not be used. Year should not be
     * used. Negative values allowed. e.g. PT1004199059S", "PT130S", "PT2M10S", "P1DT2S", "-P1DT2S".
     * @var string
     */
    public $AimedHeadwayInterval;
    /**
     * The ExpectedHeadwayInterval
     * Meta informations extracted from the WSDL
     * - documentation: Limited version of duration. Must be positive. | Limited version of duration that allows for precise time arithmetic. Only Month, Day, Hour, Minute Second terms should be used. Milliseconds should not be used. Year should not be
     * used. Negative values allowed. e.g. PT1004199059S", "PT130S", "PT2M10S", "P1DT2S", "-P1DT2S".
     * @var string
     */
    public $ExpectedHeadwayInterval;
    /**
     * The ActualHeadwayInterval
     * Meta informations extracted from the WSDL
     * - documentation: Limited version of duration. Must be positive. | Limited version of duration that allows for precise time arithmetic. Only Month, Day, Hour, Minute Second terms should be used. Milliseconds should not be used. Year should not be
     * used. Negative values allowed. e.g. PT1004199059S", "PT130S", "PT2M10S", "P1DT2S", "-P1DT2S".
     * @var string
     */
    public $ActualHeadwayInterval;
    /**
     * The Extensions
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - ref: Extensions
     * @var \StructType\ExtensionsStructure
     */
    public $Extensions;
    /**
     * Constructor method for RecordedCallStructure
     * @uses RecordedCallStructure::setStopPointRef()
     * @uses RecordedCallStructure::setVisitNumber()
     * @uses RecordedCallStructure::setOrder()
     * @uses RecordedCallStructure::setStopPointName()
     * @uses RecordedCallStructure::setExtraCall()
     * @uses RecordedCallStructure::setCancellation()
     * @uses RecordedCallStructure::setPredictionInaccurate()
     * @uses RecordedCallStructure::setOccupancy()
     * @uses RecordedCallStructure::setAimedArrivalTime()
     * @uses RecordedCallStructure::setExpectedArrivalTime()
     * @uses RecordedCallStructure::setActualArrivalTime()
     * @uses RecordedCallStructure::setArrivalPlatformName()
     * @uses RecordedCallStructure::setAimedDepartureTime()
     * @uses RecordedCallStructure::setExpectedDepartureTime()
     * @uses RecordedCallStructure::setDeparturePlatformName()
     * @uses RecordedCallStructure::setActualDepartureTime()
     * @uses RecordedCallStructure::setAimedHeadwayInterval()
     * @uses RecordedCallStructure::setExpectedHeadwayInterval()
     * @uses RecordedCallStructure::setActualHeadwayInterval()
     * @uses RecordedCallStructure::setExtensions()
     * @param \StructType\StopPointRefStructure $stopPointRef
     * @param int $visitNumber
     * @param int $order
     * @param \StructType\NaturalLanguageStringStructure $stopPointName
     * @param bool $extraCall
     * @param bool $cancellation
     * @param bool $predictionInaccurate
     * @param string $occupancy
     * @param string $aimedArrivalTime
     * @param string $expectedArrivalTime
     * @param string $actualArrivalTime
     * @param \StructType\NaturalLanguageStringStructure $arrivalPlatformName
     * @param string $aimedDepartureTime
     * @param string $expectedDepartureTime
     * @param \StructType\NaturalLanguageStringStructure $departurePlatformName
     * @param string $actualDepartureTime
     * @param string $aimedHeadwayInterval
     * @param string $expectedHeadwayInterval
     * @param string $actualHeadwayInterval
     * @param \StructType\ExtensionsStructure $extensions
     */
    public function __construct(\StructType\StopPointRefStructure $stopPointRef = null, $visitNumber = null, $order = null, \StructType\NaturalLanguageStringStructure $stopPointName = null, $extraCall = null, $cancellation = null, $predictionInaccurate = null, $occupancy = null, $aimedArrivalTime = null, $expectedArrivalTime = null, $actualArrivalTime = null, \StructType\NaturalLanguageStringStructure $arrivalPlatformName = null, $aimedDepartureTime = null, $expectedDepartureTime = null, \StructType\NaturalLanguageStringStructure $departurePlatformName = null, $actualDepartureTime = null, $aimedHeadwayInterval = null, $expectedHeadwayInterval = null, $actualHeadwayInterval = null, \StructType\ExtensionsStructure $extensions = null)
    {
        $this
            ->setStopPointRef($stopPointRef)
            ->setVisitNumber($visitNumber)
            ->setOrder($order)
            ->setStopPointName($stopPointName)
            ->setExtraCall($extraCall)
            ->setCancellation($cancellation)
            ->setPredictionInaccurate($predictionInaccurate)
            ->setOccupancy($occupancy)
            ->setAimedArrivalTime($aimedArrivalTime)
            ->setExpectedArrivalTime($expectedArrivalTime)
            ->setActualArrivalTime($actualArrivalTime)
            ->setArrivalPlatformName($arrivalPlatformName)
            ->setAimedDepartureTime($aimedDepartureTime)
            ->setExpectedDepartureTime($expectedDepartureTime)
            ->setDeparturePlatformName($departurePlatformName)
            ->setActualDepartureTime($actualDepartureTime)
            ->setAimedHeadwayInterval($aimedHeadwayInterval)
            ->setExpectedHeadwayInterval($expectedHeadwayInterval)
            ->setActualHeadwayInterval($actualHeadwayInterval)
            ->setExtensions($extensions);
    }
    /**
     * Get StopPointRef value
     * @return \StructType\StopPointRefStructure|null
     */
    public function getStopPointRef()
    {
        return $this->StopPointRef;
    }
    /**
     * Set StopPointRef value
     * @param \StructType\StopPointRefStructure $stopPointRef
     * @return \StructType\RecordedCallStructure
     */
    public function setStopPointRef(\StructType\StopPointRefStructure $stopPointRef = null)
    {
        $this->StopPointRef = $stopPointRef;
        return $this;
    }
    /**
     * Get VisitNumber value
     * @return int|null
     */
    public function getVisitNumber()
    {
        return $this->VisitNumber;
    }
    /**
     * Set VisitNumber value
     * @param int $visitNumber
     * @return \StructType\RecordedCallStructure
     */
    public function setVisitNumber($visitNumber = null)
    {
        // validation for constraint: int
        if (!is_null($visitNumber) && !is_numeric($visitNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($visitNumber)), __LINE__);
        }
        $this->VisitNumber = $visitNumber;
        return $this;
    }
    /**
     * Get Order value
     * @return int|null
     */
    public function getOrder()
    {
        return $this->Order;
    }
    /**
     * Set Order value
     * @param int $order
     * @return \StructType\RecordedCallStructure
     */
    public function setOrder($order = null)
    {
        // validation for constraint: int
        if (!is_null($order) && !is_numeric($order)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($order)), __LINE__);
        }
        $this->Order = $order;
        return $this;
    }
    /**
     * Get StopPointName value
     * @return \StructType\NaturalLanguageStringStructure|null
     */
    public function getStopPointName()
    {
        return $this->StopPointName;
    }
    /**
     * Set StopPointName value
     * @param \StructType\NaturalLanguageStringStructure $stopPointName
     * @return \StructType\RecordedCallStructure
     */
    public function setStopPointName(\StructType\NaturalLanguageStringStructure $stopPointName = null)
    {
        $this->StopPointName = $stopPointName;
        return $this;
    }
    /**
     * Get ExtraCall value
     * @return bool|null
     */
    public function getExtraCall()
    {
        return $this->ExtraCall;
    }
    /**
     * Set ExtraCall value
     * @param bool $extraCall
     * @return \StructType\RecordedCallStructure
     */
    public function setExtraCall($extraCall = null)
    {
        // validation for constraint: boolean
        if (!is_null($extraCall) && !is_bool($extraCall)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($extraCall)), __LINE__);
        }
        $this->ExtraCall = $extraCall;
        return $this;
    }
    /**
     * Get Cancellation value
     * @return bool|null
     */
    public function getCancellation()
    {
        return $this->Cancellation;
    }
    /**
     * Set Cancellation value
     * @param bool $cancellation
     * @return \StructType\RecordedCallStructure
     */
    public function setCancellation($cancellation = null)
    {
        // validation for constraint: boolean
        if (!is_null($cancellation) && !is_bool($cancellation)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($cancellation)), __LINE__);
        }
        $this->Cancellation = $cancellation;
        return $this;
    }
    /**
     * Get PredictionInaccurate value
     * @return bool|null
     */
    public function getPredictionInaccurate()
    {
        return $this->PredictionInaccurate;
    }
    /**
     * Set PredictionInaccurate value
     * @param bool $predictionInaccurate
     * @return \StructType\RecordedCallStructure
     */
    public function setPredictionInaccurate($predictionInaccurate = null)
    {
        // validation for constraint: boolean
        if (!is_null($predictionInaccurate) && !is_bool($predictionInaccurate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($predictionInaccurate)), __LINE__);
        }
        $this->PredictionInaccurate = $predictionInaccurate;
        return $this;
    }
    /**
     * Get Occupancy value
     * @return string|null
     */
    public function getOccupancy()
    {
        return $this->Occupancy;
    }
    /**
     * Set Occupancy value
     * @uses \EnumType\OccupancyEnumeration::valueIsValid()
     * @uses \EnumType\OccupancyEnumeration::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $occupancy
     * @return \StructType\RecordedCallStructure
     */
    public function setOccupancy($occupancy = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\OccupancyEnumeration::valueIsValid($occupancy)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $occupancy, implode(', ', \EnumType\OccupancyEnumeration::getValidValues())), __LINE__);
        }
        $this->Occupancy = $occupancy;
        return $this;
    }
    /**
     * Get AimedArrivalTime value
     * @return string|null
     */
    public function getAimedArrivalTime()
    {
        return $this->AimedArrivalTime;
    }
    /**
     * Set AimedArrivalTime value
     * @param string $aimedArrivalTime
     * @return \StructType\RecordedCallStructure
     */
    public function setAimedArrivalTime($aimedArrivalTime = null)
    {
        // validation for constraint: string
        if (!is_null($aimedArrivalTime) && !is_string($aimedArrivalTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($aimedArrivalTime)), __LINE__);
        }
        $this->AimedArrivalTime = $aimedArrivalTime;
        return $this;
    }
    /**
     * Get ExpectedArrivalTime value
     * @return string|null
     */
    public function getExpectedArrivalTime()
    {
        return $this->ExpectedArrivalTime;
    }
    /**
     * Set ExpectedArrivalTime value
     * @param string $expectedArrivalTime
     * @return \StructType\RecordedCallStructure
     */
    public function setExpectedArrivalTime($expectedArrivalTime = null)
    {
        // validation for constraint: string
        if (!is_null($expectedArrivalTime) && !is_string($expectedArrivalTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($expectedArrivalTime)), __LINE__);
        }
        $this->ExpectedArrivalTime = $expectedArrivalTime;
        return $this;
    }
    /**
     * Get ActualArrivalTime value
     * @return string|null
     */
    public function getActualArrivalTime()
    {
        return $this->ActualArrivalTime;
    }
    /**
     * Set ActualArrivalTime value
     * @param string $actualArrivalTime
     * @return \StructType\RecordedCallStructure
     */
    public function setActualArrivalTime($actualArrivalTime = null)
    {
        // validation for constraint: string
        if (!is_null($actualArrivalTime) && !is_string($actualArrivalTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($actualArrivalTime)), __LINE__);
        }
        $this->ActualArrivalTime = $actualArrivalTime;
        return $this;
    }
    /**
     * Get ArrivalPlatformName value
     * @return \StructType\NaturalLanguageStringStructure|null
     */
    public function getArrivalPlatformName()
    {
        return $this->ArrivalPlatformName;
    }
    /**
     * Set ArrivalPlatformName value
     * @param \StructType\NaturalLanguageStringStructure $arrivalPlatformName
     * @return \StructType\RecordedCallStructure
     */
    public function setArrivalPlatformName(\StructType\NaturalLanguageStringStructure $arrivalPlatformName = null)
    {
        $this->ArrivalPlatformName = $arrivalPlatformName;
        return $this;
    }
    /**
     * Get AimedDepartureTime value
     * @return string|null
     */
    public function getAimedDepartureTime()
    {
        return $this->AimedDepartureTime;
    }
    /**
     * Set AimedDepartureTime value
     * @param string $aimedDepartureTime
     * @return \StructType\RecordedCallStructure
     */
    public function setAimedDepartureTime($aimedDepartureTime = null)
    {
        // validation for constraint: string
        if (!is_null($aimedDepartureTime) && !is_string($aimedDepartureTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($aimedDepartureTime)), __LINE__);
        }
        $this->AimedDepartureTime = $aimedDepartureTime;
        return $this;
    }
    /**
     * Get ExpectedDepartureTime value
     * @return string|null
     */
    public function getExpectedDepartureTime()
    {
        return $this->ExpectedDepartureTime;
    }
    /**
     * Set ExpectedDepartureTime value
     * @param string $expectedDepartureTime
     * @return \StructType\RecordedCallStructure
     */
    public function setExpectedDepartureTime($expectedDepartureTime = null)
    {
        // validation for constraint: string
        if (!is_null($expectedDepartureTime) && !is_string($expectedDepartureTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($expectedDepartureTime)), __LINE__);
        }
        $this->ExpectedDepartureTime = $expectedDepartureTime;
        return $this;
    }
    /**
     * Get DeparturePlatformName value
     * @return \StructType\NaturalLanguageStringStructure|null
     */
    public function getDeparturePlatformName()
    {
        return $this->DeparturePlatformName;
    }
    /**
     * Set DeparturePlatformName value
     * @param \StructType\NaturalLanguageStringStructure $departurePlatformName
     * @return \StructType\RecordedCallStructure
     */
    public function setDeparturePlatformName(\StructType\NaturalLanguageStringStructure $departurePlatformName = null)
    {
        $this->DeparturePlatformName = $departurePlatformName;
        return $this;
    }
    /**
     * Get ActualDepartureTime value
     * @return string|null
     */
    public function getActualDepartureTime()
    {
        return $this->ActualDepartureTime;
    }
    /**
     * Set ActualDepartureTime value
     * @param string $actualDepartureTime
     * @return \StructType\RecordedCallStructure
     */
    public function setActualDepartureTime($actualDepartureTime = null)
    {
        // validation for constraint: string
        if (!is_null($actualDepartureTime) && !is_string($actualDepartureTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($actualDepartureTime)), __LINE__);
        }
        $this->ActualDepartureTime = $actualDepartureTime;
        return $this;
    }
    /**
     * Get AimedHeadwayInterval value
     * @return string|null
     */
    public function getAimedHeadwayInterval()
    {
        return $this->AimedHeadwayInterval;
    }
    /**
     * Set AimedHeadwayInterval value
     * @param string $aimedHeadwayInterval
     * @return \StructType\RecordedCallStructure
     */
    public function setAimedHeadwayInterval($aimedHeadwayInterval = null)
    {
        // validation for constraint: string
        if (!is_null($aimedHeadwayInterval) && !is_string($aimedHeadwayInterval)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($aimedHeadwayInterval)), __LINE__);
        }
        $this->AimedHeadwayInterval = $aimedHeadwayInterval;
        return $this;
    }
    /**
     * Get ExpectedHeadwayInterval value
     * @return string|null
     */
    public function getExpectedHeadwayInterval()
    {
        return $this->ExpectedHeadwayInterval;
    }
    /**
     * Set ExpectedHeadwayInterval value
     * @param string $expectedHeadwayInterval
     * @return \StructType\RecordedCallStructure
     */
    public function setExpectedHeadwayInterval($expectedHeadwayInterval = null)
    {
        // validation for constraint: string
        if (!is_null($expectedHeadwayInterval) && !is_string($expectedHeadwayInterval)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($expectedHeadwayInterval)), __LINE__);
        }
        $this->ExpectedHeadwayInterval = $expectedHeadwayInterval;
        return $this;
    }
    /**
     * Get ActualHeadwayInterval value
     * @return string|null
     */
    public function getActualHeadwayInterval()
    {
        return $this->ActualHeadwayInterval;
    }
    /**
     * Set ActualHeadwayInterval value
     * @param string $actualHeadwayInterval
     * @return \StructType\RecordedCallStructure
     */
    public function setActualHeadwayInterval($actualHeadwayInterval = null)
    {
        // validation for constraint: string
        if (!is_null($actualHeadwayInterval) && !is_string($actualHeadwayInterval)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($actualHeadwayInterval)), __LINE__);
        }
        $this->ActualHeadwayInterval = $actualHeadwayInterval;
        return $this;
    }
    /**
     * Get Extensions value
     * @return \StructType\ExtensionsStructure|null
     */
    public function getExtensions()
    {
        return $this->Extensions;
    }
    /**
     * Set Extensions value
     * @param \StructType\ExtensionsStructure $extensions
     * @return \StructType\RecordedCallStructure
     */
    public function setExtensions(\StructType\ExtensionsStructure $extensions = null)
    {
        $this->Extensions = $extensions;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\RecordedCallStructure
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
