<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Reason StructType
 * Meta informations extracted from the WSDL
 * - documentation: Reason.
 * @subpackage Structs
 */
class Reason extends AbstractStructBase
{
    /**
     * The UnknownReason
     * @var string
     */
    public $UnknownReason;
    /**
     * The MiscellaneousReason
     * @var string
     */
    public $MiscellaneousReason;
    /**
     * The PersonnelReason
     * @var string
     */
    public $PersonnelReason;
    /**
     * The EquipmentReason
     * @var string
     */
    public $EquipmentReason;
    /**
     * The EnvironmentReason
     * @var string
     */
    public $EnvironmentReason;
    /**
     * The UndefinedReason
     * @var string
     */
    public $UndefinedReason;
    /**
     * The MiscellaneousSubReason
     * @var string
     */
    public $MiscellaneousSubReason;
    /**
     * The PersonnelSubReason
     * @var string
     */
    public $PersonnelSubReason;
    /**
     * The EquipmentSubReason
     * @var string
     */
    public $EquipmentSubReason;
    /**
     * The EnvironmentSubReason
     * @var string
     */
    public $EnvironmentSubReason;
    /**
     * The PublicEventReason
     * @var string
     */
    public $PublicEventReason;
    /**
     * The ReasonName
     * @var \StructType\NaturalLanguageStringStructure
     */
    public $ReasonName;
    /**
     * Constructor method for Reason
     * @uses Reason::setUnknownReason()
     * @uses Reason::setMiscellaneousReason()
     * @uses Reason::setPersonnelReason()
     * @uses Reason::setEquipmentReason()
     * @uses Reason::setEnvironmentReason()
     * @uses Reason::setUndefinedReason()
     * @uses Reason::setMiscellaneousSubReason()
     * @uses Reason::setPersonnelSubReason()
     * @uses Reason::setEquipmentSubReason()
     * @uses Reason::setEnvironmentSubReason()
     * @uses Reason::setPublicEventReason()
     * @uses Reason::setReasonName()
     * @param string $unknownReason
     * @param string $miscellaneousReason
     * @param string $personnelReason
     * @param string $equipmentReason
     * @param string $environmentReason
     * @param string $undefinedReason
     * @param string $miscellaneousSubReason
     * @param string $personnelSubReason
     * @param string $equipmentSubReason
     * @param string $environmentSubReason
     * @param string $publicEventReason
     * @param \StructType\NaturalLanguageStringStructure $reasonName
     */
    public function __construct($unknownReason = null, $miscellaneousReason = null, $personnelReason = null, $equipmentReason = null, $environmentReason = null, $undefinedReason = null, $miscellaneousSubReason = null, $personnelSubReason = null, $equipmentSubReason = null, $environmentSubReason = null, $publicEventReason = null, \StructType\NaturalLanguageStringStructure $reasonName = null)
    {
        $this
            ->setUnknownReason($unknownReason)
            ->setMiscellaneousReason($miscellaneousReason)
            ->setPersonnelReason($personnelReason)
            ->setEquipmentReason($equipmentReason)
            ->setEnvironmentReason($environmentReason)
            ->setUndefinedReason($undefinedReason)
            ->setMiscellaneousSubReason($miscellaneousSubReason)
            ->setPersonnelSubReason($personnelSubReason)
            ->setEquipmentSubReason($equipmentSubReason)
            ->setEnvironmentSubReason($environmentSubReason)
            ->setPublicEventReason($publicEventReason)
            ->setReasonName($reasonName);
    }
    /**
     * Get UnknownReason value
     * @return string|null
     */
    public function getUnknownReason()
    {
        return $this->UnknownReason;
    }
    /**
     * Set UnknownReason value
     * @param string $unknownReason
     * @return \StructType\Reason
     */
    public function setUnknownReason($unknownReason = null)
    {
        // validation for constraint: string
        if (!is_null($unknownReason) && !is_string($unknownReason)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($unknownReason)), __LINE__);
        }
        $this->UnknownReason = $unknownReason;
        return $this;
    }
    /**
     * Get MiscellaneousReason value
     * @return string|null
     */
    public function getMiscellaneousReason()
    {
        return $this->MiscellaneousReason;
    }
    /**
     * Set MiscellaneousReason value
     * @uses \EnumType\MiscellaneousReasonEnumeration::valueIsValid()
     * @uses \EnumType\MiscellaneousReasonEnumeration::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $miscellaneousReason
     * @return \StructType\Reason
     */
    public function setMiscellaneousReason($miscellaneousReason = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\MiscellaneousReasonEnumeration::valueIsValid($miscellaneousReason)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $miscellaneousReason, implode(', ', \EnumType\MiscellaneousReasonEnumeration::getValidValues())), __LINE__);
        }
        $this->MiscellaneousReason = $miscellaneousReason;
        return $this;
    }
    /**
     * Get PersonnelReason value
     * @return string|null
     */
    public function getPersonnelReason()
    {
        return $this->PersonnelReason;
    }
    /**
     * Set PersonnelReason value
     * @uses \EnumType\PersonnelReasonEnumeration::valueIsValid()
     * @uses \EnumType\PersonnelReasonEnumeration::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $personnelReason
     * @return \StructType\Reason
     */
    public function setPersonnelReason($personnelReason = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\PersonnelReasonEnumeration::valueIsValid($personnelReason)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $personnelReason, implode(', ', \EnumType\PersonnelReasonEnumeration::getValidValues())), __LINE__);
        }
        $this->PersonnelReason = $personnelReason;
        return $this;
    }
    /**
     * Get EquipmentReason value
     * @return string|null
     */
    public function getEquipmentReason()
    {
        return $this->EquipmentReason;
    }
    /**
     * Set EquipmentReason value
     * @uses \EnumType\EquipmentReasonEnumeration::valueIsValid()
     * @uses \EnumType\EquipmentReasonEnumeration::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $equipmentReason
     * @return \StructType\Reason
     */
    public function setEquipmentReason($equipmentReason = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\EquipmentReasonEnumeration::valueIsValid($equipmentReason)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $equipmentReason, implode(', ', \EnumType\EquipmentReasonEnumeration::getValidValues())), __LINE__);
        }
        $this->EquipmentReason = $equipmentReason;
        return $this;
    }
    /**
     * Get EnvironmentReason value
     * @return string|null
     */
    public function getEnvironmentReason()
    {
        return $this->EnvironmentReason;
    }
    /**
     * Set EnvironmentReason value
     * @uses \EnumType\EnvironmentReasonEnumeration::valueIsValid()
     * @uses \EnumType\EnvironmentReasonEnumeration::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $environmentReason
     * @return \StructType\Reason
     */
    public function setEnvironmentReason($environmentReason = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\EnvironmentReasonEnumeration::valueIsValid($environmentReason)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $environmentReason, implode(', ', \EnumType\EnvironmentReasonEnumeration::getValidValues())), __LINE__);
        }
        $this->EnvironmentReason = $environmentReason;
        return $this;
    }
    /**
     * Get UndefinedReason value
     * @return string|null
     */
    public function getUndefinedReason()
    {
        return $this->UndefinedReason;
    }
    /**
     * Set UndefinedReason value
     * @param string $undefinedReason
     * @return \StructType\Reason
     */
    public function setUndefinedReason($undefinedReason = null)
    {
        // validation for constraint: string
        if (!is_null($undefinedReason) && !is_string($undefinedReason)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($undefinedReason)), __LINE__);
        }
        $this->UndefinedReason = $undefinedReason;
        return $this;
    }
    /**
     * Get MiscellaneousSubReason value
     * @return string|null
     */
    public function getMiscellaneousSubReason()
    {
        return $this->MiscellaneousSubReason;
    }
    /**
     * Set MiscellaneousSubReason value
     * @uses \EnumType\MiscellaneousSubReasonEnumeration::valueIsValid()
     * @uses \EnumType\MiscellaneousSubReasonEnumeration::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $miscellaneousSubReason
     * @return \StructType\Reason
     */
    public function setMiscellaneousSubReason($miscellaneousSubReason = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\MiscellaneousSubReasonEnumeration::valueIsValid($miscellaneousSubReason)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $miscellaneousSubReason, implode(', ', \EnumType\MiscellaneousSubReasonEnumeration::getValidValues())), __LINE__);
        }
        $this->MiscellaneousSubReason = $miscellaneousSubReason;
        return $this;
    }
    /**
     * Get PersonnelSubReason value
     * @return string|null
     */
    public function getPersonnelSubReason()
    {
        return $this->PersonnelSubReason;
    }
    /**
     * Set PersonnelSubReason value
     * @uses \EnumType\PersonnelSubReasonEnumeration::valueIsValid()
     * @uses \EnumType\PersonnelSubReasonEnumeration::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $personnelSubReason
     * @return \StructType\Reason
     */
    public function setPersonnelSubReason($personnelSubReason = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\PersonnelSubReasonEnumeration::valueIsValid($personnelSubReason)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $personnelSubReason, implode(', ', \EnumType\PersonnelSubReasonEnumeration::getValidValues())), __LINE__);
        }
        $this->PersonnelSubReason = $personnelSubReason;
        return $this;
    }
    /**
     * Get EquipmentSubReason value
     * @return string|null
     */
    public function getEquipmentSubReason()
    {
        return $this->EquipmentSubReason;
    }
    /**
     * Set EquipmentSubReason value
     * @uses \EnumType\EquipmentSubReasonEnumeration::valueIsValid()
     * @uses \EnumType\EquipmentSubReasonEnumeration::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $equipmentSubReason
     * @return \StructType\Reason
     */
    public function setEquipmentSubReason($equipmentSubReason = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\EquipmentSubReasonEnumeration::valueIsValid($equipmentSubReason)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $equipmentSubReason, implode(', ', \EnumType\EquipmentSubReasonEnumeration::getValidValues())), __LINE__);
        }
        $this->EquipmentSubReason = $equipmentSubReason;
        return $this;
    }
    /**
     * Get EnvironmentSubReason value
     * @return string|null
     */
    public function getEnvironmentSubReason()
    {
        return $this->EnvironmentSubReason;
    }
    /**
     * Set EnvironmentSubReason value
     * @uses \EnumType\EnvironmentSubReasonEnumeration::valueIsValid()
     * @uses \EnumType\EnvironmentSubReasonEnumeration::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $environmentSubReason
     * @return \StructType\Reason
     */
    public function setEnvironmentSubReason($environmentSubReason = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\EnvironmentSubReasonEnumeration::valueIsValid($environmentSubReason)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $environmentSubReason, implode(', ', \EnumType\EnvironmentSubReasonEnumeration::getValidValues())), __LINE__);
        }
        $this->EnvironmentSubReason = $environmentSubReason;
        return $this;
    }
    /**
     * Get PublicEventReason value
     * @return string|null
     */
    public function getPublicEventReason()
    {
        return $this->PublicEventReason;
    }
    /**
     * Set PublicEventReason value
     * @uses \EnumType\PublicEventTypeEnum::valueIsValid()
     * @uses \EnumType\PublicEventTypeEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $publicEventReason
     * @return \StructType\Reason
     */
    public function setPublicEventReason($publicEventReason = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\PublicEventTypeEnum::valueIsValid($publicEventReason)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $publicEventReason, implode(', ', \EnumType\PublicEventTypeEnum::getValidValues())), __LINE__);
        }
        $this->PublicEventReason = $publicEventReason;
        return $this;
    }
    /**
     * Get ReasonName value
     * @return \StructType\NaturalLanguageStringStructure|null
     */
    public function getReasonName()
    {
        return $this->ReasonName;
    }
    /**
     * Set ReasonName value
     * @param \StructType\NaturalLanguageStringStructure $reasonName
     * @return \StructType\Reason
     */
    public function setReasonName(\StructType\NaturalLanguageStringStructure $reasonName = null)
    {
        $this->ReasonName = $reasonName;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Reason
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
