<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PublishToTvActionStructure StructType
 * Meta informations extracted from the WSDL
 * - documentation: Type for Notify SITUATION to Tv.
 * @subpackage Structs
 */
class PublishToTvActionStructure extends ParameterisedActionStructure
{
    /**
     * The Ceefax
     * Meta informations extracted from the WSDL
     * - default: true
     * - documentation: Publish to Teltext. Default is 'true'.
     * - minOccurs: 0
     * @var bool
     */
    public $Ceefax;
    /**
     * The Teletext
     * Meta informations extracted from the WSDL
     * - default: true
     * - documentation: Publish to Ceefax. Default is 'true'.
     * - minOccurs: 0
     * @var bool
     */
    public $Teletext;
    /**
     * Constructor method for PublishToTvActionStructure
     * @uses PublishToTvActionStructure::setCeefax()
     * @uses PublishToTvActionStructure::setTeletext()
     * @param bool $ceefax
     * @param bool $teletext
     */
    public function __construct($ceefax = true, $teletext = true)
    {
        $this
            ->setCeefax($ceefax)
            ->setTeletext($teletext);
    }
    /**
     * Get Ceefax value
     * @return bool|null
     */
    public function getCeefax()
    {
        return $this->Ceefax;
    }
    /**
     * Set Ceefax value
     * @param bool $ceefax
     * @return \StructType\PublishToTvActionStructure
     */
    public function setCeefax($ceefax = true)
    {
        // validation for constraint: boolean
        if (!is_null($ceefax) && !is_bool($ceefax)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($ceefax)), __LINE__);
        }
        $this->Ceefax = $ceefax;
        return $this;
    }
    /**
     * Get Teletext value
     * @return bool|null
     */
    public function getTeletext()
    {
        return $this->Teletext;
    }
    /**
     * Set Teletext value
     * @param bool $teletext
     * @return \StructType\PublishToTvActionStructure
     */
    public function setTeletext($teletext = true)
    {
        // validation for constraint: boolean
        if (!is_null($teletext) && !is_bool($teletext)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($teletext)), __LINE__);
        }
        $this->Teletext = $teletext;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\PublishToTvActionStructure
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
