<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PtConsequencesStructure StructType
 * Meta informations extracted from the WSDL
 * - documentation: Type for list of effects.
 * @subpackage Structs
 */
class PtConsequencesStructure extends AbstractStructBase
{
    /**
     * The Consequence
     * Meta informations extracted from the WSDL
     * - documentation: Nature of the effect to disrupt (or restore) service, and further details.
     * - maxOccurs: unbounded
     * @var \StructType\PtConsequenceStructure[]
     */
    public $Consequence;
    /**
     * Constructor method for PtConsequencesStructure
     * @uses PtConsequencesStructure::setConsequence()
     * @param \StructType\PtConsequenceStructure[] $consequence
     */
    public function __construct(array $consequence = array())
    {
        $this
            ->setConsequence($consequence);
    }
    /**
     * Get Consequence value
     * @return \StructType\PtConsequenceStructure[]|null
     */
    public function getConsequence()
    {
        return $this->Consequence;
    }
    /**
     * Set Consequence value
     * @throws \InvalidArgumentException
     * @param \StructType\PtConsequenceStructure[] $consequence
     * @return \StructType\PtConsequencesStructure
     */
    public function setConsequence(array $consequence = array())
    {
        foreach ($consequence as $ptConsequencesStructureConsequenceItem) {
            // validation for constraint: itemType
            if (!$ptConsequencesStructureConsequenceItem instanceof \StructType\PtConsequenceStructure) {
                throw new \InvalidArgumentException(sprintf('The Consequence property can only contain items of \StructType\PtConsequenceStructure, "%s" given', is_object($ptConsequencesStructureConsequenceItem) ? get_class($ptConsequencesStructureConsequenceItem) : gettype($ptConsequencesStructureConsequenceItem)), __LINE__);
            }
        }
        $this->Consequence = $consequence;
        return $this;
    }
    /**
     * Add item to Consequence value
     * @throws \InvalidArgumentException
     * @param \StructType\PtConsequenceStructure $item
     * @return \StructType\PtConsequencesStructure
     */
    public function addToConsequence(\StructType\PtConsequenceStructure $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\PtConsequenceStructure) {
            throw new \InvalidArgumentException(sprintf('The Consequence property can only contain items of \StructType\PtConsequenceStructure, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Consequence[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\PtConsequencesStructure
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
