<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ProducerResponseStructure StructType
 * Meta informations extracted from the WSDL
 * - documentation: Type for General SIRI Producer Response. | If request has been proxied by an intermediate aggregating system , tracking information relating to the original requestor. This allows the aggregation to be stateless. +SIRI 2.0
 * @subpackage Structs
 */
class ProducerResponseStructure extends ResponseStructure
{
    /**
     * The ProducerRef
     * @var \StructType\ParticipantRefStructure
     */
    public $ProducerRef;
    /**
     * The Address
     * Meta informations extracted from the WSDL
     * - documentation: Type for a endpoint.
     * @var string
     */
    public $Address;
    /**
     * The ResponseMessageIdentifier
     * @var \StructType\MessageQualifierStructure
     */
    public $ResponseMessageIdentifier;
    /**
     * The RequestMessageRef
     * @var \StructType\MessageRefStructure
     */
    public $RequestMessageRef;
    /**
     * The DelegatorAddress
     * Meta informations extracted from the WSDL
     * - documentation: Type for a endpoint.
     * @var string
     */
    public $DelegatorAddress;
    /**
     * The DelegatorRef
     * @var \StructType\ParticipantRefStructure
     */
    public $DelegatorRef;
    /**
     * Constructor method for ProducerResponseStructure
     * @uses ProducerResponseStructure::setProducerRef()
     * @uses ProducerResponseStructure::setAddress()
     * @uses ProducerResponseStructure::setResponseMessageIdentifier()
     * @uses ProducerResponseStructure::setRequestMessageRef()
     * @uses ProducerResponseStructure::setDelegatorAddress()
     * @uses ProducerResponseStructure::setDelegatorRef()
     * @param \StructType\ParticipantRefStructure $producerRef
     * @param string $address
     * @param \StructType\MessageQualifierStructure $responseMessageIdentifier
     * @param \StructType\MessageRefStructure $requestMessageRef
     * @param string $delegatorAddress
     * @param \StructType\ParticipantRefStructure $delegatorRef
     */
    public function __construct(\StructType\ParticipantRefStructure $producerRef = null, $address = null, \StructType\MessageQualifierStructure $responseMessageIdentifier = null, \StructType\MessageRefStructure $requestMessageRef = null, $delegatorAddress = null, \StructType\ParticipantRefStructure $delegatorRef = null)
    {
        $this
            ->setProducerRef($producerRef)
            ->setAddress($address)
            ->setResponseMessageIdentifier($responseMessageIdentifier)
            ->setRequestMessageRef($requestMessageRef)
            ->setDelegatorAddress($delegatorAddress)
            ->setDelegatorRef($delegatorRef);
    }
    /**
     * Get ProducerRef value
     * @return \StructType\ParticipantRefStructure|null
     */
    public function getProducerRef()
    {
        return $this->ProducerRef;
    }
    /**
     * Set ProducerRef value
     * @param \StructType\ParticipantRefStructure $producerRef
     * @return \StructType\ProducerResponseStructure
     */
    public function setProducerRef(\StructType\ParticipantRefStructure $producerRef = null)
    {
        $this->ProducerRef = $producerRef;
        return $this;
    }
    /**
     * Get Address value
     * @return string|null
     */
    public function getAddress()
    {
        return $this->Address;
    }
    /**
     * Set Address value
     * @param string $address
     * @return \StructType\ProducerResponseStructure
     */
    public function setAddress($address = null)
    {
        // validation for constraint: string
        if (!is_null($address) && !is_string($address)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($address)), __LINE__);
        }
        $this->Address = $address;
        return $this;
    }
    /**
     * Get ResponseMessageIdentifier value
     * @return \StructType\MessageQualifierStructure|null
     */
    public function getResponseMessageIdentifier()
    {
        return $this->ResponseMessageIdentifier;
    }
    /**
     * Set ResponseMessageIdentifier value
     * @param \StructType\MessageQualifierStructure $responseMessageIdentifier
     * @return \StructType\ProducerResponseStructure
     */
    public function setResponseMessageIdentifier(\StructType\MessageQualifierStructure $responseMessageIdentifier = null)
    {
        $this->ResponseMessageIdentifier = $responseMessageIdentifier;
        return $this;
    }
    /**
     * Get RequestMessageRef value
     * @return \StructType\MessageRefStructure|null
     */
    public function getRequestMessageRef()
    {
        return $this->RequestMessageRef;
    }
    /**
     * Set RequestMessageRef value
     * @param \StructType\MessageRefStructure $requestMessageRef
     * @return \StructType\ProducerResponseStructure
     */
    public function setRequestMessageRef(\StructType\MessageRefStructure $requestMessageRef = null)
    {
        $this->RequestMessageRef = $requestMessageRef;
        return $this;
    }
    /**
     * Get DelegatorAddress value
     * @return string|null
     */
    public function getDelegatorAddress()
    {
        return $this->DelegatorAddress;
    }
    /**
     * Set DelegatorAddress value
     * @param string $delegatorAddress
     * @return \StructType\ProducerResponseStructure
     */
    public function setDelegatorAddress($delegatorAddress = null)
    {
        // validation for constraint: string
        if (!is_null($delegatorAddress) && !is_string($delegatorAddress)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($delegatorAddress)), __LINE__);
        }
        $this->DelegatorAddress = $delegatorAddress;
        return $this;
    }
    /**
     * Get DelegatorRef value
     * @return \StructType\ParticipantRefStructure|null
     */
    public function getDelegatorRef()
    {
        return $this->DelegatorRef;
    }
    /**
     * Set DelegatorRef value
     * @param \StructType\ParticipantRefStructure $delegatorRef
     * @return \StructType\ProducerResponseStructure
     */
    public function setDelegatorRef(\StructType\ParticipantRefStructure $delegatorRef = null)
    {
        $this->DelegatorRef = $delegatorRef;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ProducerResponseStructure
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
