<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PredictionQualityStructure StructType
 * Meta informations extracted from the WSDL
 * - documentation: Type for Prediction Quality quantifcation.
 * @subpackage Structs
 */
class PredictionQualityStructure extends AbstractStructBase
{
    /**
     * The PredictionLevel
     * Meta informations extracted from the WSDL
     * - documentation: An approxiimate characterisation of prediction quality as one of five values . +SIRI v2.0
     * @var string
     */
    public $PredictionLevel;
    /**
     * The Percentile
     * Meta informations extracted from the WSDL
     * - default: 0.9
     * - documentation: Percentile associated with range as specified by lower and upper bound +SIRI v2.0
     * - minOccurs: 0
     * @var float
     */
    public $Percentile;
    /**
     * The LowerTimeLimit
     * Meta informations extracted from the WSDL
     * - documentation: Lower bound on time of for prediction for confidence level if different from defaults +SIRI v2.0
     * - minOccurs: 0
     * @var string
     */
    public $LowerTimeLimit;
    /**
     * The HigherTimeLimit
     * Meta informations extracted from the WSDL
     * - documentation: Upper bound on time of for predictios for confidence level if different from defaults +SIRI v2.0
     * - minOccurs: 0
     * @var string
     */
    public $HigherTimeLimit;
    /**
     * Constructor method for PredictionQualityStructure
     * @uses PredictionQualityStructure::setPredictionLevel()
     * @uses PredictionQualityStructure::setPercentile()
     * @uses PredictionQualityStructure::setLowerTimeLimit()
     * @uses PredictionQualityStructure::setHigherTimeLimit()
     * @param string $predictionLevel
     * @param float $percentile
     * @param string $lowerTimeLimit
     * @param string $higherTimeLimit
     */
    public function __construct($predictionLevel = null, $percentile = 0.9, $lowerTimeLimit = null, $higherTimeLimit = null)
    {
        $this
            ->setPredictionLevel($predictionLevel)
            ->setPercentile($percentile)
            ->setLowerTimeLimit($lowerTimeLimit)
            ->setHigherTimeLimit($higherTimeLimit);
    }
    /**
     * Get PredictionLevel value
     * @return string|null
     */
    public function getPredictionLevel()
    {
        return $this->PredictionLevel;
    }
    /**
     * Set PredictionLevel value
     * @uses \EnumType\QualityIndexEnumeration::valueIsValid()
     * @uses \EnumType\QualityIndexEnumeration::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $predictionLevel
     * @return \StructType\PredictionQualityStructure
     */
    public function setPredictionLevel($predictionLevel = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\QualityIndexEnumeration::valueIsValid($predictionLevel)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $predictionLevel, implode(', ', \EnumType\QualityIndexEnumeration::getValidValues())), __LINE__);
        }
        $this->PredictionLevel = $predictionLevel;
        return $this;
    }
    /**
     * Get Percentile value
     * @return float|null
     */
    public function getPercentile()
    {
        return $this->Percentile;
    }
    /**
     * Set Percentile value
     * @param float $percentile
     * @return \StructType\PredictionQualityStructure
     */
    public function setPercentile($percentile = 0.9)
    {
        $this->Percentile = $percentile;
        return $this;
    }
    /**
     * Get LowerTimeLimit value
     * @return string|null
     */
    public function getLowerTimeLimit()
    {
        return $this->LowerTimeLimit;
    }
    /**
     * Set LowerTimeLimit value
     * @param string $lowerTimeLimit
     * @return \StructType\PredictionQualityStructure
     */
    public function setLowerTimeLimit($lowerTimeLimit = null)
    {
        // validation for constraint: string
        if (!is_null($lowerTimeLimit) && !is_string($lowerTimeLimit)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($lowerTimeLimit)), __LINE__);
        }
        $this->LowerTimeLimit = $lowerTimeLimit;
        return $this;
    }
    /**
     * Get HigherTimeLimit value
     * @return string|null
     */
    public function getHigherTimeLimit()
    {
        return $this->HigherTimeLimit;
    }
    /**
     * Set HigherTimeLimit value
     * @param string $higherTimeLimit
     * @return \StructType\PredictionQualityStructure
     */
    public function setHigherTimeLimit($higherTimeLimit = null)
    {
        // validation for constraint: string
        if (!is_null($higherTimeLimit) && !is_string($higherTimeLimit)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($higherTimeLimit)), __LINE__);
        }
        $this->HigherTimeLimit = $higherTimeLimit;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\PredictionQualityStructure
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
