<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PredefinedLocationsPublication StructType
 * @subpackage Structs
 */
class PredefinedLocationsPublication extends PayloadPublication
{
    /**
     * The headerInformation
     * @var \StructType\HeaderInformation
     */
    public $headerInformation;
    /**
     * The predefinedLocationSet
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * @var \StructType\PredefinedLocationSet[]
     */
    public $predefinedLocationSet;
    /**
     * The predefinedLocationsPublicationExtension
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\ExtensionType
     */
    public $predefinedLocationsPublicationExtension;
    /**
     * Constructor method for PredefinedLocationsPublication
     * @uses PredefinedLocationsPublication::setHeaderInformation()
     * @uses PredefinedLocationsPublication::setPredefinedLocationSet()
     * @uses PredefinedLocationsPublication::setPredefinedLocationsPublicationExtension()
     * @param \StructType\HeaderInformation $headerInformation
     * @param \StructType\PredefinedLocationSet[] $predefinedLocationSet
     * @param \StructType\ExtensionType $predefinedLocationsPublicationExtension
     */
    public function __construct(\StructType\HeaderInformation $headerInformation = null, array $predefinedLocationSet = array(), \StructType\ExtensionType $predefinedLocationsPublicationExtension = null)
    {
        $this
            ->setHeaderInformation($headerInformation)
            ->setPredefinedLocationSet($predefinedLocationSet)
            ->setPredefinedLocationsPublicationExtension($predefinedLocationsPublicationExtension);
    }
    /**
     * Get headerInformation value
     * @return \StructType\HeaderInformation|null
     */
    public function getHeaderInformation()
    {
        return $this->headerInformation;
    }
    /**
     * Set headerInformation value
     * @param \StructType\HeaderInformation $headerInformation
     * @return \StructType\PredefinedLocationsPublication
     */
    public function setHeaderInformation(\StructType\HeaderInformation $headerInformation = null)
    {
        $this->headerInformation = $headerInformation;
        return $this;
    }
    /**
     * Get predefinedLocationSet value
     * @return \StructType\PredefinedLocationSet[]|null
     */
    public function getPredefinedLocationSet()
    {
        return $this->predefinedLocationSet;
    }
    /**
     * Set predefinedLocationSet value
     * @throws \InvalidArgumentException
     * @param \StructType\PredefinedLocationSet[] $predefinedLocationSet
     * @return \StructType\PredefinedLocationsPublication
     */
    public function setPredefinedLocationSet(array $predefinedLocationSet = array())
    {
        foreach ($predefinedLocationSet as $predefinedLocationsPublicationPredefinedLocationSetItem) {
            // validation for constraint: itemType
            if (!$predefinedLocationsPublicationPredefinedLocationSetItem instanceof \StructType\PredefinedLocationSet) {
                throw new \InvalidArgumentException(sprintf('The predefinedLocationSet property can only contain items of \StructType\PredefinedLocationSet, "%s" given', is_object($predefinedLocationsPublicationPredefinedLocationSetItem) ? get_class($predefinedLocationsPublicationPredefinedLocationSetItem) : gettype($predefinedLocationsPublicationPredefinedLocationSetItem)), __LINE__);
            }
        }
        $this->predefinedLocationSet = $predefinedLocationSet;
        return $this;
    }
    /**
     * Add item to predefinedLocationSet value
     * @throws \InvalidArgumentException
     * @param \StructType\PredefinedLocationSet $item
     * @return \StructType\PredefinedLocationsPublication
     */
    public function addToPredefinedLocationSet(\StructType\PredefinedLocationSet $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\PredefinedLocationSet) {
            throw new \InvalidArgumentException(sprintf('The predefinedLocationSet property can only contain items of \StructType\PredefinedLocationSet, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->predefinedLocationSet[] = $item;
        return $this;
    }
    /**
     * Get predefinedLocationsPublicationExtension value
     * @return \StructType\ExtensionType|null
     */
    public function getPredefinedLocationsPublicationExtension()
    {
        return $this->predefinedLocationsPublicationExtension;
    }
    /**
     * Set predefinedLocationsPublicationExtension value
     * @param \StructType\ExtensionType $predefinedLocationsPublicationExtension
     * @return \StructType\PredefinedLocationsPublication
     */
    public function setPredefinedLocationsPublicationExtension(\StructType\ExtensionType $predefinedLocationsPublicationExtension = null)
    {
        $this->predefinedLocationsPublicationExtension = $predefinedLocationsPublicationExtension;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\PredefinedLocationsPublication
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
