<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PrecipitationInformation StructType
 * @subpackage Structs
 */
class PrecipitationInformation extends WeatherValue
{
    /**
     * The noPrecipitation
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $noPrecipitation;
    /**
     * The precipitationDetail
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\PrecipitationDetail
     */
    public $precipitationDetail;
    /**
     * The precipitationInformationExtension
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\ExtensionType
     */
    public $precipitationInformationExtension;
    /**
     * Constructor method for PrecipitationInformation
     * @uses PrecipitationInformation::setNoPrecipitation()
     * @uses PrecipitationInformation::setPrecipitationDetail()
     * @uses PrecipitationInformation::setPrecipitationInformationExtension()
     * @param bool $noPrecipitation
     * @param \StructType\PrecipitationDetail $precipitationDetail
     * @param \StructType\ExtensionType $precipitationInformationExtension
     */
    public function __construct($noPrecipitation = null, \StructType\PrecipitationDetail $precipitationDetail = null, \StructType\ExtensionType $precipitationInformationExtension = null)
    {
        $this
            ->setNoPrecipitation($noPrecipitation)
            ->setPrecipitationDetail($precipitationDetail)
            ->setPrecipitationInformationExtension($precipitationInformationExtension);
    }
    /**
     * Get noPrecipitation value
     * @return bool|null
     */
    public function getNoPrecipitation()
    {
        return $this->noPrecipitation;
    }
    /**
     * Set noPrecipitation value
     * @param bool $noPrecipitation
     * @return \StructType\PrecipitationInformation
     */
    public function setNoPrecipitation($noPrecipitation = null)
    {
        // validation for constraint: boolean
        if (!is_null($noPrecipitation) && !is_bool($noPrecipitation)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($noPrecipitation)), __LINE__);
        }
        $this->noPrecipitation = $noPrecipitation;
        return $this;
    }
    /**
     * Get precipitationDetail value
     * @return \StructType\PrecipitationDetail|null
     */
    public function getPrecipitationDetail()
    {
        return $this->precipitationDetail;
    }
    /**
     * Set precipitationDetail value
     * @param \StructType\PrecipitationDetail $precipitationDetail
     * @return \StructType\PrecipitationInformation
     */
    public function setPrecipitationDetail(\StructType\PrecipitationDetail $precipitationDetail = null)
    {
        $this->precipitationDetail = $precipitationDetail;
        return $this;
    }
    /**
     * Get precipitationInformationExtension value
     * @return \StructType\ExtensionType|null
     */
    public function getPrecipitationInformationExtension()
    {
        return $this->precipitationInformationExtension;
    }
    /**
     * Set precipitationInformationExtension value
     * @param \StructType\ExtensionType $precipitationInformationExtension
     * @return \StructType\PrecipitationInformation
     */
    public function setPrecipitationInformationExtension(\StructType\ExtensionType $precipitationInformationExtension = null)
    {
        $this->precipitationInformationExtension = $precipitationInformationExtension;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\PrecipitationInformation
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
