<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PointDestination StructType
 * @subpackage Structs
 */
class PointDestination extends Destination
{
    /**
     * The point
     * @var \StructType\Point
     */
    public $point;
    /**
     * The pointDestinationExtension
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\ExtensionType
     */
    public $pointDestinationExtension;
    /**
     * Constructor method for PointDestination
     * @uses PointDestination::setPoint()
     * @uses PointDestination::setPointDestinationExtension()
     * @param \StructType\Point $point
     * @param \StructType\ExtensionType $pointDestinationExtension
     */
    public function __construct(\StructType\Point $point = null, \StructType\ExtensionType $pointDestinationExtension = null)
    {
        $this
            ->setPoint($point)
            ->setPointDestinationExtension($pointDestinationExtension);
    }
    /**
     * Get point value
     * @return \StructType\Point|null
     */
    public function getPoint()
    {
        return $this->point;
    }
    /**
     * Set point value
     * @param \StructType\Point $point
     * @return \StructType\PointDestination
     */
    public function setPoint(\StructType\Point $point = null)
    {
        $this->point = $point;
        return $this;
    }
    /**
     * Get pointDestinationExtension value
     * @return \StructType\ExtensionType|null
     */
    public function getPointDestinationExtension()
    {
        return $this->pointDestinationExtension;
    }
    /**
     * Set pointDestinationExtension value
     * @param \StructType\ExtensionType $pointDestinationExtension
     * @return \StructType\PointDestination
     */
    public function setPointDestinationExtension(\StructType\ExtensionType $pointDestinationExtension = null)
    {
        $this->pointDestinationExtension = $pointDestinationExtension;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\PointDestination
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
