<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PlannedStopAssignmentStructure StructType
 * Meta informations extracted from the WSDL
 * - documentation: Type for assignment of a SCHEDULED STOP POINT to a specific QUAY or platform +SIRI v2.0.
 * @subpackage Structs
 */
class PlannedStopAssignmentStructure extends AbstractStructBase
{
    /**
     * The AimedQuayRef
     * Meta informations extracted from the WSDL
     * - documentation: Physical QUAY to use according to the planned timetable. +SIRI v2.0
     * - minOccurs: 0
     * @var \StructType\QuayRefStructure
     */
    public $AimedQuayRef;
    /**
     * The AimedQuayName
     * Meta informations extracted from the WSDL
     * - documentation: Scheduled Platform name. +SIRI v2.0
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\NaturalLanguageStringStructure[]
     */
    public $AimedQuayName;
    /**
     * Constructor method for PlannedStopAssignmentStructure
     * @uses PlannedStopAssignmentStructure::setAimedQuayRef()
     * @uses PlannedStopAssignmentStructure::setAimedQuayName()
     * @param \StructType\QuayRefStructure $aimedQuayRef
     * @param \StructType\NaturalLanguageStringStructure[] $aimedQuayName
     */
    public function __construct(\StructType\QuayRefStructure $aimedQuayRef = null, array $aimedQuayName = array())
    {
        $this
            ->setAimedQuayRef($aimedQuayRef)
            ->setAimedQuayName($aimedQuayName);
    }
    /**
     * Get AimedQuayRef value
     * @return \StructType\QuayRefStructure|null
     */
    public function getAimedQuayRef()
    {
        return $this->AimedQuayRef;
    }
    /**
     * Set AimedQuayRef value
     * @param \StructType\QuayRefStructure $aimedQuayRef
     * @return \StructType\PlannedStopAssignmentStructure
     */
    public function setAimedQuayRef(\StructType\QuayRefStructure $aimedQuayRef = null)
    {
        $this->AimedQuayRef = $aimedQuayRef;
        return $this;
    }
    /**
     * Get AimedQuayName value
     * @return \StructType\NaturalLanguageStringStructure[]|null
     */
    public function getAimedQuayName()
    {
        return $this->AimedQuayName;
    }
    /**
     * Set AimedQuayName value
     * @throws \InvalidArgumentException
     * @param \StructType\NaturalLanguageStringStructure[] $aimedQuayName
     * @return \StructType\PlannedStopAssignmentStructure
     */
    public function setAimedQuayName(array $aimedQuayName = array())
    {
        foreach ($aimedQuayName as $plannedStopAssignmentStructureAimedQuayNameItem) {
            // validation for constraint: itemType
            if (!$plannedStopAssignmentStructureAimedQuayNameItem instanceof \StructType\NaturalLanguageStringStructure) {
                throw new \InvalidArgumentException(sprintf('The AimedQuayName property can only contain items of \StructType\NaturalLanguageStringStructure, "%s" given', is_object($plannedStopAssignmentStructureAimedQuayNameItem) ? get_class($plannedStopAssignmentStructureAimedQuayNameItem) : gettype($plannedStopAssignmentStructureAimedQuayNameItem)), __LINE__);
            }
        }
        $this->AimedQuayName = $aimedQuayName;
        return $this;
    }
    /**
     * Add item to AimedQuayName value
     * @throws \InvalidArgumentException
     * @param \StructType\NaturalLanguageStringStructure $item
     * @return \StructType\PlannedStopAssignmentStructure
     */
    public function addToAimedQuayName(\StructType\NaturalLanguageStringStructure $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\NaturalLanguageStringStructure) {
            throw new \InvalidArgumentException(sprintf('The AimedQuayName property can only contain items of \StructType\NaturalLanguageStringStructure, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->AimedQuayName[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\PlannedStopAssignmentStructure
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
