<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Places StructType
 * Meta informations extracted from the WSDL
 * - documentation: Places other than STOP POINTs affected by SITUATION.
 * @subpackage Structs
 */
class Places extends AbstractStructBase
{
    /**
     * The AffectedPlace
     * Meta informations extracted from the WSDL
     * - documentation: Stop affected by SITUATION.
     * - maxOccurs: unbounded
     * @var \StructType\AffectedPlaceStructure[]
     */
    public $AffectedPlace;
    /**
     * Constructor method for Places
     * @uses Places::setAffectedPlace()
     * @param \StructType\AffectedPlaceStructure[] $affectedPlace
     */
    public function __construct(array $affectedPlace = array())
    {
        $this
            ->setAffectedPlace($affectedPlace);
    }
    /**
     * Get AffectedPlace value
     * @return \StructType\AffectedPlaceStructure[]|null
     */
    public function getAffectedPlace()
    {
        return $this->AffectedPlace;
    }
    /**
     * Set AffectedPlace value
     * @throws \InvalidArgumentException
     * @param \StructType\AffectedPlaceStructure[] $affectedPlace
     * @return \StructType\Places
     */
    public function setAffectedPlace(array $affectedPlace = array())
    {
        foreach ($affectedPlace as $placesAffectedPlaceItem) {
            // validation for constraint: itemType
            if (!$placesAffectedPlaceItem instanceof \StructType\AffectedPlaceStructure) {
                throw new \InvalidArgumentException(sprintf('The AffectedPlace property can only contain items of \StructType\AffectedPlaceStructure, "%s" given', is_object($placesAffectedPlaceItem) ? get_class($placesAffectedPlaceItem) : gettype($placesAffectedPlaceItem)), __LINE__);
            }
        }
        $this->AffectedPlace = $affectedPlace;
        return $this;
    }
    /**
     * Add item to AffectedPlace value
     * @throws \InvalidArgumentException
     * @param \StructType\AffectedPlaceStructure $item
     * @return \StructType\Places
     */
    public function addToAffectedPlace(\StructType\AffectedPlaceStructure $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\AffectedPlaceStructure) {
            throw new \InvalidArgumentException(sprintf('The AffectedPlace property can only contain items of \StructType\AffectedPlaceStructure, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->AffectedPlace[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Places
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
