<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ParametersIgnoredErrorStructure StructType
 * Meta informations extracted from the WSDL
 * - documentation: Type for Parameters Ignored Error:. +SIRI v2.0.
 * @subpackage Structs
 */
class ParametersIgnoredErrorStructure extends ErrorCodeStructure
{
    /**
     * The ParameterName
     * Meta informations extracted from the WSDL
     * - documentation: Name of the unsupported parameter.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var string[]
     */
    public $ParameterName;
    /**
     * Constructor method for ParametersIgnoredErrorStructure
     * @uses ParametersIgnoredErrorStructure::setParameterName()
     * @param string[] $parameterName
     */
    public function __construct(array $parameterName = array())
    {
        $this
            ->setParameterName($parameterName);
    }
    /**
     * Get ParameterName value
     * @return string[]|null
     */
    public function getParameterName()
    {
        return $this->ParameterName;
    }
    /**
     * Set ParameterName value
     * @throws \InvalidArgumentException
     * @param string[] $parameterName
     * @return \StructType\ParametersIgnoredErrorStructure
     */
    public function setParameterName(array $parameterName = array())
    {
        foreach ($parameterName as $parametersIgnoredErrorStructureParameterNameItem) {
            // validation for constraint: itemType
            if (!is_string($parametersIgnoredErrorStructureParameterNameItem)) {
                throw new \InvalidArgumentException(sprintf('The ParameterName property can only contain items of string, "%s" given', is_object($parametersIgnoredErrorStructureParameterNameItem) ? get_class($parametersIgnoredErrorStructureParameterNameItem) : gettype($parametersIgnoredErrorStructureParameterNameItem)), __LINE__);
            }
        }
        $this->ParameterName = $parameterName;
        return $this;
    }
    /**
     * Add item to ParameterName value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \StructType\ParametersIgnoredErrorStructure
     */
    public function addToParameterName($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The ParameterName property can only contain items of string, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->ParameterName[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ParametersIgnoredErrorStructure
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
