<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for OptionalTrafficElementStructure StructType
 * Meta informations extracted from the WSDL
 * - documentation: An event which is not planned by the traffic OPERATOR, which is affecting, or has the potential to affect traffic flow. This SIRI-SX element embeds the Datex2 TrafficElement, making all elements optional because they may
 * alternatvielky be specified by common SIRI-SRX SITUATION elements.
 * @subpackage Structs
 */
abstract class OptionalTrafficElementStructure extends AbstractStructBase
{
    /**
     * The situationRecordCreationReference
     * Meta informations extracted from the WSDL
     * - maxLength: 1024
     * @var string
     */
    public $situationRecordCreationReference;
    /**
     * The situationRecordCreationTime
     * @var string
     */
    public $situationRecordCreationTime;
    /**
     * The situationRecordObservationTime
     * @var string
     */
    public $situationRecordObservationTime;
    /**
     * The situationRecordVersion
     * @var int
     */
    public $situationRecordVersion;
    /**
     * The situationRecordVersionTime
     * @var string
     */
    public $situationRecordVersionTime;
    /**
     * The situationRecordFirstSupplierVersionTime
     * @var string
     */
    public $situationRecordFirstSupplierVersionTime;
    /**
     * The probabilityOfOccurrence
     * @var string
     */
    public $probabilityOfOccurrence;
    /**
     * The Source
     * @var \StructType\Source
     */
    public $Source;
    /**
     * The validity
     * @var \StructType\Validity
     */
    public $validity;
    /**
     * The impact
     * @var \StructType\Impact
     */
    public $impact;
    /**
     * The cause
     * @var \StructType\Cause
     */
    public $cause;
    /**
     * The generalPublicComment
     * @var \StructType\Comment
     */
    public $generalPublicComment;
    /**
     * The nonGeneralPublicComment
     * @var \StructType\Comment
     */
    public $nonGeneralPublicComment;
    /**
     * The groupOfLocations
     * @var \StructType\GroupOfLocations
     */
    public $groupOfLocations;
    /**
     * The management
     * @var \StructType\Management
     */
    public $management;
    /**
     * The situationRecordExtension
     * @var \StructType\ExtensionType
     */
    public $situationRecordExtension;
    /**
     * The trafficElementExtension
     * @var \StructType\ExtensionType
     */
    public $trafficElementExtension;
    /**
     * Constructor method for OptionalTrafficElementStructure
     * @uses OptionalTrafficElementStructure::setSituationRecordCreationReference()
     * @uses OptionalTrafficElementStructure::setSituationRecordCreationTime()
     * @uses OptionalTrafficElementStructure::setSituationRecordObservationTime()
     * @uses OptionalTrafficElementStructure::setSituationRecordVersion()
     * @uses OptionalTrafficElementStructure::setSituationRecordVersionTime()
     * @uses OptionalTrafficElementStructure::setSituationRecordFirstSupplierVersionTime()
     * @uses OptionalTrafficElementStructure::setProbabilityOfOccurrence()
     * @uses OptionalTrafficElementStructure::setSource()
     * @uses OptionalTrafficElementStructure::setValidity()
     * @uses OptionalTrafficElementStructure::setImpact()
     * @uses OptionalTrafficElementStructure::setCause()
     * @uses OptionalTrafficElementStructure::setGeneralPublicComment()
     * @uses OptionalTrafficElementStructure::setNonGeneralPublicComment()
     * @uses OptionalTrafficElementStructure::setGroupOfLocations()
     * @uses OptionalTrafficElementStructure::setManagement()
     * @uses OptionalTrafficElementStructure::setSituationRecordExtension()
     * @uses OptionalTrafficElementStructure::setTrafficElementExtension()
     * @param string $situationRecordCreationReference
     * @param string $situationRecordCreationTime
     * @param string $situationRecordObservationTime
     * @param int $situationRecordVersion
     * @param string $situationRecordVersionTime
     * @param string $situationRecordFirstSupplierVersionTime
     * @param string $probabilityOfOccurrence
     * @param \StructType\Source $source
     * @param \StructType\Validity $validity
     * @param \StructType\Impact $impact
     * @param \StructType\Cause $cause
     * @param \StructType\Comment $generalPublicComment
     * @param \StructType\Comment $nonGeneralPublicComment
     * @param \StructType\GroupOfLocations $groupOfLocations
     * @param \StructType\Management $management
     * @param \StructType\ExtensionType $situationRecordExtension
     * @param \StructType\ExtensionType $trafficElementExtension
     */
    public function __construct($situationRecordCreationReference = null, $situationRecordCreationTime = null, $situationRecordObservationTime = null, $situationRecordVersion = null, $situationRecordVersionTime = null, $situationRecordFirstSupplierVersionTime = null, $probabilityOfOccurrence = null, \StructType\Source $source = null, \StructType\Validity $validity = null, \StructType\Impact $impact = null, \StructType\Cause $cause = null, \StructType\Comment $generalPublicComment = null, \StructType\Comment $nonGeneralPublicComment = null, \StructType\GroupOfLocations $groupOfLocations = null, \StructType\Management $management = null, \StructType\ExtensionType $situationRecordExtension = null, \StructType\ExtensionType $trafficElementExtension = null)
    {
        $this
            ->setSituationRecordCreationReference($situationRecordCreationReference)
            ->setSituationRecordCreationTime($situationRecordCreationTime)
            ->setSituationRecordObservationTime($situationRecordObservationTime)
            ->setSituationRecordVersion($situationRecordVersion)
            ->setSituationRecordVersionTime($situationRecordVersionTime)
            ->setSituationRecordFirstSupplierVersionTime($situationRecordFirstSupplierVersionTime)
            ->setProbabilityOfOccurrence($probabilityOfOccurrence)
            ->setSource($source)
            ->setValidity($validity)
            ->setImpact($impact)
            ->setCause($cause)
            ->setGeneralPublicComment($generalPublicComment)
            ->setNonGeneralPublicComment($nonGeneralPublicComment)
            ->setGroupOfLocations($groupOfLocations)
            ->setManagement($management)
            ->setSituationRecordExtension($situationRecordExtension)
            ->setTrafficElementExtension($trafficElementExtension);
    }
    /**
     * Get situationRecordCreationReference value
     * @return string|null
     */
    public function getSituationRecordCreationReference()
    {
        return $this->situationRecordCreationReference;
    }
    /**
     * Set situationRecordCreationReference value
     * @param string $situationRecordCreationReference
     * @return \StructType\OptionalTrafficElementStructure
     */
    public function setSituationRecordCreationReference($situationRecordCreationReference = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($situationRecordCreationReference) && strlen($situationRecordCreationReference) > 1024) || (is_array($situationRecordCreationReference) && count($situationRecordCreationReference) > 1024)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 1024 element(s) or a scalar of 1024 character(s) at most, "%d" length given', is_scalar($situationRecordCreationReference) ? strlen($situationRecordCreationReference) : count($situationRecordCreationReference)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($situationRecordCreationReference) && !is_string($situationRecordCreationReference)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($situationRecordCreationReference)), __LINE__);
        }
        $this->situationRecordCreationReference = $situationRecordCreationReference;
        return $this;
    }
    /**
     * Get situationRecordCreationTime value
     * @return string|null
     */
    public function getSituationRecordCreationTime()
    {
        return $this->situationRecordCreationTime;
    }
    /**
     * Set situationRecordCreationTime value
     * @param string $situationRecordCreationTime
     * @return \StructType\OptionalTrafficElementStructure
     */
    public function setSituationRecordCreationTime($situationRecordCreationTime = null)
    {
        // validation for constraint: string
        if (!is_null($situationRecordCreationTime) && !is_string($situationRecordCreationTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($situationRecordCreationTime)), __LINE__);
        }
        $this->situationRecordCreationTime = $situationRecordCreationTime;
        return $this;
    }
    /**
     * Get situationRecordObservationTime value
     * @return string|null
     */
    public function getSituationRecordObservationTime()
    {
        return $this->situationRecordObservationTime;
    }
    /**
     * Set situationRecordObservationTime value
     * @param string $situationRecordObservationTime
     * @return \StructType\OptionalTrafficElementStructure
     */
    public function setSituationRecordObservationTime($situationRecordObservationTime = null)
    {
        // validation for constraint: string
        if (!is_null($situationRecordObservationTime) && !is_string($situationRecordObservationTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($situationRecordObservationTime)), __LINE__);
        }
        $this->situationRecordObservationTime = $situationRecordObservationTime;
        return $this;
    }
    /**
     * Get situationRecordVersion value
     * @return int|null
     */
    public function getSituationRecordVersion()
    {
        return $this->situationRecordVersion;
    }
    /**
     * Set situationRecordVersion value
     * @param int $situationRecordVersion
     * @return \StructType\OptionalTrafficElementStructure
     */
    public function setSituationRecordVersion($situationRecordVersion = null)
    {
        // validation for constraint: int
        if (!is_null($situationRecordVersion) && !is_numeric($situationRecordVersion)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($situationRecordVersion)), __LINE__);
        }
        $this->situationRecordVersion = $situationRecordVersion;
        return $this;
    }
    /**
     * Get situationRecordVersionTime value
     * @return string|null
     */
    public function getSituationRecordVersionTime()
    {
        return $this->situationRecordVersionTime;
    }
    /**
     * Set situationRecordVersionTime value
     * @param string $situationRecordVersionTime
     * @return \StructType\OptionalTrafficElementStructure
     */
    public function setSituationRecordVersionTime($situationRecordVersionTime = null)
    {
        // validation for constraint: string
        if (!is_null($situationRecordVersionTime) && !is_string($situationRecordVersionTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($situationRecordVersionTime)), __LINE__);
        }
        $this->situationRecordVersionTime = $situationRecordVersionTime;
        return $this;
    }
    /**
     * Get situationRecordFirstSupplierVersionTime value
     * @return string|null
     */
    public function getSituationRecordFirstSupplierVersionTime()
    {
        return $this->situationRecordFirstSupplierVersionTime;
    }
    /**
     * Set situationRecordFirstSupplierVersionTime value
     * @param string $situationRecordFirstSupplierVersionTime
     * @return \StructType\OptionalTrafficElementStructure
     */
    public function setSituationRecordFirstSupplierVersionTime($situationRecordFirstSupplierVersionTime = null)
    {
        // validation for constraint: string
        if (!is_null($situationRecordFirstSupplierVersionTime) && !is_string($situationRecordFirstSupplierVersionTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($situationRecordFirstSupplierVersionTime)), __LINE__);
        }
        $this->situationRecordFirstSupplierVersionTime = $situationRecordFirstSupplierVersionTime;
        return $this;
    }
    /**
     * Get probabilityOfOccurrence value
     * @return string|null
     */
    public function getProbabilityOfOccurrence()
    {
        return $this->probabilityOfOccurrence;
    }
    /**
     * Set probabilityOfOccurrence value
     * @uses \EnumType\ProbabilityOfOccurrenceEnum::valueIsValid()
     * @uses \EnumType\ProbabilityOfOccurrenceEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $probabilityOfOccurrence
     * @return \StructType\OptionalTrafficElementStructure
     */
    public function setProbabilityOfOccurrence($probabilityOfOccurrence = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\ProbabilityOfOccurrenceEnum::valueIsValid($probabilityOfOccurrence)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $probabilityOfOccurrence, implode(', ', \EnumType\ProbabilityOfOccurrenceEnum::getValidValues())), __LINE__);
        }
        $this->probabilityOfOccurrence = $probabilityOfOccurrence;
        return $this;
    }
    /**
     * Get Source value
     * @return \StructType\Source|null
     */
    public function getSource()
    {
        return $this->Source;
    }
    /**
     * Set Source value
     * @param \StructType\Source $source
     * @return \StructType\OptionalTrafficElementStructure
     */
    public function setSource(\StructType\Source $source = null)
    {
        $this->Source = $source;
        return $this;
    }
    /**
     * Get validity value
     * @return \StructType\Validity|null
     */
    public function getValidity()
    {
        return $this->validity;
    }
    /**
     * Set validity value
     * @param \StructType\Validity $validity
     * @return \StructType\OptionalTrafficElementStructure
     */
    public function setValidity(\StructType\Validity $validity = null)
    {
        $this->validity = $validity;
        return $this;
    }
    /**
     * Get impact value
     * @return \StructType\Impact|null
     */
    public function getImpact()
    {
        return $this->impact;
    }
    /**
     * Set impact value
     * @param \StructType\Impact $impact
     * @return \StructType\OptionalTrafficElementStructure
     */
    public function setImpact(\StructType\Impact $impact = null)
    {
        $this->impact = $impact;
        return $this;
    }
    /**
     * Get cause value
     * @return \StructType\Cause|null
     */
    public function getCause()
    {
        return $this->cause;
    }
    /**
     * Set cause value
     * @param \StructType\Cause $cause
     * @return \StructType\OptionalTrafficElementStructure
     */
    public function setCause(\StructType\Cause $cause = null)
    {
        $this->cause = $cause;
        return $this;
    }
    /**
     * Get generalPublicComment value
     * @return \StructType\Comment|null
     */
    public function getGeneralPublicComment()
    {
        return $this->generalPublicComment;
    }
    /**
     * Set generalPublicComment value
     * @param \StructType\Comment $generalPublicComment
     * @return \StructType\OptionalTrafficElementStructure
     */
    public function setGeneralPublicComment(\StructType\Comment $generalPublicComment = null)
    {
        $this->generalPublicComment = $generalPublicComment;
        return $this;
    }
    /**
     * Get nonGeneralPublicComment value
     * @return \StructType\Comment|null
     */
    public function getNonGeneralPublicComment()
    {
        return $this->nonGeneralPublicComment;
    }
    /**
     * Set nonGeneralPublicComment value
     * @param \StructType\Comment $nonGeneralPublicComment
     * @return \StructType\OptionalTrafficElementStructure
     */
    public function setNonGeneralPublicComment(\StructType\Comment $nonGeneralPublicComment = null)
    {
        $this->nonGeneralPublicComment = $nonGeneralPublicComment;
        return $this;
    }
    /**
     * Get groupOfLocations value
     * @return \StructType\GroupOfLocations|null
     */
    public function getGroupOfLocations()
    {
        return $this->groupOfLocations;
    }
    /**
     * Set groupOfLocations value
     * @param \StructType\GroupOfLocations $groupOfLocations
     * @return \StructType\OptionalTrafficElementStructure
     */
    public function setGroupOfLocations(\StructType\GroupOfLocations $groupOfLocations = null)
    {
        $this->groupOfLocations = $groupOfLocations;
        return $this;
    }
    /**
     * Get management value
     * @return \StructType\Management|null
     */
    public function getManagement()
    {
        return $this->management;
    }
    /**
     * Set management value
     * @param \StructType\Management $management
     * @return \StructType\OptionalTrafficElementStructure
     */
    public function setManagement(\StructType\Management $management = null)
    {
        $this->management = $management;
        return $this;
    }
    /**
     * Get situationRecordExtension value
     * @return \StructType\ExtensionType|null
     */
    public function getSituationRecordExtension()
    {
        return $this->situationRecordExtension;
    }
    /**
     * Set situationRecordExtension value
     * @param \StructType\ExtensionType $situationRecordExtension
     * @return \StructType\OptionalTrafficElementStructure
     */
    public function setSituationRecordExtension(\StructType\ExtensionType $situationRecordExtension = null)
    {
        $this->situationRecordExtension = $situationRecordExtension;
        return $this;
    }
    /**
     * Get trafficElementExtension value
     * @return \StructType\ExtensionType|null
     */
    public function getTrafficElementExtension()
    {
        return $this->trafficElementExtension;
    }
    /**
     * Set trafficElementExtension value
     * @param \StructType\ExtensionType $trafficElementExtension
     * @return \StructType\OptionalTrafficElementStructure
     */
    public function setTrafficElementExtension(\StructType\ExtensionType $trafficElementExtension = null)
    {
        $this->trafficElementExtension = $trafficElementExtension;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\OptionalTrafficElementStructure
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
