<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Operators StructType
 * Meta informations extracted from the WSDL
 * - documentation: Affected OPERATORs, If absent, taken from context. If present, any OPERATORs stated completely replace those from context.
 * @subpackage Structs
 */
class Operators extends AbstractStructBase
{
    /**
     * The AllOperators
     * Meta informations extracted from the WSDL
     * - documentation: All OPERATORs.
     * @var string
     */
    public $AllOperators;
    /**
     * The AffectedOperator
     * Meta informations extracted from the WSDL
     * - documentation: Operators of services affected by SITUATION.
     * - maxOccurs: unbounded
     * @var \StructType\AffectedOperatorStructure[]
     */
    public $AffectedOperator;
    /**
     * Constructor method for Operators
     * @uses Operators::setAllOperators()
     * @uses Operators::setAffectedOperator()
     * @param string $allOperators
     * @param \StructType\AffectedOperatorStructure[] $affectedOperator
     */
    public function __construct($allOperators = null, array $affectedOperator = array())
    {
        $this
            ->setAllOperators($allOperators)
            ->setAffectedOperator($affectedOperator);
    }
    /**
     * Get AllOperators value
     * @return string|null
     */
    public function getAllOperators()
    {
        return $this->AllOperators;
    }
    /**
     * Set AllOperators value
     * @uses \EnumType\EmptyType::valueIsValid()
     * @uses \EnumType\EmptyType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $allOperators
     * @return \StructType\Operators
     */
    public function setAllOperators($allOperators = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\EmptyType::valueIsValid($allOperators)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $allOperators, implode(', ', \EnumType\EmptyType::getValidValues())), __LINE__);
        }
        $this->AllOperators = $allOperators;
        return $this;
    }
    /**
     * Get AffectedOperator value
     * @return \StructType\AffectedOperatorStructure[]|null
     */
    public function getAffectedOperator()
    {
        return $this->AffectedOperator;
    }
    /**
     * Set AffectedOperator value
     * @throws \InvalidArgumentException
     * @param \StructType\AffectedOperatorStructure[] $affectedOperator
     * @return \StructType\Operators
     */
    public function setAffectedOperator(array $affectedOperator = array())
    {
        foreach ($affectedOperator as $operatorsAffectedOperatorItem) {
            // validation for constraint: itemType
            if (!$operatorsAffectedOperatorItem instanceof \StructType\AffectedOperatorStructure) {
                throw new \InvalidArgumentException(sprintf('The AffectedOperator property can only contain items of \StructType\AffectedOperatorStructure, "%s" given', is_object($operatorsAffectedOperatorItem) ? get_class($operatorsAffectedOperatorItem) : gettype($operatorsAffectedOperatorItem)), __LINE__);
            }
        }
        $this->AffectedOperator = $affectedOperator;
        return $this;
    }
    /**
     * Add item to AffectedOperator value
     * @throws \InvalidArgumentException
     * @param \StructType\AffectedOperatorStructure $item
     * @return \StructType\Operators
     */
    public function addToAffectedOperator(\StructType\AffectedOperatorStructure $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\AffectedOperatorStructure) {
            throw new \InvalidArgumentException(sprintf('The AffectedOperator property can only contain items of \StructType\AffectedOperatorStructure, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->AffectedOperator[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Operators
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
