<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for OperatorPermissions StructType
 * Meta informations extracted from the WSDL
 * - documentation: The OPERATOR data that the participant may access.
 * @subpackage Structs
 */
class OperatorPermissions extends AbstractStructBase
{
    /**
     * The AllowAll
     * Meta informations extracted from the WSDL
     * - ref: AllowAll
     * @var bool
     */
    public $AllowAll;
    /**
     * The OperatorPermission
     * Meta informations extracted from the WSDL
     * - documentation: Participant's permission for this OPERATOR.
     * - maxOccurs: unbounded
     * @var \StructType\OperatorPermissionStructure[]
     */
    public $OperatorPermission;
    /**
     * Constructor method for OperatorPermissions
     * @uses OperatorPermissions::setAllowAll()
     * @uses OperatorPermissions::setOperatorPermission()
     * @param bool $allowAll
     * @param \StructType\OperatorPermissionStructure[] $operatorPermission
     */
    public function __construct($allowAll = null, array $operatorPermission = array())
    {
        $this
            ->setAllowAll($allowAll)
            ->setOperatorPermission($operatorPermission);
    }
    /**
     * Get AllowAll value
     * @return bool|null
     */
    public function getAllowAll()
    {
        return $this->AllowAll;
    }
    /**
     * Set AllowAll value
     * @param bool $allowAll
     * @return \StructType\OperatorPermissions
     */
    public function setAllowAll($allowAll = null)
    {
        // validation for constraint: boolean
        if (!is_null($allowAll) && !is_bool($allowAll)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($allowAll)), __LINE__);
        }
        $this->AllowAll = $allowAll;
        return $this;
    }
    /**
     * Get OperatorPermission value
     * @return \StructType\OperatorPermissionStructure[]|null
     */
    public function getOperatorPermission()
    {
        return $this->OperatorPermission;
    }
    /**
     * Set OperatorPermission value
     * @throws \InvalidArgumentException
     * @param \StructType\OperatorPermissionStructure[] $operatorPermission
     * @return \StructType\OperatorPermissions
     */
    public function setOperatorPermission(array $operatorPermission = array())
    {
        foreach ($operatorPermission as $operatorPermissionsOperatorPermissionItem) {
            // validation for constraint: itemType
            if (!$operatorPermissionsOperatorPermissionItem instanceof \StructType\OperatorPermissionStructure) {
                throw new \InvalidArgumentException(sprintf('The OperatorPermission property can only contain items of \StructType\OperatorPermissionStructure, "%s" given', is_object($operatorPermissionsOperatorPermissionItem) ? get_class($operatorPermissionsOperatorPermissionItem) : gettype($operatorPermissionsOperatorPermissionItem)), __LINE__);
            }
        }
        $this->OperatorPermission = $operatorPermission;
        return $this;
    }
    /**
     * Add item to OperatorPermission value
     * @throws \InvalidArgumentException
     * @param \StructType\OperatorPermissionStructure $item
     * @return \StructType\OperatorPermissions
     */
    public function addToOperatorPermission(\StructType\OperatorPermissionStructure $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\OperatorPermissionStructure) {
            throw new \InvalidArgumentException(sprintf('The OperatorPermission property can only contain items of \StructType\OperatorPermissionStructure, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->OperatorPermission[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\OperatorPermissions
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
