<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for OperatorAction StructType
 * @subpackage Structs
 */
abstract class OperatorAction extends SituationRecord
{
    /**
     * The actionOrigin
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $actionOrigin;
    /**
     * The operatorActionStatus
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $operatorActionStatus;
    /**
     * The operatorActionExtension
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\ExtensionType
     */
    public $operatorActionExtension;
    /**
     * Constructor method for OperatorAction
     * @uses OperatorAction::setActionOrigin()
     * @uses OperatorAction::setOperatorActionStatus()
     * @uses OperatorAction::setOperatorActionExtension()
     * @param string $actionOrigin
     * @param string $operatorActionStatus
     * @param \StructType\ExtensionType $operatorActionExtension
     */
    public function __construct($actionOrigin = null, $operatorActionStatus = null, \StructType\ExtensionType $operatorActionExtension = null)
    {
        $this
            ->setActionOrigin($actionOrigin)
            ->setOperatorActionStatus($operatorActionStatus)
            ->setOperatorActionExtension($operatorActionExtension);
    }
    /**
     * Get actionOrigin value
     * @return string|null
     */
    public function getActionOrigin()
    {
        return $this->actionOrigin;
    }
    /**
     * Set actionOrigin value
     * @uses \EnumType\OperatorActionOriginEnum::valueIsValid()
     * @uses \EnumType\OperatorActionOriginEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $actionOrigin
     * @return \StructType\OperatorAction
     */
    public function setActionOrigin($actionOrigin = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\OperatorActionOriginEnum::valueIsValid($actionOrigin)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $actionOrigin, implode(', ', \EnumType\OperatorActionOriginEnum::getValidValues())), __LINE__);
        }
        $this->actionOrigin = $actionOrigin;
        return $this;
    }
    /**
     * Get operatorActionStatus value
     * @return string|null
     */
    public function getOperatorActionStatus()
    {
        return $this->operatorActionStatus;
    }
    /**
     * Set operatorActionStatus value
     * @uses \EnumType\OperatorActionStatusEnum::valueIsValid()
     * @uses \EnumType\OperatorActionStatusEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $operatorActionStatus
     * @return \StructType\OperatorAction
     */
    public function setOperatorActionStatus($operatorActionStatus = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\OperatorActionStatusEnum::valueIsValid($operatorActionStatus)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $operatorActionStatus, implode(', ', \EnumType\OperatorActionStatusEnum::getValidValues())), __LINE__);
        }
        $this->operatorActionStatus = $operatorActionStatus;
        return $this;
    }
    /**
     * Get operatorActionExtension value
     * @return \StructType\ExtensionType|null
     */
    public function getOperatorActionExtension()
    {
        return $this->operatorActionExtension;
    }
    /**
     * Set operatorActionExtension value
     * @param \StructType\ExtensionType $operatorActionExtension
     * @return \StructType\OperatorAction
     */
    public function setOperatorActionExtension(\StructType\ExtensionType $operatorActionExtension = null)
    {
        $this->operatorActionExtension = $operatorActionExtension;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\OperatorAction
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
