<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for OnwardCallsStructure StructType
 * Meta informations extracted from the WSDL
 * - documentation: Type for CALLing pattern for JOURNEY PATTERN.
 * @subpackage Structs
 */
class OnwardCallsStructure extends AbstractStructBase
{
    /**
     * The OnwardCall
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * @var \StructType\OnwardCallStructure[]
     */
    public $OnwardCall;
    /**
     * Constructor method for OnwardCallsStructure
     * @uses OnwardCallsStructure::setOnwardCall()
     * @param \StructType\OnwardCallStructure[] $onwardCall
     */
    public function __construct(array $onwardCall = array())
    {
        $this
            ->setOnwardCall($onwardCall);
    }
    /**
     * Get OnwardCall value
     * @return \StructType\OnwardCallStructure[]|null
     */
    public function getOnwardCall()
    {
        return $this->OnwardCall;
    }
    /**
     * Set OnwardCall value
     * @throws \InvalidArgumentException
     * @param \StructType\OnwardCallStructure[] $onwardCall
     * @return \StructType\OnwardCallsStructure
     */
    public function setOnwardCall(array $onwardCall = array())
    {
        foreach ($onwardCall as $onwardCallsStructureOnwardCallItem) {
            // validation for constraint: itemType
            if (!$onwardCallsStructureOnwardCallItem instanceof \StructType\OnwardCallStructure) {
                throw new \InvalidArgumentException(sprintf('The OnwardCall property can only contain items of \StructType\OnwardCallStructure, "%s" given', is_object($onwardCallsStructureOnwardCallItem) ? get_class($onwardCallsStructureOnwardCallItem) : gettype($onwardCallsStructureOnwardCallItem)), __LINE__);
            }
        }
        $this->OnwardCall = $onwardCall;
        return $this;
    }
    /**
     * Add item to OnwardCall value
     * @throws \InvalidArgumentException
     * @param \StructType\OnwardCallStructure $item
     * @return \StructType\OnwardCallsStructure
     */
    public function addToOnwardCall(\StructType\OnwardCallStructure $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\OnwardCallStructure) {
            throw new \InvalidArgumentException(sprintf('The OnwardCall property can only contain items of \StructType\OnwardCallStructure, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->OnwardCall[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\OnwardCallsStructure
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
