<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Obstruction StructType
 * @subpackage Structs
 */
abstract class Obstruction extends TrafficElement
{
    /**
     * The numberOfObstructions
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $numberOfObstructions;
    /**
     * The mobilityOfObstruction
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Mobility
     */
    public $mobilityOfObstruction;
    /**
     * The obstructionExtension
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\ExtensionType
     */
    public $obstructionExtension;
    /**
     * Constructor method for Obstruction
     * @uses Obstruction::setNumberOfObstructions()
     * @uses Obstruction::setMobilityOfObstruction()
     * @uses Obstruction::setObstructionExtension()
     * @param int $numberOfObstructions
     * @param \StructType\Mobility $mobilityOfObstruction
     * @param \StructType\ExtensionType $obstructionExtension
     */
    public function __construct($numberOfObstructions = null, \StructType\Mobility $mobilityOfObstruction = null, \StructType\ExtensionType $obstructionExtension = null)
    {
        $this
            ->setNumberOfObstructions($numberOfObstructions)
            ->setMobilityOfObstruction($mobilityOfObstruction)
            ->setObstructionExtension($obstructionExtension);
    }
    /**
     * Get numberOfObstructions value
     * @return int|null
     */
    public function getNumberOfObstructions()
    {
        return $this->numberOfObstructions;
    }
    /**
     * Set numberOfObstructions value
     * @param int $numberOfObstructions
     * @return \StructType\Obstruction
     */
    public function setNumberOfObstructions($numberOfObstructions = null)
    {
        // validation for constraint: int
        if (!is_null($numberOfObstructions) && !is_numeric($numberOfObstructions)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($numberOfObstructions)), __LINE__);
        }
        $this->numberOfObstructions = $numberOfObstructions;
        return $this;
    }
    /**
     * Get mobilityOfObstruction value
     * @return \StructType\Mobility|null
     */
    public function getMobilityOfObstruction()
    {
        return $this->mobilityOfObstruction;
    }
    /**
     * Set mobilityOfObstruction value
     * @param \StructType\Mobility $mobilityOfObstruction
     * @return \StructType\Obstruction
     */
    public function setMobilityOfObstruction(\StructType\Mobility $mobilityOfObstruction = null)
    {
        $this->mobilityOfObstruction = $mobilityOfObstruction;
        return $this;
    }
    /**
     * Get obstructionExtension value
     * @return \StructType\ExtensionType|null
     */
    public function getObstructionExtension()
    {
        return $this->obstructionExtension;
    }
    /**
     * Set obstructionExtension value
     * @param \StructType\ExtensionType $obstructionExtension
     * @return \StructType\Obstruction
     */
    public function setObstructionExtension(\StructType\ExtensionType $obstructionExtension = null)
    {
        $this->obstructionExtension = $obstructionExtension;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Obstruction
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
