<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for NumberOfAxlesCharacteristic StructType
 * @subpackage Structs
 */
class NumberOfAxlesCharacteristic extends AbstractStructBase
{
    /**
     * The comparisonOperator
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $comparisonOperator;
    /**
     * The numberOfAxles
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $numberOfAxles;
    /**
     * The numberOfAxlesCharacteristicExtension
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\ExtensionType
     */
    public $numberOfAxlesCharacteristicExtension;
    /**
     * Constructor method for NumberOfAxlesCharacteristic
     * @uses NumberOfAxlesCharacteristic::setComparisonOperator()
     * @uses NumberOfAxlesCharacteristic::setNumberOfAxles()
     * @uses NumberOfAxlesCharacteristic::setNumberOfAxlesCharacteristicExtension()
     * @param string $comparisonOperator
     * @param int $numberOfAxles
     * @param \StructType\ExtensionType $numberOfAxlesCharacteristicExtension
     */
    public function __construct($comparisonOperator = null, $numberOfAxles = null, \StructType\ExtensionType $numberOfAxlesCharacteristicExtension = null)
    {
        $this
            ->setComparisonOperator($comparisonOperator)
            ->setNumberOfAxles($numberOfAxles)
            ->setNumberOfAxlesCharacteristicExtension($numberOfAxlesCharacteristicExtension);
    }
    /**
     * Get comparisonOperator value
     * @return string
     */
    public function getComparisonOperator()
    {
        return $this->comparisonOperator;
    }
    /**
     * Set comparisonOperator value
     * @uses \EnumType\ComparisonOperatorEnum::valueIsValid()
     * @uses \EnumType\ComparisonOperatorEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $comparisonOperator
     * @return \StructType\NumberOfAxlesCharacteristic
     */
    public function setComparisonOperator($comparisonOperator = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\ComparisonOperatorEnum::valueIsValid($comparisonOperator)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $comparisonOperator, implode(', ', \EnumType\ComparisonOperatorEnum::getValidValues())), __LINE__);
        }
        $this->comparisonOperator = $comparisonOperator;
        return $this;
    }
    /**
     * Get numberOfAxles value
     * @return int
     */
    public function getNumberOfAxles()
    {
        return $this->numberOfAxles;
    }
    /**
     * Set numberOfAxles value
     * @param int $numberOfAxles
     * @return \StructType\NumberOfAxlesCharacteristic
     */
    public function setNumberOfAxles($numberOfAxles = null)
    {
        // validation for constraint: int
        if (!is_null($numberOfAxles) && !is_numeric($numberOfAxles)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($numberOfAxles)), __LINE__);
        }
        $this->numberOfAxles = $numberOfAxles;
        return $this;
    }
    /**
     * Get numberOfAxlesCharacteristicExtension value
     * @return \StructType\ExtensionType|null
     */
    public function getNumberOfAxlesCharacteristicExtension()
    {
        return $this->numberOfAxlesCharacteristicExtension;
    }
    /**
     * Set numberOfAxlesCharacteristicExtension value
     * @param \StructType\ExtensionType $numberOfAxlesCharacteristicExtension
     * @return \StructType\NumberOfAxlesCharacteristic
     */
    public function setNumberOfAxlesCharacteristicExtension(\StructType\ExtensionType $numberOfAxlesCharacteristicExtension = null)
    {
        $this->numberOfAxlesCharacteristicExtension = $numberOfAxlesCharacteristicExtension;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\NumberOfAxlesCharacteristic
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
