<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for NotifyUserActionStructure StructType
 * Meta informations extracted from the WSDL
 * - documentation: Type for Notify user by other means.
 * @subpackage Structs
 */
class NotifyUserActionStructure extends PushedActionStructure
{
    /**
     * The WorkgroupRef
     * Meta informations extracted from the WSDL
     * - default: true
     * - documentation: Workgroup of user to be notified.
     * - minOccurs: 0
     * @var string
     */
    public $WorkgroupRef;
    /**
     * The UserName
     * Meta informations extracted from the WSDL
     * - documentation: Name of user to be notified.
     * - minOccurs: 0
     * @var string
     */
    public $UserName;
    /**
     * The UserRef
     * Meta informations extracted from the WSDL
     * - default: true
     * - documentation: Reference to a user to be notified.
     * - minOccurs: 0
     * @var string
     */
    public $UserRef;
    /**
     * Constructor method for NotifyUserActionStructure
     * @uses NotifyUserActionStructure::setWorkgroupRef()
     * @uses NotifyUserActionStructure::setUserName()
     * @uses NotifyUserActionStructure::setUserRef()
     * @param string $workgroupRef
     * @param string $userName
     * @param string $userRef
     */
    public function __construct($workgroupRef = 'true', $userName = null, $userRef = 'true')
    {
        $this
            ->setWorkgroupRef($workgroupRef)
            ->setUserName($userName)
            ->setUserRef($userRef);
    }
    /**
     * Get WorkgroupRef value
     * @return string|null
     */
    public function getWorkgroupRef()
    {
        return $this->WorkgroupRef;
    }
    /**
     * Set WorkgroupRef value
     * @param string $workgroupRef
     * @return \StructType\NotifyUserActionStructure
     */
    public function setWorkgroupRef($workgroupRef = 'true')
    {
        // validation for constraint: string
        if (!is_null($workgroupRef) && !is_string($workgroupRef)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($workgroupRef)), __LINE__);
        }
        $this->WorkgroupRef = $workgroupRef;
        return $this;
    }
    /**
     * Get UserName value
     * @return string|null
     */
    public function getUserName()
    {
        return $this->UserName;
    }
    /**
     * Set UserName value
     * @param string $userName
     * @return \StructType\NotifyUserActionStructure
     */
    public function setUserName($userName = null)
    {
        // validation for constraint: string
        if (!is_null($userName) && !is_string($userName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($userName)), __LINE__);
        }
        $this->UserName = $userName;
        return $this;
    }
    /**
     * Get UserRef value
     * @return string|null
     */
    public function getUserRef()
    {
        return $this->UserRef;
    }
    /**
     * Set UserRef value
     * @param string $userRef
     * @return \StructType\NotifyUserActionStructure
     */
    public function setUserRef($userRef = 'true')
    {
        // validation for constraint: string
        if (!is_null($userRef) && !is_string($userRef)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($userRef)), __LINE__);
        }
        $this->UserRef = $userRef;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\NotifyUserActionStructure
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
