<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for NonManagedCause StructType
 * @subpackage Structs
 */
class NonManagedCause extends Cause
{
    /**
     * The causeDescription
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\MultilingualString
     */
    public $causeDescription;
    /**
     * The causeType
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $causeType;
    /**
     * The nonManagedCauseExtension
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\ExtensionType
     */
    public $nonManagedCauseExtension;
    /**
     * Constructor method for NonManagedCause
     * @uses NonManagedCause::setCauseDescription()
     * @uses NonManagedCause::setCauseType()
     * @uses NonManagedCause::setNonManagedCauseExtension()
     * @param \StructType\MultilingualString $causeDescription
     * @param string $causeType
     * @param \StructType\ExtensionType $nonManagedCauseExtension
     */
    public function __construct(\StructType\MultilingualString $causeDescription = null, $causeType = null, \StructType\ExtensionType $nonManagedCauseExtension = null)
    {
        $this
            ->setCauseDescription($causeDescription)
            ->setCauseType($causeType)
            ->setNonManagedCauseExtension($nonManagedCauseExtension);
    }
    /**
     * Get causeDescription value
     * @return \StructType\MultilingualString|null
     */
    public function getCauseDescription()
    {
        return $this->causeDescription;
    }
    /**
     * Set causeDescription value
     * @param \StructType\MultilingualString $causeDescription
     * @return \StructType\NonManagedCause
     */
    public function setCauseDescription(\StructType\MultilingualString $causeDescription = null)
    {
        $this->causeDescription = $causeDescription;
        return $this;
    }
    /**
     * Get causeType value
     * @return string|null
     */
    public function getCauseType()
    {
        return $this->causeType;
    }
    /**
     * Set causeType value
     * @uses \EnumType\CauseTypeEnum::valueIsValid()
     * @uses \EnumType\CauseTypeEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $causeType
     * @return \StructType\NonManagedCause
     */
    public function setCauseType($causeType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\CauseTypeEnum::valueIsValid($causeType)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $causeType, implode(', ', \EnumType\CauseTypeEnum::getValidValues())), __LINE__);
        }
        $this->causeType = $causeType;
        return $this;
    }
    /**
     * Get nonManagedCauseExtension value
     * @return \StructType\ExtensionType|null
     */
    public function getNonManagedCauseExtension()
    {
        return $this->nonManagedCauseExtension;
    }
    /**
     * Set nonManagedCauseExtension value
     * @param \StructType\ExtensionType $nonManagedCauseExtension
     * @return \StructType\NonManagedCause
     */
    public function setNonManagedCauseExtension(\StructType\ExtensionType $nonManagedCauseExtension = null)
    {
        $this->nonManagedCauseExtension = $nonManagedCauseExtension;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\NonManagedCause
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
