<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Networks StructType
 * Meta informations extracted from the WSDL
 * - documentation: Networks affected by SITUATION.
 * @subpackage Structs
 */
class Networks extends AbstractStructBase
{
    /**
     * The AffectedNetwork
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * @var \StructType\AffectedNetwork[]
     */
    public $AffectedNetwork;
    /**
     * Constructor method for Networks
     * @uses Networks::setAffectedNetwork()
     * @param \StructType\AffectedNetwork[] $affectedNetwork
     */
    public function __construct(array $affectedNetwork = array())
    {
        $this
            ->setAffectedNetwork($affectedNetwork);
    }
    /**
     * Get AffectedNetwork value
     * @return \StructType\AffectedNetwork[]|null
     */
    public function getAffectedNetwork()
    {
        return $this->AffectedNetwork;
    }
    /**
     * Set AffectedNetwork value
     * @throws \InvalidArgumentException
     * @param \StructType\AffectedNetwork[] $affectedNetwork
     * @return \StructType\Networks
     */
    public function setAffectedNetwork(array $affectedNetwork = array())
    {
        foreach ($affectedNetwork as $networksAffectedNetworkItem) {
            // validation for constraint: itemType
            if (!$networksAffectedNetworkItem instanceof \StructType\AffectedNetwork) {
                throw new \InvalidArgumentException(sprintf('The AffectedNetwork property can only contain items of \StructType\AffectedNetwork, "%s" given', is_object($networksAffectedNetworkItem) ? get_class($networksAffectedNetworkItem) : gettype($networksAffectedNetworkItem)), __LINE__);
            }
        }
        $this->AffectedNetwork = $affectedNetwork;
        return $this;
    }
    /**
     * Add item to AffectedNetwork value
     * @throws \InvalidArgumentException
     * @param \StructType\AffectedNetwork $item
     * @return \StructType\Networks
     */
    public function addToAffectedNetwork(\StructType\AffectedNetwork $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\AffectedNetwork) {
            throw new \InvalidArgumentException(sprintf('The AffectedNetwork property can only contain items of \StructType\AffectedNetwork, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->AffectedNetwork[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Networks
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
