<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for MonitoredFeederArrivalStructure StructType
 * Meta informations extracted from the WSDL
 * - documentation: Type for Real time connection at a stop.
 * @subpackage Structs
 */
class MonitoredFeederArrivalStructure extends AbstractFeederItemStructure
{
    /**
     * The ClearDownRef
     * Meta informations extracted from the WSDL
     * - documentation: Direct Cleardown identifier of connection arrival Activity that is being deleted.
     * - minOccurs: 0
     * @var \StructType\ClearDownRefStructure
     */
    public $ClearDownRef;
    /**
     * The FeederJourney
     * Meta informations extracted from the WSDL
     * - documentation: Information about the feeder journey.
     * @var \StructType\InterchangeJourneyStructure
     */
    public $FeederJourney;
    /**
     * The VehicleAtStop
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - ref: VehicleAtStop
     * @var bool
     */
    public $VehicleAtStop;
    /**
     * The NumberOfTransferPassengers
     * Meta informations extracted from the WSDL
     * - documentation: Number of passengers who wish to transfer at the connection. If absent, not known.
     * - minOccurs: 0
     * @var int
     */
    public $NumberOfTransferPassengers;
    /**
     * The AimedArrivalTime
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - ref: AimedArrivalTime
     * @var string
     */
    public $AimedArrivalTime;
    /**
     * The ExpectedArrivalTime
     * Meta informations extracted from the WSDL
     * - documentation: Predicted arrival time at the connection zone.
     * - minOccurs: 0
     * @var string
     */
    public $ExpectedArrivalTime;
    /**
     * The ArrivalPlatformName
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - ref: ArrivalPlatformName
     * @var \StructType\NaturalLanguageStringStructure
     */
    public $ArrivalPlatformName;
    /**
     * The SuggestedWaitDecisionTime
     * Meta informations extracted from the WSDL
     * - documentation: Latest time by which the feeder needs informationabout the connection from the distributor as to whether it will wait and for how long. +SIRI v2.0
     * - minOccurs: 0
     * @var string
     */
    public $SuggestedWaitDecisionTime;
    /**
     * The Extensions
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - ref: Extensions
     * @var \StructType\ExtensionsStructure
     */
    public $Extensions;
    /**
     * Constructor method for MonitoredFeederArrivalStructure
     * @uses MonitoredFeederArrivalStructure::setClearDownRef()
     * @uses MonitoredFeederArrivalStructure::setFeederJourney()
     * @uses MonitoredFeederArrivalStructure::setVehicleAtStop()
     * @uses MonitoredFeederArrivalStructure::setNumberOfTransferPassengers()
     * @uses MonitoredFeederArrivalStructure::setAimedArrivalTime()
     * @uses MonitoredFeederArrivalStructure::setExpectedArrivalTime()
     * @uses MonitoredFeederArrivalStructure::setArrivalPlatformName()
     * @uses MonitoredFeederArrivalStructure::setSuggestedWaitDecisionTime()
     * @uses MonitoredFeederArrivalStructure::setExtensions()
     * @param \StructType\ClearDownRefStructure $clearDownRef
     * @param \StructType\InterchangeJourneyStructure $feederJourney
     * @param bool $vehicleAtStop
     * @param int $numberOfTransferPassengers
     * @param string $aimedArrivalTime
     * @param string $expectedArrivalTime
     * @param \StructType\NaturalLanguageStringStructure $arrivalPlatformName
     * @param string $suggestedWaitDecisionTime
     * @param \StructType\ExtensionsStructure $extensions
     */
    public function __construct(\StructType\ClearDownRefStructure $clearDownRef = null, \StructType\InterchangeJourneyStructure $feederJourney = null, $vehicleAtStop = null, $numberOfTransferPassengers = null, $aimedArrivalTime = null, $expectedArrivalTime = null, \StructType\NaturalLanguageStringStructure $arrivalPlatformName = null, $suggestedWaitDecisionTime = null, \StructType\ExtensionsStructure $extensions = null)
    {
        $this
            ->setClearDownRef($clearDownRef)
            ->setFeederJourney($feederJourney)
            ->setVehicleAtStop($vehicleAtStop)
            ->setNumberOfTransferPassengers($numberOfTransferPassengers)
            ->setAimedArrivalTime($aimedArrivalTime)
            ->setExpectedArrivalTime($expectedArrivalTime)
            ->setArrivalPlatformName($arrivalPlatformName)
            ->setSuggestedWaitDecisionTime($suggestedWaitDecisionTime)
            ->setExtensions($extensions);
    }
    /**
     * Get ClearDownRef value
     * @return \StructType\ClearDownRefStructure|null
     */
    public function getClearDownRef()
    {
        return $this->ClearDownRef;
    }
    /**
     * Set ClearDownRef value
     * @param \StructType\ClearDownRefStructure $clearDownRef
     * @return \StructType\MonitoredFeederArrivalStructure
     */
    public function setClearDownRef(\StructType\ClearDownRefStructure $clearDownRef = null)
    {
        $this->ClearDownRef = $clearDownRef;
        return $this;
    }
    /**
     * Get FeederJourney value
     * @return \StructType\InterchangeJourneyStructure|null
     */
    public function getFeederJourney()
    {
        return $this->FeederJourney;
    }
    /**
     * Set FeederJourney value
     * @param \StructType\InterchangeJourneyStructure $feederJourney
     * @return \StructType\MonitoredFeederArrivalStructure
     */
    public function setFeederJourney(\StructType\InterchangeJourneyStructure $feederJourney = null)
    {
        $this->FeederJourney = $feederJourney;
        return $this;
    }
    /**
     * Get VehicleAtStop value
     * @return bool|null
     */
    public function getVehicleAtStop()
    {
        return $this->VehicleAtStop;
    }
    /**
     * Set VehicleAtStop value
     * @param bool $vehicleAtStop
     * @return \StructType\MonitoredFeederArrivalStructure
     */
    public function setVehicleAtStop($vehicleAtStop = null)
    {
        // validation for constraint: boolean
        if (!is_null($vehicleAtStop) && !is_bool($vehicleAtStop)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($vehicleAtStop)), __LINE__);
        }
        $this->VehicleAtStop = $vehicleAtStop;
        return $this;
    }
    /**
     * Get NumberOfTransferPassengers value
     * @return int|null
     */
    public function getNumberOfTransferPassengers()
    {
        return $this->NumberOfTransferPassengers;
    }
    /**
     * Set NumberOfTransferPassengers value
     * @param int $numberOfTransferPassengers
     * @return \StructType\MonitoredFeederArrivalStructure
     */
    public function setNumberOfTransferPassengers($numberOfTransferPassengers = null)
    {
        // validation for constraint: int
        if (!is_null($numberOfTransferPassengers) && !is_numeric($numberOfTransferPassengers)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($numberOfTransferPassengers)), __LINE__);
        }
        $this->NumberOfTransferPassengers = $numberOfTransferPassengers;
        return $this;
    }
    /**
     * Get AimedArrivalTime value
     * @return string|null
     */
    public function getAimedArrivalTime()
    {
        return $this->AimedArrivalTime;
    }
    /**
     * Set AimedArrivalTime value
     * @param string $aimedArrivalTime
     * @return \StructType\MonitoredFeederArrivalStructure
     */
    public function setAimedArrivalTime($aimedArrivalTime = null)
    {
        // validation for constraint: string
        if (!is_null($aimedArrivalTime) && !is_string($aimedArrivalTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($aimedArrivalTime)), __LINE__);
        }
        $this->AimedArrivalTime = $aimedArrivalTime;
        return $this;
    }
    /**
     * Get ExpectedArrivalTime value
     * @return string|null
     */
    public function getExpectedArrivalTime()
    {
        return $this->ExpectedArrivalTime;
    }
    /**
     * Set ExpectedArrivalTime value
     * @param string $expectedArrivalTime
     * @return \StructType\MonitoredFeederArrivalStructure
     */
    public function setExpectedArrivalTime($expectedArrivalTime = null)
    {
        // validation for constraint: string
        if (!is_null($expectedArrivalTime) && !is_string($expectedArrivalTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($expectedArrivalTime)), __LINE__);
        }
        $this->ExpectedArrivalTime = $expectedArrivalTime;
        return $this;
    }
    /**
     * Get ArrivalPlatformName value
     * @return \StructType\NaturalLanguageStringStructure|null
     */
    public function getArrivalPlatformName()
    {
        return $this->ArrivalPlatformName;
    }
    /**
     * Set ArrivalPlatformName value
     * @param \StructType\NaturalLanguageStringStructure $arrivalPlatformName
     * @return \StructType\MonitoredFeederArrivalStructure
     */
    public function setArrivalPlatformName(\StructType\NaturalLanguageStringStructure $arrivalPlatformName = null)
    {
        $this->ArrivalPlatformName = $arrivalPlatformName;
        return $this;
    }
    /**
     * Get SuggestedWaitDecisionTime value
     * @return string|null
     */
    public function getSuggestedWaitDecisionTime()
    {
        return $this->SuggestedWaitDecisionTime;
    }
    /**
     * Set SuggestedWaitDecisionTime value
     * @param string $suggestedWaitDecisionTime
     * @return \StructType\MonitoredFeederArrivalStructure
     */
    public function setSuggestedWaitDecisionTime($suggestedWaitDecisionTime = null)
    {
        // validation for constraint: string
        if (!is_null($suggestedWaitDecisionTime) && !is_string($suggestedWaitDecisionTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($suggestedWaitDecisionTime)), __LINE__);
        }
        $this->SuggestedWaitDecisionTime = $suggestedWaitDecisionTime;
        return $this;
    }
    /**
     * Get Extensions value
     * @return \StructType\ExtensionsStructure|null
     */
    public function getExtensions()
    {
        return $this->Extensions;
    }
    /**
     * Set Extensions value
     * @param \StructType\ExtensionsStructure $extensions
     * @return \StructType\MonitoredFeederArrivalStructure
     */
    public function setExtensions(\StructType\ExtensionsStructure $extensions = null)
    {
        $this->Extensions = $extensions;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\MonitoredFeederArrivalStructure
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
