<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for MonitoredFeederArrivalCancellationStructure StructType
 * Meta informations extracted from the WSDL
 * - documentation: Type for Deletion of a feeder connection.
 * @subpackage Structs
 */
class MonitoredFeederArrivalCancellationStructure extends AbstractFeederItemStructure
{
    /**
     * The LineRef
     * Meta informations extracted from the WSDL
     * - documentation: Reference to a LINE.
     * @var \StructType\LineRefStructure
     */
    public $LineRef;
    /**
     * The DirectionRef
     * Meta informations extracted from the WSDL
     * - documentation: Reference to a DIRECTION, typically outward or return.
     * @var \StructType\DirectionRefStructure
     */
    public $DirectionRef;
    /**
     * The VehicleJourneyRef
     * Meta informations extracted from the WSDL
     * - documentation: Reference to a Feeder VEHICLE JOURNEY.
     * @var \StructType\FramedVehicleJourneyRefStructure
     */
    public $VehicleJourneyRef;
    /**
     * The JourneyPatternRef
     * @var \StructType\JourneyPatternRefStructure
     */
    public $JourneyPatternRef;
    /**
     * The JourneyPatternName
     * @var \StructType\NaturalLanguageStringStructure
     */
    public $JourneyPatternName;
    /**
     * The VehicleMode
     * @var string
     */
    public $VehicleMode;
    /**
     * The RouteRef
     * @var \StructType\RouteRefStructure
     */
    public $RouteRef;
    /**
     * The PublishedLineName
     * @var \StructType\NaturalLanguageStringStructure
     */
    public $PublishedLineName;
    /**
     * The GroupOfLinesRef
     * @var \StructType\GroupOfLinesRefStructure
     */
    public $GroupOfLinesRef;
    /**
     * The DirectionName
     * @var \StructType\NaturalLanguageStringStructure
     */
    public $DirectionName;
    /**
     * The ExternalLineRef
     * @var \StructType\LineRefStructure
     */
    public $ExternalLineRef;
    /**
     * The Reason
     * Meta informations extracted from the WSDL
     * - documentation: Reason for cancellation. (Unbounded since SIRI 2.0)
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\NaturalLanguageStringStructure[]
     */
    public $Reason;
    /**
     * The Extensions
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - ref: Extensions
     * @var \StructType\ExtensionsStructure
     */
    public $Extensions;
    /**
     * Constructor method for MonitoredFeederArrivalCancellationStructure
     * @uses MonitoredFeederArrivalCancellationStructure::setLineRef()
     * @uses MonitoredFeederArrivalCancellationStructure::setDirectionRef()
     * @uses MonitoredFeederArrivalCancellationStructure::setVehicleJourneyRef()
     * @uses MonitoredFeederArrivalCancellationStructure::setJourneyPatternRef()
     * @uses MonitoredFeederArrivalCancellationStructure::setJourneyPatternName()
     * @uses MonitoredFeederArrivalCancellationStructure::setVehicleMode()
     * @uses MonitoredFeederArrivalCancellationStructure::setRouteRef()
     * @uses MonitoredFeederArrivalCancellationStructure::setPublishedLineName()
     * @uses MonitoredFeederArrivalCancellationStructure::setGroupOfLinesRef()
     * @uses MonitoredFeederArrivalCancellationStructure::setDirectionName()
     * @uses MonitoredFeederArrivalCancellationStructure::setExternalLineRef()
     * @uses MonitoredFeederArrivalCancellationStructure::setReason()
     * @uses MonitoredFeederArrivalCancellationStructure::setExtensions()
     * @param \StructType\LineRefStructure $lineRef
     * @param \StructType\DirectionRefStructure $directionRef
     * @param \StructType\FramedVehicleJourneyRefStructure $vehicleJourneyRef
     * @param \StructType\JourneyPatternRefStructure $journeyPatternRef
     * @param \StructType\NaturalLanguageStringStructure $journeyPatternName
     * @param string $vehicleMode
     * @param \StructType\RouteRefStructure $routeRef
     * @param \StructType\NaturalLanguageStringStructure $publishedLineName
     * @param \StructType\GroupOfLinesRefStructure $groupOfLinesRef
     * @param \StructType\NaturalLanguageStringStructure $directionName
     * @param \StructType\LineRefStructure $externalLineRef
     * @param \StructType\NaturalLanguageStringStructure[] $reason
     * @param \StructType\ExtensionsStructure $extensions
     */
    public function __construct(\StructType\LineRefStructure $lineRef = null, \StructType\DirectionRefStructure $directionRef = null, \StructType\FramedVehicleJourneyRefStructure $vehicleJourneyRef = null, \StructType\JourneyPatternRefStructure $journeyPatternRef = null, \StructType\NaturalLanguageStringStructure $journeyPatternName = null, $vehicleMode = null, \StructType\RouteRefStructure $routeRef = null, \StructType\NaturalLanguageStringStructure $publishedLineName = null, \StructType\GroupOfLinesRefStructure $groupOfLinesRef = null, \StructType\NaturalLanguageStringStructure $directionName = null, \StructType\LineRefStructure $externalLineRef = null, array $reason = array(), \StructType\ExtensionsStructure $extensions = null)
    {
        $this
            ->setLineRef($lineRef)
            ->setDirectionRef($directionRef)
            ->setVehicleJourneyRef($vehicleJourneyRef)
            ->setJourneyPatternRef($journeyPatternRef)
            ->setJourneyPatternName($journeyPatternName)
            ->setVehicleMode($vehicleMode)
            ->setRouteRef($routeRef)
            ->setPublishedLineName($publishedLineName)
            ->setGroupOfLinesRef($groupOfLinesRef)
            ->setDirectionName($directionName)
            ->setExternalLineRef($externalLineRef)
            ->setReason($reason)
            ->setExtensions($extensions);
    }
    /**
     * Get LineRef value
     * @return \StructType\LineRefStructure|null
     */
    public function getLineRef()
    {
        return $this->LineRef;
    }
    /**
     * Set LineRef value
     * @param \StructType\LineRefStructure $lineRef
     * @return \StructType\MonitoredFeederArrivalCancellationStructure
     */
    public function setLineRef(\StructType\LineRefStructure $lineRef = null)
    {
        $this->LineRef = $lineRef;
        return $this;
    }
    /**
     * Get DirectionRef value
     * @return \StructType\DirectionRefStructure|null
     */
    public function getDirectionRef()
    {
        return $this->DirectionRef;
    }
    /**
     * Set DirectionRef value
     * @param \StructType\DirectionRefStructure $directionRef
     * @return \StructType\MonitoredFeederArrivalCancellationStructure
     */
    public function setDirectionRef(\StructType\DirectionRefStructure $directionRef = null)
    {
        $this->DirectionRef = $directionRef;
        return $this;
    }
    /**
     * Get VehicleJourneyRef value
     * @return \StructType\FramedVehicleJourneyRefStructure|null
     */
    public function getVehicleJourneyRef()
    {
        return $this->VehicleJourneyRef;
    }
    /**
     * Set VehicleJourneyRef value
     * @param \StructType\FramedVehicleJourneyRefStructure $vehicleJourneyRef
     * @return \StructType\MonitoredFeederArrivalCancellationStructure
     */
    public function setVehicleJourneyRef(\StructType\FramedVehicleJourneyRefStructure $vehicleJourneyRef = null)
    {
        $this->VehicleJourneyRef = $vehicleJourneyRef;
        return $this;
    }
    /**
     * Get JourneyPatternRef value
     * @return \StructType\JourneyPatternRefStructure|null
     */
    public function getJourneyPatternRef()
    {
        return $this->JourneyPatternRef;
    }
    /**
     * Set JourneyPatternRef value
     * @param \StructType\JourneyPatternRefStructure $journeyPatternRef
     * @return \StructType\MonitoredFeederArrivalCancellationStructure
     */
    public function setJourneyPatternRef(\StructType\JourneyPatternRefStructure $journeyPatternRef = null)
    {
        $this->JourneyPatternRef = $journeyPatternRef;
        return $this;
    }
    /**
     * Get JourneyPatternName value
     * @return \StructType\NaturalLanguageStringStructure|null
     */
    public function getJourneyPatternName()
    {
        return $this->JourneyPatternName;
    }
    /**
     * Set JourneyPatternName value
     * @param \StructType\NaturalLanguageStringStructure $journeyPatternName
     * @return \StructType\MonitoredFeederArrivalCancellationStructure
     */
    public function setJourneyPatternName(\StructType\NaturalLanguageStringStructure $journeyPatternName = null)
    {
        $this->JourneyPatternName = $journeyPatternName;
        return $this;
    }
    /**
     * Get VehicleMode value
     * @return string|null
     */
    public function getVehicleMode()
    {
        return $this->VehicleMode;
    }
    /**
     * Set VehicleMode value
     * @uses \EnumType\VehicleModesEnumeration::valueIsValid()
     * @uses \EnumType\VehicleModesEnumeration::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $vehicleMode
     * @return \StructType\MonitoredFeederArrivalCancellationStructure
     */
    public function setVehicleMode($vehicleMode = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\VehicleModesEnumeration::valueIsValid($vehicleMode)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $vehicleMode, implode(', ', \EnumType\VehicleModesEnumeration::getValidValues())), __LINE__);
        }
        $this->VehicleMode = $vehicleMode;
        return $this;
    }
    /**
     * Get RouteRef value
     * @return \StructType\RouteRefStructure|null
     */
    public function getRouteRef()
    {
        return $this->RouteRef;
    }
    /**
     * Set RouteRef value
     * @param \StructType\RouteRefStructure $routeRef
     * @return \StructType\MonitoredFeederArrivalCancellationStructure
     */
    public function setRouteRef(\StructType\RouteRefStructure $routeRef = null)
    {
        $this->RouteRef = $routeRef;
        return $this;
    }
    /**
     * Get PublishedLineName value
     * @return \StructType\NaturalLanguageStringStructure|null
     */
    public function getPublishedLineName()
    {
        return $this->PublishedLineName;
    }
    /**
     * Set PublishedLineName value
     * @param \StructType\NaturalLanguageStringStructure $publishedLineName
     * @return \StructType\MonitoredFeederArrivalCancellationStructure
     */
    public function setPublishedLineName(\StructType\NaturalLanguageStringStructure $publishedLineName = null)
    {
        $this->PublishedLineName = $publishedLineName;
        return $this;
    }
    /**
     * Get GroupOfLinesRef value
     * @return \StructType\GroupOfLinesRefStructure|null
     */
    public function getGroupOfLinesRef()
    {
        return $this->GroupOfLinesRef;
    }
    /**
     * Set GroupOfLinesRef value
     * @param \StructType\GroupOfLinesRefStructure $groupOfLinesRef
     * @return \StructType\MonitoredFeederArrivalCancellationStructure
     */
    public function setGroupOfLinesRef(\StructType\GroupOfLinesRefStructure $groupOfLinesRef = null)
    {
        $this->GroupOfLinesRef = $groupOfLinesRef;
        return $this;
    }
    /**
     * Get DirectionName value
     * @return \StructType\NaturalLanguageStringStructure|null
     */
    public function getDirectionName()
    {
        return $this->DirectionName;
    }
    /**
     * Set DirectionName value
     * @param \StructType\NaturalLanguageStringStructure $directionName
     * @return \StructType\MonitoredFeederArrivalCancellationStructure
     */
    public function setDirectionName(\StructType\NaturalLanguageStringStructure $directionName = null)
    {
        $this->DirectionName = $directionName;
        return $this;
    }
    /**
     * Get ExternalLineRef value
     * @return \StructType\LineRefStructure|null
     */
    public function getExternalLineRef()
    {
        return $this->ExternalLineRef;
    }
    /**
     * Set ExternalLineRef value
     * @param \StructType\LineRefStructure $externalLineRef
     * @return \StructType\MonitoredFeederArrivalCancellationStructure
     */
    public function setExternalLineRef(\StructType\LineRefStructure $externalLineRef = null)
    {
        $this->ExternalLineRef = $externalLineRef;
        return $this;
    }
    /**
     * Get Reason value
     * @return \StructType\NaturalLanguageStringStructure[]|null
     */
    public function getReason()
    {
        return $this->Reason;
    }
    /**
     * Set Reason value
     * @throws \InvalidArgumentException
     * @param \StructType\NaturalLanguageStringStructure[] $reason
     * @return \StructType\MonitoredFeederArrivalCancellationStructure
     */
    public function setReason(array $reason = array())
    {
        foreach ($reason as $monitoredFeederArrivalCancellationStructureReasonItem) {
            // validation for constraint: itemType
            if (!$monitoredFeederArrivalCancellationStructureReasonItem instanceof \StructType\NaturalLanguageStringStructure) {
                throw new \InvalidArgumentException(sprintf('The Reason property can only contain items of \StructType\NaturalLanguageStringStructure, "%s" given', is_object($monitoredFeederArrivalCancellationStructureReasonItem) ? get_class($monitoredFeederArrivalCancellationStructureReasonItem) : gettype($monitoredFeederArrivalCancellationStructureReasonItem)), __LINE__);
            }
        }
        $this->Reason = $reason;
        return $this;
    }
    /**
     * Add item to Reason value
     * @throws \InvalidArgumentException
     * @param \StructType\NaturalLanguageStringStructure $item
     * @return \StructType\MonitoredFeederArrivalCancellationStructure
     */
    public function addToReason(\StructType\NaturalLanguageStringStructure $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\NaturalLanguageStringStructure) {
            throw new \InvalidArgumentException(sprintf('The Reason property can only contain items of \StructType\NaturalLanguageStringStructure, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Reason[] = $item;
        return $this;
    }
    /**
     * Get Extensions value
     * @return \StructType\ExtensionsStructure|null
     */
    public function getExtensions()
    {
        return $this->Extensions;
    }
    /**
     * Set Extensions value
     * @param \StructType\ExtensionsStructure $extensions
     * @return \StructType\MonitoredFeederArrivalCancellationStructure
     */
    public function setExtensions(\StructType\ExtensionsStructure $extensions = null)
    {
        $this->Extensions = $extensions;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\MonitoredFeederArrivalCancellationStructure
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
