<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Mode StructType
 * Meta informations extracted from the WSDL
 * - documentation: Mode affected by SITUATION.
 * @subpackage Structs
 */
class Mode extends AbstractStructBase
{
    /**
     * The VehicleMode
     * @var string
     */
    public $VehicleMode;
    /**
     * The AirSubmode
     * @var string
     */
    public $AirSubmode;
    /**
     * The BusSubmode
     * @var string
     */
    public $BusSubmode;
    /**
     * The CoachSubmode
     * @var string
     */
    public $CoachSubmode;
    /**
     * The MetroSubmode
     * @var string
     */
    public $MetroSubmode;
    /**
     * The RailSubmode
     * @var string
     */
    public $RailSubmode;
    /**
     * The TramSubmode
     * @var string
     */
    public $TramSubmode;
    /**
     * The WaterSubmode
     * @var string
     */
    public $WaterSubmode;
    /**
     * The AccessMode
     * @var string
     */
    public $AccessMode;
    /**
     * Constructor method for Mode
     * @uses Mode::setVehicleMode()
     * @uses Mode::setAirSubmode()
     * @uses Mode::setBusSubmode()
     * @uses Mode::setCoachSubmode()
     * @uses Mode::setMetroSubmode()
     * @uses Mode::setRailSubmode()
     * @uses Mode::setTramSubmode()
     * @uses Mode::setWaterSubmode()
     * @uses Mode::setAccessMode()
     * @param string $vehicleMode
     * @param string $airSubmode
     * @param string $busSubmode
     * @param string $coachSubmode
     * @param string $metroSubmode
     * @param string $railSubmode
     * @param string $tramSubmode
     * @param string $waterSubmode
     * @param string $accessMode
     */
    public function __construct($vehicleMode = null, $airSubmode = null, $busSubmode = null, $coachSubmode = null, $metroSubmode = null, $railSubmode = null, $tramSubmode = null, $waterSubmode = null, $accessMode = null)
    {
        $this
            ->setVehicleMode($vehicleMode)
            ->setAirSubmode($airSubmode)
            ->setBusSubmode($busSubmode)
            ->setCoachSubmode($coachSubmode)
            ->setMetroSubmode($metroSubmode)
            ->setRailSubmode($railSubmode)
            ->setTramSubmode($tramSubmode)
            ->setWaterSubmode($waterSubmode)
            ->setAccessMode($accessMode);
    }
    /**
     * Get VehicleMode value
     * @return string|null
     */
    public function getVehicleMode()
    {
        return $this->VehicleMode;
    }
    /**
     * Set VehicleMode value
     * @uses \EnumType\VehicleModesOfTransportEnumeration::valueIsValid()
     * @uses \EnumType\VehicleModesOfTransportEnumeration::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $vehicleMode
     * @return \StructType\Mode
     */
    public function setVehicleMode($vehicleMode = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\VehicleModesOfTransportEnumeration::valueIsValid($vehicleMode)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $vehicleMode, implode(', ', \EnumType\VehicleModesOfTransportEnumeration::getValidValues())), __LINE__);
        }
        $this->VehicleMode = $vehicleMode;
        return $this;
    }
    /**
     * Get AirSubmode value
     * @return string|null
     */
    public function getAirSubmode()
    {
        return $this->AirSubmode;
    }
    /**
     * Set AirSubmode value
     * @uses \EnumType\AirSubmodesOfTransportEnumeration::valueIsValid()
     * @uses \EnumType\AirSubmodesOfTransportEnumeration::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $airSubmode
     * @return \StructType\Mode
     */
    public function setAirSubmode($airSubmode = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\AirSubmodesOfTransportEnumeration::valueIsValid($airSubmode)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $airSubmode, implode(', ', \EnumType\AirSubmodesOfTransportEnumeration::getValidValues())), __LINE__);
        }
        $this->AirSubmode = $airSubmode;
        return $this;
    }
    /**
     * Get BusSubmode value
     * @return string|null
     */
    public function getBusSubmode()
    {
        return $this->BusSubmode;
    }
    /**
     * Set BusSubmode value
     * @uses \EnumType\BusSubmodesOfTransportEnumeration::valueIsValid()
     * @uses \EnumType\BusSubmodesOfTransportEnumeration::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $busSubmode
     * @return \StructType\Mode
     */
    public function setBusSubmode($busSubmode = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\BusSubmodesOfTransportEnumeration::valueIsValid($busSubmode)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $busSubmode, implode(', ', \EnumType\BusSubmodesOfTransportEnumeration::getValidValues())), __LINE__);
        }
        $this->BusSubmode = $busSubmode;
        return $this;
    }
    /**
     * Get CoachSubmode value
     * @return string|null
     */
    public function getCoachSubmode()
    {
        return $this->CoachSubmode;
    }
    /**
     * Set CoachSubmode value
     * @uses \EnumType\CoachSubmodesOfTransportEnumeration::valueIsValid()
     * @uses \EnumType\CoachSubmodesOfTransportEnumeration::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $coachSubmode
     * @return \StructType\Mode
     */
    public function setCoachSubmode($coachSubmode = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\CoachSubmodesOfTransportEnumeration::valueIsValid($coachSubmode)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $coachSubmode, implode(', ', \EnumType\CoachSubmodesOfTransportEnumeration::getValidValues())), __LINE__);
        }
        $this->CoachSubmode = $coachSubmode;
        return $this;
    }
    /**
     * Get MetroSubmode value
     * @return string|null
     */
    public function getMetroSubmode()
    {
        return $this->MetroSubmode;
    }
    /**
     * Set MetroSubmode value
     * @uses \EnumType\MetroSubmodesOfTransportEnumeration::valueIsValid()
     * @uses \EnumType\MetroSubmodesOfTransportEnumeration::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $metroSubmode
     * @return \StructType\Mode
     */
    public function setMetroSubmode($metroSubmode = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\MetroSubmodesOfTransportEnumeration::valueIsValid($metroSubmode)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $metroSubmode, implode(', ', \EnumType\MetroSubmodesOfTransportEnumeration::getValidValues())), __LINE__);
        }
        $this->MetroSubmode = $metroSubmode;
        return $this;
    }
    /**
     * Get RailSubmode value
     * @return string|null
     */
    public function getRailSubmode()
    {
        return $this->RailSubmode;
    }
    /**
     * Set RailSubmode value
     * @uses \EnumType\RailSubmodesOfTransportEnumeration::valueIsValid()
     * @uses \EnumType\RailSubmodesOfTransportEnumeration::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $railSubmode
     * @return \StructType\Mode
     */
    public function setRailSubmode($railSubmode = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\RailSubmodesOfTransportEnumeration::valueIsValid($railSubmode)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $railSubmode, implode(', ', \EnumType\RailSubmodesOfTransportEnumeration::getValidValues())), __LINE__);
        }
        $this->RailSubmode = $railSubmode;
        return $this;
    }
    /**
     * Get TramSubmode value
     * @return string|null
     */
    public function getTramSubmode()
    {
        return $this->TramSubmode;
    }
    /**
     * Set TramSubmode value
     * @uses \EnumType\TramSubmodesOfTransportEnumeration::valueIsValid()
     * @uses \EnumType\TramSubmodesOfTransportEnumeration::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $tramSubmode
     * @return \StructType\Mode
     */
    public function setTramSubmode($tramSubmode = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\TramSubmodesOfTransportEnumeration::valueIsValid($tramSubmode)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $tramSubmode, implode(', ', \EnumType\TramSubmodesOfTransportEnumeration::getValidValues())), __LINE__);
        }
        $this->TramSubmode = $tramSubmode;
        return $this;
    }
    /**
     * Get WaterSubmode value
     * @return string|null
     */
    public function getWaterSubmode()
    {
        return $this->WaterSubmode;
    }
    /**
     * Set WaterSubmode value
     * @uses \EnumType\WaterSubmodesOfTransportEnumeration::valueIsValid()
     * @uses \EnumType\WaterSubmodesOfTransportEnumeration::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $waterSubmode
     * @return \StructType\Mode
     */
    public function setWaterSubmode($waterSubmode = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\WaterSubmodesOfTransportEnumeration::valueIsValid($waterSubmode)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $waterSubmode, implode(', ', \EnumType\WaterSubmodesOfTransportEnumeration::getValidValues())), __LINE__);
        }
        $this->WaterSubmode = $waterSubmode;
        return $this;
    }
    /**
     * Get AccessMode value
     * @return string|null
     */
    public function getAccessMode()
    {
        return $this->AccessMode;
    }
    /**
     * Set AccessMode value
     * @uses \EnumType\AccessModesEnumeration::valueIsValid()
     * @uses \EnumType\AccessModesEnumeration::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $accessMode
     * @return \StructType\Mode
     */
    public function setAccessMode($accessMode = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\AccessModesEnumeration::valueIsValid($accessMode)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $accessMode, implode(', ', \EnumType\AccessModesEnumeration::getValidValues())), __LINE__);
        }
        $this->AccessMode = $accessMode;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Mode
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
