<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for MobilityDisruptionStructure StructType
 * Meta informations extracted from the WSDL
 * - documentation: Type for effect of EQUIPMENT availability change on impaired access users. | Classification of Mobility Facility type - Based on Tpeg pti23.
 * @subpackage Structs
 */
class MobilityDisruptionStructure extends AbstractStructBase
{
    /**
     * The MobilityImpairedAccess
     * Meta informations extracted from the WSDL
     * - documentation: Whether stop or service is accessible to mobility impaired users. This may be further qualified by one ore more MobilityFacility instances to specify which types of mobility access are available (true) or not available (false). For
     * example suitableForWheelChair, or 'tepFreeAccess.
     * @var bool
     */
    public $MobilityImpairedAccess;
    /**
     * The AccessFacility
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - ref: AccessFacility
     * @var string[]
     */
    public $AccessFacility;
    /**
     * Constructor method for MobilityDisruptionStructure
     * @uses MobilityDisruptionStructure::setMobilityImpairedAccess()
     * @uses MobilityDisruptionStructure::setAccessFacility()
     * @param bool $mobilityImpairedAccess
     * @param string[] $accessFacility
     */
    public function __construct($mobilityImpairedAccess = null, array $accessFacility = array())
    {
        $this
            ->setMobilityImpairedAccess($mobilityImpairedAccess)
            ->setAccessFacility($accessFacility);
    }
    /**
     * Get MobilityImpairedAccess value
     * @return bool|null
     */
    public function getMobilityImpairedAccess()
    {
        return $this->MobilityImpairedAccess;
    }
    /**
     * Set MobilityImpairedAccess value
     * @param bool $mobilityImpairedAccess
     * @return \StructType\MobilityDisruptionStructure
     */
    public function setMobilityImpairedAccess($mobilityImpairedAccess = null)
    {
        // validation for constraint: boolean
        if (!is_null($mobilityImpairedAccess) && !is_bool($mobilityImpairedAccess)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($mobilityImpairedAccess)), __LINE__);
        }
        $this->MobilityImpairedAccess = $mobilityImpairedAccess;
        return $this;
    }
    /**
     * Get AccessFacility value
     * @return string[]|null
     */
    public function getAccessFacility()
    {
        return $this->AccessFacility;
    }
    /**
     * Set AccessFacility value
     * @uses \EnumType\AccessFacilityEnumeration::valueIsValid()
     * @uses \EnumType\AccessFacilityEnumeration::getValidValues()
     * @throws \InvalidArgumentException
     * @param string[] $accessFacility
     * @return \StructType\MobilityDisruptionStructure
     */
    public function setAccessFacility(array $accessFacility = array())
    {
        $invalidValues = array();
        foreach ($accessFacility as $mobilityDisruptionStructureAccessFacilityItem) {
            if (!\EnumType\AccessFacilityEnumeration::valueIsValid($mobilityDisruptionStructureAccessFacilityItem)) {
                $invalidValues[] = var_export($mobilityDisruptionStructureAccessFacilityItem, true);
            }
        }
        if (!empty($invalidValues)) {
            throw new \InvalidArgumentException(sprintf('Value(s) "%s" is/are invalid, please use one of: %s', implode(', ', $invalidValues), implode(', ', \EnumType\AccessFacilityEnumeration::getValidValues())), __LINE__);
        }
        $this->AccessFacility = $accessFacility;
        return $this;
    }
    /**
     * Add item to AccessFacility value
     * @uses \EnumType\AccessFacilityEnumeration::valueIsValid()
     * @uses \EnumType\AccessFacilityEnumeration::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \StructType\MobilityDisruptionStructure
     */
    public function addToAccessFacility($item)
    {
        // validation for constraint: enumeration
        if (!\EnumType\AccessFacilityEnumeration::valueIsValid($item)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $item, implode(', ', \EnumType\AccessFacilityEnumeration::getValidValues())), __LINE__);
        }
        $this->AccessFacility[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\MobilityDisruptionStructure
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
