<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for MeasurementSpecificCharacteristics StructType
 * @subpackage Structs
 */
class MeasurementSpecificCharacteristics_1 extends AbstractStructBase
{
    /**
     * The specificMeasurementValueType
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $specificMeasurementValueType;
    /**
     * The accuracy
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var float
     */
    public $accuracy;
    /**
     * The period
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var float
     */
    public $period;
    /**
     * The smoothingFactor
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var float
     */
    public $smoothingFactor;
    /**
     * The specificLane
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $specificLane;
    /**
     * The specificVehicleCharacteristics
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\VehicleCharacteristics
     */
    public $specificVehicleCharacteristics;
    /**
     * The measurementSpecificCharacteristicsExtension
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\ExtensionType
     */
    public $measurementSpecificCharacteristicsExtension;
    /**
     * Constructor method for MeasurementSpecificCharacteristics
     * @uses MeasurementSpecificCharacteristics_1::setSpecificMeasurementValueType()
     * @uses MeasurementSpecificCharacteristics_1::setAccuracy()
     * @uses MeasurementSpecificCharacteristics_1::setPeriod()
     * @uses MeasurementSpecificCharacteristics_1::setSmoothingFactor()
     * @uses MeasurementSpecificCharacteristics_1::setSpecificLane()
     * @uses MeasurementSpecificCharacteristics_1::setSpecificVehicleCharacteristics()
     * @uses MeasurementSpecificCharacteristics_1::setMeasurementSpecificCharacteristicsExtension()
     * @param string $specificMeasurementValueType
     * @param float $accuracy
     * @param float $period
     * @param float $smoothingFactor
     * @param string $specificLane
     * @param \StructType\VehicleCharacteristics $specificVehicleCharacteristics
     * @param \StructType\ExtensionType $measurementSpecificCharacteristicsExtension
     */
    public function __construct($specificMeasurementValueType = null, $accuracy = null, $period = null, $smoothingFactor = null, $specificLane = null, \StructType\VehicleCharacteristics $specificVehicleCharacteristics = null, \StructType\ExtensionType $measurementSpecificCharacteristicsExtension = null)
    {
        $this
            ->setSpecificMeasurementValueType($specificMeasurementValueType)
            ->setAccuracy($accuracy)
            ->setPeriod($period)
            ->setSmoothingFactor($smoothingFactor)
            ->setSpecificLane($specificLane)
            ->setSpecificVehicleCharacteristics($specificVehicleCharacteristics)
            ->setMeasurementSpecificCharacteristicsExtension($measurementSpecificCharacteristicsExtension);
    }
    /**
     * Get specificMeasurementValueType value
     * @return string
     */
    public function getSpecificMeasurementValueType()
    {
        return $this->specificMeasurementValueType;
    }
    /**
     * Set specificMeasurementValueType value
     * @uses \EnumType\MeasuredOrDerivedDataTypeEnum::valueIsValid()
     * @uses \EnumType\MeasuredOrDerivedDataTypeEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $specificMeasurementValueType
     * @return \StructType\MeasurementSpecificCharacteristics_1
     */
    public function setSpecificMeasurementValueType($specificMeasurementValueType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\MeasuredOrDerivedDataTypeEnum::valueIsValid($specificMeasurementValueType)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $specificMeasurementValueType, implode(', ', \EnumType\MeasuredOrDerivedDataTypeEnum::getValidValues())), __LINE__);
        }
        $this->specificMeasurementValueType = $specificMeasurementValueType;
        return $this;
    }
    /**
     * Get accuracy value
     * @return float|null
     */
    public function getAccuracy()
    {
        return $this->accuracy;
    }
    /**
     * Set accuracy value
     * @param float $accuracy
     * @return \StructType\MeasurementSpecificCharacteristics_1
     */
    public function setAccuracy($accuracy = null)
    {
        $this->accuracy = $accuracy;
        return $this;
    }
    /**
     * Get period value
     * @return float|null
     */
    public function getPeriod()
    {
        return $this->period;
    }
    /**
     * Set period value
     * @param float $period
     * @return \StructType\MeasurementSpecificCharacteristics_1
     */
    public function setPeriod($period = null)
    {
        $this->period = $period;
        return $this;
    }
    /**
     * Get smoothingFactor value
     * @return float|null
     */
    public function getSmoothingFactor()
    {
        return $this->smoothingFactor;
    }
    /**
     * Set smoothingFactor value
     * @param float $smoothingFactor
     * @return \StructType\MeasurementSpecificCharacteristics_1
     */
    public function setSmoothingFactor($smoothingFactor = null)
    {
        $this->smoothingFactor = $smoothingFactor;
        return $this;
    }
    /**
     * Get specificLane value
     * @return string|null
     */
    public function getSpecificLane()
    {
        return $this->specificLane;
    }
    /**
     * Set specificLane value
     * @uses \EnumType\LaneEnum::valueIsValid()
     * @uses \EnumType\LaneEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $specificLane
     * @return \StructType\MeasurementSpecificCharacteristics_1
     */
    public function setSpecificLane($specificLane = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\LaneEnum::valueIsValid($specificLane)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $specificLane, implode(', ', \EnumType\LaneEnum::getValidValues())), __LINE__);
        }
        $this->specificLane = $specificLane;
        return $this;
    }
    /**
     * Get specificVehicleCharacteristics value
     * @return \StructType\VehicleCharacteristics|null
     */
    public function getSpecificVehicleCharacteristics()
    {
        return $this->specificVehicleCharacteristics;
    }
    /**
     * Set specificVehicleCharacteristics value
     * @param \StructType\VehicleCharacteristics $specificVehicleCharacteristics
     * @return \StructType\MeasurementSpecificCharacteristics_1
     */
    public function setSpecificVehicleCharacteristics(\StructType\VehicleCharacteristics $specificVehicleCharacteristics = null)
    {
        $this->specificVehicleCharacteristics = $specificVehicleCharacteristics;
        return $this;
    }
    /**
     * Get measurementSpecificCharacteristicsExtension value
     * @return \StructType\ExtensionType|null
     */
    public function getMeasurementSpecificCharacteristicsExtension()
    {
        return $this->measurementSpecificCharacteristicsExtension;
    }
    /**
     * Set measurementSpecificCharacteristicsExtension value
     * @param \StructType\ExtensionType $measurementSpecificCharacteristicsExtension
     * @return \StructType\MeasurementSpecificCharacteristics_1
     */
    public function setMeasurementSpecificCharacteristicsExtension(\StructType\ExtensionType $measurementSpecificCharacteristicsExtension = null)
    {
        $this->measurementSpecificCharacteristicsExtension = $measurementSpecificCharacteristicsExtension;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\MeasurementSpecificCharacteristics_1
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
