<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for MeasuredDataPublication StructType
 * @subpackage Structs
 */
class MeasuredDataPublication extends PayloadPublication
{
    /**
     * The measurementSiteTableReference
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - maxLength: 1024
     * @var string
     */
    public $measurementSiteTableReference;
    /**
     * The headerInformation
     * @var \StructType\HeaderInformation
     */
    public $headerInformation;
    /**
     * The siteMeasurements
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * @var \StructType\SiteMeasurements[]
     */
    public $siteMeasurements;
    /**
     * The measuredDataPublicationExtension
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\ExtensionType
     */
    public $measuredDataPublicationExtension;
    /**
     * Constructor method for MeasuredDataPublication
     * @uses MeasuredDataPublication::setMeasurementSiteTableReference()
     * @uses MeasuredDataPublication::setHeaderInformation()
     * @uses MeasuredDataPublication::setSiteMeasurements()
     * @uses MeasuredDataPublication::setMeasuredDataPublicationExtension()
     * @param string $measurementSiteTableReference
     * @param \StructType\HeaderInformation $headerInformation
     * @param \StructType\SiteMeasurements[] $siteMeasurements
     * @param \StructType\ExtensionType $measuredDataPublicationExtension
     */
    public function __construct($measurementSiteTableReference = null, \StructType\HeaderInformation $headerInformation = null, array $siteMeasurements = array(), \StructType\ExtensionType $measuredDataPublicationExtension = null)
    {
        $this
            ->setMeasurementSiteTableReference($measurementSiteTableReference)
            ->setHeaderInformation($headerInformation)
            ->setSiteMeasurements($siteMeasurements)
            ->setMeasuredDataPublicationExtension($measuredDataPublicationExtension);
    }
    /**
     * Get measurementSiteTableReference value
     * @return string
     */
    public function getMeasurementSiteTableReference()
    {
        return $this->measurementSiteTableReference;
    }
    /**
     * Set measurementSiteTableReference value
     * @param string $measurementSiteTableReference
     * @return \StructType\MeasuredDataPublication
     */
    public function setMeasurementSiteTableReference($measurementSiteTableReference = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($measurementSiteTableReference) && strlen($measurementSiteTableReference) > 1024) || (is_array($measurementSiteTableReference) && count($measurementSiteTableReference) > 1024)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 1024 element(s) or a scalar of 1024 character(s) at most, "%d" length given', is_scalar($measurementSiteTableReference) ? strlen($measurementSiteTableReference) : count($measurementSiteTableReference)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($measurementSiteTableReference) && !is_string($measurementSiteTableReference)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($measurementSiteTableReference)), __LINE__);
        }
        $this->measurementSiteTableReference = $measurementSiteTableReference;
        return $this;
    }
    /**
     * Get headerInformation value
     * @return \StructType\HeaderInformation|null
     */
    public function getHeaderInformation()
    {
        return $this->headerInformation;
    }
    /**
     * Set headerInformation value
     * @param \StructType\HeaderInformation $headerInformation
     * @return \StructType\MeasuredDataPublication
     */
    public function setHeaderInformation(\StructType\HeaderInformation $headerInformation = null)
    {
        $this->headerInformation = $headerInformation;
        return $this;
    }
    /**
     * Get siteMeasurements value
     * @return \StructType\SiteMeasurements[]|null
     */
    public function getSiteMeasurements()
    {
        return $this->siteMeasurements;
    }
    /**
     * Set siteMeasurements value
     * @throws \InvalidArgumentException
     * @param \StructType\SiteMeasurements[] $siteMeasurements
     * @return \StructType\MeasuredDataPublication
     */
    public function setSiteMeasurements(array $siteMeasurements = array())
    {
        foreach ($siteMeasurements as $measuredDataPublicationSiteMeasurementsItem) {
            // validation for constraint: itemType
            if (!$measuredDataPublicationSiteMeasurementsItem instanceof \StructType\SiteMeasurements) {
                throw new \InvalidArgumentException(sprintf('The siteMeasurements property can only contain items of \StructType\SiteMeasurements, "%s" given', is_object($measuredDataPublicationSiteMeasurementsItem) ? get_class($measuredDataPublicationSiteMeasurementsItem) : gettype($measuredDataPublicationSiteMeasurementsItem)), __LINE__);
            }
        }
        $this->siteMeasurements = $siteMeasurements;
        return $this;
    }
    /**
     * Add item to siteMeasurements value
     * @throws \InvalidArgumentException
     * @param \StructType\SiteMeasurements $item
     * @return \StructType\MeasuredDataPublication
     */
    public function addToSiteMeasurements(\StructType\SiteMeasurements $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SiteMeasurements) {
            throw new \InvalidArgumentException(sprintf('The siteMeasurements property can only contain items of \StructType\SiteMeasurements, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->siteMeasurements[] = $item;
        return $this;
    }
    /**
     * Get measuredDataPublicationExtension value
     * @return \StructType\ExtensionType|null
     */
    public function getMeasuredDataPublicationExtension()
    {
        return $this->measuredDataPublicationExtension;
    }
    /**
     * Set measuredDataPublicationExtension value
     * @param \StructType\ExtensionType $measuredDataPublicationExtension
     * @return \StructType\MeasuredDataPublication
     */
    public function setMeasuredDataPublicationExtension(\StructType\ExtensionType $measuredDataPublicationExtension = null)
    {
        $this->measuredDataPublicationExtension = $measuredDataPublicationExtension;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\MeasuredDataPublication
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
