<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for MaximumNumberOfCalls StructType
 * Meta informations extracted from the WSDL
 * - documentation: If calls are to be returned, maximum number of calls to include in response. If absent, exclude all calls. | If calls are to be returned, maximum number of calls to include in response. If absent, exclude all calls. +SIRI v2.0.
 * - minOccurs: 0
 * @subpackage Structs
 */
class MaximumNumberOfCalls extends AbstractStructBase
{
    /**
     * The Previous
     * Meta informations extracted from the WSDL
     * - documentation: Maximum number of ONWARDS CALLs to include in results. Only applies if StopMonitoringDetailLevel of 'calls' specified. Zero for none. If StopMonitoringDetailLevel of 'calls' specified but MaximumNumberOfCalls.Previous absent, include
     * all ONWARDS CALLs. | Maximum number of previous calls to include. Only applies if VehicleMonitoringDetailLevel of Calls specified. Zero for none. If VehicleMonitoringDetailLevel of Calls specified but MaximumNumberOfCalls.Previous absent, include all
     * previous calls. +SIRI v2.0.
     * - minOccurs: 0
     * @var int
     */
    public $Previous;
    /**
     * The Onwards
     * Meta informations extracted from the WSDL
     * - documentation: Maximum number of ONWARDS CALLs to include in results. Zero for none. Only applies if StopMonitoringDetailLevel of 'calls'specified. Zero for none. If StopMonitoringDetailLevel of 'calls' specified but MaximumNumberOfCalls.Onwards
     * absent, include all ONWARDS CALLs. | Maximum number of onwards calls to include. Zero for none. Only applies if VehicleMonitoringDetailLevel of 'calls' specified. Zero for none. If VehicleMonitoringDetailLevel calls specified but
     * MaximumNumberOfCalls.Onwards absent, include all onwards calls. +SIRI v2.0.
     * - minOccurs: 0
     * @var int
     */
    public $Onwards;
    /**
     * Constructor method for MaximumNumberOfCalls
     * @uses MaximumNumberOfCalls::setPrevious()
     * @uses MaximumNumberOfCalls::setOnwards()
     * @param int $previous
     * @param int $onwards
     */
    public function __construct($previous = null, $onwards = null)
    {
        $this
            ->setPrevious($previous)
            ->setOnwards($onwards);
    }
    /**
     * Get Previous value
     * @return int|null
     */
    public function getPrevious()
    {
        return $this->Previous;
    }
    /**
     * Set Previous value
     * @param int $previous
     * @return \StructType\MaximumNumberOfCalls
     */
    public function setPrevious($previous = null)
    {
        // validation for constraint: int
        if (!is_null($previous) && !is_numeric($previous)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($previous)), __LINE__);
        }
        $this->Previous = $previous;
        return $this;
    }
    /**
     * Get Onwards value
     * @return int|null
     */
    public function getOnwards()
    {
        return $this->Onwards;
    }
    /**
     * Set Onwards value
     * @param int $onwards
     * @return \StructType\MaximumNumberOfCalls
     */
    public function setOnwards($onwards = null)
    {
        // validation for constraint: int
        if (!is_null($onwards) && !is_numeric($onwards)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($onwards)), __LINE__);
        }
        $this->Onwards = $onwards;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\MaximumNumberOfCalls
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
