<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Location StructType
 * Meta informations extracted from the WSDL
 * - documentation: Bounding box of an arbitrary area. Only incidents geocoded as falling within area will be included.
 * - maxOccurs: 2
 * - minOccurs: 0
 * - type: LocationStructure
 * @subpackage Structs
 */
abstract class Location extends AbstractStructBase
{
    /**
     * The externalReferencing
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\ExternalReferencing[]
     */
    public $externalReferencing;
    /**
     * The locationForDisplay
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\PointCoordinates
     */
    public $locationForDisplay;
    /**
     * The locationExtension
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\ExtensionType
     */
    public $locationExtension;
    /**
     * Constructor method for Location
     * @uses Location::setExternalReferencing()
     * @uses Location::setLocationForDisplay()
     * @uses Location::setLocationExtension()
     * @param \StructType\ExternalReferencing[] $externalReferencing
     * @param \StructType\PointCoordinates $locationForDisplay
     * @param \StructType\ExtensionType $locationExtension
     */
    public function __construct(array $externalReferencing = array(), \StructType\PointCoordinates $locationForDisplay = null, \StructType\ExtensionType $locationExtension = null)
    {
        $this
            ->setExternalReferencing($externalReferencing)
            ->setLocationForDisplay($locationForDisplay)
            ->setLocationExtension($locationExtension);
    }
    /**
     * Get externalReferencing value
     * @return \StructType\ExternalReferencing[]|null
     */
    public function getExternalReferencing()
    {
        return $this->externalReferencing;
    }
    /**
     * Set externalReferencing value
     * @throws \InvalidArgumentException
     * @param \StructType\ExternalReferencing[] $externalReferencing
     * @return \StructType\Location
     */
    public function setExternalReferencing(array $externalReferencing = array())
    {
        foreach ($externalReferencing as $locationExternalReferencingItem) {
            // validation for constraint: itemType
            if (!$locationExternalReferencingItem instanceof \StructType\ExternalReferencing) {
                throw new \InvalidArgumentException(sprintf('The externalReferencing property can only contain items of \StructType\ExternalReferencing, "%s" given', is_object($locationExternalReferencingItem) ? get_class($locationExternalReferencingItem) : gettype($locationExternalReferencingItem)), __LINE__);
            }
        }
        $this->externalReferencing = $externalReferencing;
        return $this;
    }
    /**
     * Add item to externalReferencing value
     * @throws \InvalidArgumentException
     * @param \StructType\ExternalReferencing $item
     * @return \StructType\Location
     */
    public function addToExternalReferencing(\StructType\ExternalReferencing $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ExternalReferencing) {
            throw new \InvalidArgumentException(sprintf('The externalReferencing property can only contain items of \StructType\ExternalReferencing, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->externalReferencing[] = $item;
        return $this;
    }
    /**
     * Get locationForDisplay value
     * @return \StructType\PointCoordinates|null
     */
    public function getLocationForDisplay()
    {
        return $this->locationForDisplay;
    }
    /**
     * Set locationForDisplay value
     * @param \StructType\PointCoordinates $locationForDisplay
     * @return \StructType\Location
     */
    public function setLocationForDisplay(\StructType\PointCoordinates $locationForDisplay = null)
    {
        $this->locationForDisplay = $locationForDisplay;
        return $this;
    }
    /**
     * Get locationExtension value
     * @return \StructType\ExtensionType|null
     */
    public function getLocationExtension()
    {
        return $this->locationExtension;
    }
    /**
     * Set locationExtension value
     * @param \StructType\ExtensionType $locationExtension
     * @return \StructType\Location
     */
    public function setLocationExtension(\StructType\ExtensionType $locationExtension = null)
    {
        $this->locationExtension = $locationExtension;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Location
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
