<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for LinesDeliveryStructure StructType
 * Meta informations extracted from the WSDL
 * - documentation: Response with LINEs available to make requests.
 * @subpackage Structs
 */
class LinesDeliveryStructure extends AbstractDiscoveryDeliveryStructure
{
    /**
     * The AnnotatedLineRef
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - ref: AnnotatedLineRef
     * @var \StructType\AnnotatedLineStructure[]
     */
    public $AnnotatedLineRef;
    /**
     * The Extensions
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - ref: Extensions
     * @var \StructType\ExtensionsStructure
     */
    public $Extensions;
    /**
     * The version
     * Meta informations extracted from the WSDL
     * - default: 2.0
     * - documentation: Version number of response. Fixed. | A string indicating the versioin of a SIRI data structure.
     * @var string
     */
    public $version;
    /**
     * Constructor method for LinesDeliveryStructure
     * @uses LinesDeliveryStructure::setAnnotatedLineRef()
     * @uses LinesDeliveryStructure::setExtensions()
     * @uses LinesDeliveryStructure::setVersion()
     * @param \StructType\AnnotatedLineStructure[] $annotatedLineRef
     * @param \StructType\ExtensionsStructure $extensions
     * @param string $version
     */
    public function __construct(array $annotatedLineRef = array(), \StructType\ExtensionsStructure $extensions = null, $version = '2.0')
    {
        $this
            ->setAnnotatedLineRef($annotatedLineRef)
            ->setExtensions($extensions)
            ->setVersion($version);
    }
    /**
     * Get AnnotatedLineRef value
     * @return \StructType\AnnotatedLineStructure[]|null
     */
    public function getAnnotatedLineRef()
    {
        return $this->AnnotatedLineRef;
    }
    /**
     * Set AnnotatedLineRef value
     * @throws \InvalidArgumentException
     * @param \StructType\AnnotatedLineStructure[] $annotatedLineRef
     * @return \StructType\LinesDeliveryStructure
     */
    public function setAnnotatedLineRef(array $annotatedLineRef = array())
    {
        foreach ($annotatedLineRef as $linesDeliveryStructureAnnotatedLineRefItem) {
            // validation for constraint: itemType
            if (!$linesDeliveryStructureAnnotatedLineRefItem instanceof \StructType\AnnotatedLineStructure) {
                throw new \InvalidArgumentException(sprintf('The AnnotatedLineRef property can only contain items of \StructType\AnnotatedLineStructure, "%s" given', is_object($linesDeliveryStructureAnnotatedLineRefItem) ? get_class($linesDeliveryStructureAnnotatedLineRefItem) : gettype($linesDeliveryStructureAnnotatedLineRefItem)), __LINE__);
            }
        }
        $this->AnnotatedLineRef = $annotatedLineRef;
        return $this;
    }
    /**
     * Add item to AnnotatedLineRef value
     * @throws \InvalidArgumentException
     * @param \StructType\AnnotatedLineStructure $item
     * @return \StructType\LinesDeliveryStructure
     */
    public function addToAnnotatedLineRef(\StructType\AnnotatedLineStructure $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\AnnotatedLineStructure) {
            throw new \InvalidArgumentException(sprintf('The AnnotatedLineRef property can only contain items of \StructType\AnnotatedLineStructure, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->AnnotatedLineRef[] = $item;
        return $this;
    }
    /**
     * Get Extensions value
     * @return \StructType\ExtensionsStructure|null
     */
    public function getExtensions()
    {
        return $this->Extensions;
    }
    /**
     * Set Extensions value
     * @param \StructType\ExtensionsStructure $extensions
     * @return \StructType\LinesDeliveryStructure
     */
    public function setExtensions(\StructType\ExtensionsStructure $extensions = null)
    {
        $this->Extensions = $extensions;
        return $this;
    }
    /**
     * Get version value
     * @return string|null
     */
    public function getVersion()
    {
        return $this->version;
    }
    /**
     * Set version value
     * @param string $version
     * @return \StructType\LinesDeliveryStructure
     */
    public function setVersion($version = '2.0')
    {
        // validation for constraint: string
        if (!is_null($version) && !is_string($version)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($version)), __LINE__);
        }
        $this->version = $version;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\LinesDeliveryStructure
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
