<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for LineShapeStructure StructType
 * Meta informations extracted from the WSDL
 * - documentation: Defines a line shape +SIRI v2.0
 * @subpackage Structs
 */
class LineShapeStructure extends AbstractStructBase
{
    /**
     * The Point
     * Meta informations extracted from the WSDL
     * - documentation: A geospatial point. +SIRI v2.0 .
     * - maxOccurs: unbounded
     * - minOccurs: 2
     * @var \StructType\LocationStructure[]
     */
    public $Point;
    /**
     * Constructor method for LineShapeStructure
     * @uses LineShapeStructure::setPoint()
     * @param \StructType\LocationStructure[] $point
     */
    public function __construct(array $point = array())
    {
        $this
            ->setPoint($point);
    }
    /**
     * Get Point value
     * @return \StructType\LocationStructure[]
     */
    public function getPoint()
    {
        return $this->Point;
    }
    /**
     * Set Point value
     * @throws \InvalidArgumentException
     * @param \StructType\LocationStructure[] $point
     * @return \StructType\LineShapeStructure
     */
    public function setPoint(array $point = array())
    {
        foreach ($point as $lineShapeStructurePointItem) {
            // validation for constraint: itemType
            if (!$lineShapeStructurePointItem instanceof \StructType\LocationStructure) {
                throw new \InvalidArgumentException(sprintf('The Point property can only contain items of \StructType\LocationStructure, "%s" given', is_object($lineShapeStructurePointItem) ? get_class($lineShapeStructurePointItem) : gettype($lineShapeStructurePointItem)), __LINE__);
            }
        }
        $this->Point = $point;
        return $this;
    }
    /**
     * Add item to Point value
     * @throws \InvalidArgumentException
     * @param \StructType\LocationStructure $item
     * @return \StructType\LineShapeStructure
     */
    public function addToPoint(\StructType\LocationStructure $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\LocationStructure) {
            throw new \InvalidArgumentException(sprintf('The Point property can only contain items of \StructType\LocationStructure, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Point[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\LineShapeStructure
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
