<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for LengthCharacteristic StructType
 * @subpackage Structs
 */
class LengthCharacteristic extends AbstractStructBase
{
    /**
     * The comparisonOperator
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $comparisonOperator;
    /**
     * The vehicleLength
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $vehicleLength;
    /**
     * The lengthCharacteristicExtension
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\ExtensionType
     */
    public $lengthCharacteristicExtension;
    /**
     * Constructor method for LengthCharacteristic
     * @uses LengthCharacteristic::setComparisonOperator()
     * @uses LengthCharacteristic::setVehicleLength()
     * @uses LengthCharacteristic::setLengthCharacteristicExtension()
     * @param string $comparisonOperator
     * @param float $vehicleLength
     * @param \StructType\ExtensionType $lengthCharacteristicExtension
     */
    public function __construct($comparisonOperator = null, $vehicleLength = null, \StructType\ExtensionType $lengthCharacteristicExtension = null)
    {
        $this
            ->setComparisonOperator($comparisonOperator)
            ->setVehicleLength($vehicleLength)
            ->setLengthCharacteristicExtension($lengthCharacteristicExtension);
    }
    /**
     * Get comparisonOperator value
     * @return string
     */
    public function getComparisonOperator()
    {
        return $this->comparisonOperator;
    }
    /**
     * Set comparisonOperator value
     * @uses \EnumType\ComparisonOperatorEnum::valueIsValid()
     * @uses \EnumType\ComparisonOperatorEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $comparisonOperator
     * @return \StructType\LengthCharacteristic
     */
    public function setComparisonOperator($comparisonOperator = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\ComparisonOperatorEnum::valueIsValid($comparisonOperator)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $comparisonOperator, implode(', ', \EnumType\ComparisonOperatorEnum::getValidValues())), __LINE__);
        }
        $this->comparisonOperator = $comparisonOperator;
        return $this;
    }
    /**
     * Get vehicleLength value
     * @return float
     */
    public function getVehicleLength()
    {
        return $this->vehicleLength;
    }
    /**
     * Set vehicleLength value
     * @param float $vehicleLength
     * @return \StructType\LengthCharacteristic
     */
    public function setVehicleLength($vehicleLength = null)
    {
        $this->vehicleLength = $vehicleLength;
        return $this;
    }
    /**
     * Get lengthCharacteristicExtension value
     * @return \StructType\ExtensionType|null
     */
    public function getLengthCharacteristicExtension()
    {
        return $this->lengthCharacteristicExtension;
    }
    /**
     * Set lengthCharacteristicExtension value
     * @param \StructType\ExtensionType $lengthCharacteristicExtension
     * @return \StructType\LengthCharacteristic
     */
    public function setLengthCharacteristicExtension(\StructType\ExtensionType $lengthCharacteristicExtension = null)
    {
        $this->lengthCharacteristicExtension = $lengthCharacteristicExtension;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\LengthCharacteristic
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
