<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for JourneyPartInfoStructure StructType
 * Meta informations extracted from the WSDL
 * - documentation: Type for a refernces to JOURNEY PARTs. +SIRI v2.0
 * @subpackage Structs
 */
class JourneyPartInfoStructure extends AbstractStructBase
{
    /**
     * The JourneyPartRef
     * Meta informations extracted from the WSDL
     * - documentation: Refrence to a JOURNEY part. +SIRI v2.0
     * @var string
     */
    public $JourneyPartRef;
    /**
     * The TrainNumberRef
     * Meta informations extracted from the WSDL
     * - documentation: Train Number for JOURNEY PART +SIRI v2.0
     * - minOccurs: 0
     * @var \StructType\TrainNumberRefStructure
     */
    public $TrainNumberRef;
    /**
     * The OperatorRef
     * Meta informations extracted from the WSDL
     * - documentation: Operator of JOURNEY PART. +SIRI v2.0
     * - minOccurs: 0
     * @var \StructType\OperatorRefStructure
     */
    public $OperatorRef;
    /**
     * Constructor method for JourneyPartInfoStructure
     * @uses JourneyPartInfoStructure::setJourneyPartRef()
     * @uses JourneyPartInfoStructure::setTrainNumberRef()
     * @uses JourneyPartInfoStructure::setOperatorRef()
     * @param string $journeyPartRef
     * @param \StructType\TrainNumberRefStructure $trainNumberRef
     * @param \StructType\OperatorRefStructure $operatorRef
     */
    public function __construct($journeyPartRef = null, \StructType\TrainNumberRefStructure $trainNumberRef = null, \StructType\OperatorRefStructure $operatorRef = null)
    {
        $this
            ->setJourneyPartRef($journeyPartRef)
            ->setTrainNumberRef($trainNumberRef)
            ->setOperatorRef($operatorRef);
    }
    /**
     * Get JourneyPartRef value
     * @return string|null
     */
    public function getJourneyPartRef()
    {
        return $this->JourneyPartRef;
    }
    /**
     * Set JourneyPartRef value
     * @param string $journeyPartRef
     * @return \StructType\JourneyPartInfoStructure
     */
    public function setJourneyPartRef($journeyPartRef = null)
    {
        // validation for constraint: string
        if (!is_null($journeyPartRef) && !is_string($journeyPartRef)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($journeyPartRef)), __LINE__);
        }
        $this->JourneyPartRef = $journeyPartRef;
        return $this;
    }
    /**
     * Get TrainNumberRef value
     * @return \StructType\TrainNumberRefStructure|null
     */
    public function getTrainNumberRef()
    {
        return $this->TrainNumberRef;
    }
    /**
     * Set TrainNumberRef value
     * @param \StructType\TrainNumberRefStructure $trainNumberRef
     * @return \StructType\JourneyPartInfoStructure
     */
    public function setTrainNumberRef(\StructType\TrainNumberRefStructure $trainNumberRef = null)
    {
        $this->TrainNumberRef = $trainNumberRef;
        return $this;
    }
    /**
     * Get OperatorRef value
     * @return \StructType\OperatorRefStructure|null
     */
    public function getOperatorRef()
    {
        return $this->OperatorRef;
    }
    /**
     * Set OperatorRef value
     * @param \StructType\OperatorRefStructure $operatorRef
     * @return \StructType\JourneyPartInfoStructure
     */
    public function setOperatorRef(\StructType\OperatorRefStructure $operatorRef = null)
    {
        $this->OperatorRef = $operatorRef;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\JourneyPartInfoStructure
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
