<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for InfoMessageStructure StructType
 * Meta informations extracted from the WSDL
 * - documentation: Type for an Info Message. @formatRef.
 * @subpackage Structs
 */
class InfoMessageStructure extends AbstractIdentifiedItemStructure
{
    /**
     * The InfoMessageIdentifier
     * @var \StructType\InfoMessageRefStructure
     */
    public $InfoMessageIdentifier;
    /**
     * The InfoMessageVersion
     * @var int
     */
    public $InfoMessageVersion;
    /**
     * The InfoChannelRef
     * @var \StructType\InfoChannelRefStructure
     */
    public $InfoChannelRef;
    /**
     * The ValidUntilTime
     * Meta informations extracted from the WSDL
     * - documentation: Time until when message is valid. If absent unopen ended.
     * - minOccurs: 0
     * @var string
     */
    public $ValidUntilTime;
    /**
     * The SituationRef
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - ref: SituationRef
     * @var \StructType\SituationRefStructure
     */
    public $SituationRef;
    /**
     * The Content
     * Meta informations extracted from the WSDL
     * - documentation: Message Content. Format is specified by Format Ref.
     * @var mixed
     */
    public $Content;
    /**
     * The Extensions
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - ref: Extensions
     * @var \StructType\ExtensionsStructure
     */
    public $Extensions;
    /**
     * The formatRef
     * Meta informations extracted from the WSDL
     * - documentation: Reference to a format of the Content. If absent, free text.
     * @var string
     */
    public $formatRef;
    /**
     * Constructor method for InfoMessageStructure
     * @uses InfoMessageStructure::setInfoMessageIdentifier()
     * @uses InfoMessageStructure::setInfoMessageVersion()
     * @uses InfoMessageStructure::setInfoChannelRef()
     * @uses InfoMessageStructure::setValidUntilTime()
     * @uses InfoMessageStructure::setSituationRef()
     * @uses InfoMessageStructure::setContent()
     * @uses InfoMessageStructure::setExtensions()
     * @uses InfoMessageStructure::setFormatRef()
     * @param \StructType\InfoMessageRefStructure $infoMessageIdentifier
     * @param int $infoMessageVersion
     * @param \StructType\InfoChannelRefStructure $infoChannelRef
     * @param string $validUntilTime
     * @param \StructType\SituationRefStructure $situationRef
     * @param mixed $content
     * @param \StructType\ExtensionsStructure $extensions
     * @param string $formatRef
     */
    public function __construct(\StructType\InfoMessageRefStructure $infoMessageIdentifier = null, $infoMessageVersion = null, \StructType\InfoChannelRefStructure $infoChannelRef = null, $validUntilTime = null, \StructType\SituationRefStructure $situationRef = null, $content = null, \StructType\ExtensionsStructure $extensions = null, $formatRef = null)
    {
        $this
            ->setInfoMessageIdentifier($infoMessageIdentifier)
            ->setInfoMessageVersion($infoMessageVersion)
            ->setInfoChannelRef($infoChannelRef)
            ->setValidUntilTime($validUntilTime)
            ->setSituationRef($situationRef)
            ->setContent($content)
            ->setExtensions($extensions)
            ->setFormatRef($formatRef);
    }
    /**
     * Get InfoMessageIdentifier value
     * @return \StructType\InfoMessageRefStructure|null
     */
    public function getInfoMessageIdentifier()
    {
        return $this->InfoMessageIdentifier;
    }
    /**
     * Set InfoMessageIdentifier value
     * @param \StructType\InfoMessageRefStructure $infoMessageIdentifier
     * @return \StructType\InfoMessageStructure
     */
    public function setInfoMessageIdentifier(\StructType\InfoMessageRefStructure $infoMessageIdentifier = null)
    {
        $this->InfoMessageIdentifier = $infoMessageIdentifier;
        return $this;
    }
    /**
     * Get InfoMessageVersion value
     * @return int|null
     */
    public function getInfoMessageVersion()
    {
        return $this->InfoMessageVersion;
    }
    /**
     * Set InfoMessageVersion value
     * @param int $infoMessageVersion
     * @return \StructType\InfoMessageStructure
     */
    public function setInfoMessageVersion($infoMessageVersion = null)
    {
        // validation for constraint: int
        if (!is_null($infoMessageVersion) && !is_numeric($infoMessageVersion)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($infoMessageVersion)), __LINE__);
        }
        $this->InfoMessageVersion = $infoMessageVersion;
        return $this;
    }
    /**
     * Get InfoChannelRef value
     * @return \StructType\InfoChannelRefStructure|null
     */
    public function getInfoChannelRef()
    {
        return $this->InfoChannelRef;
    }
    /**
     * Set InfoChannelRef value
     * @param \StructType\InfoChannelRefStructure $infoChannelRef
     * @return \StructType\InfoMessageStructure
     */
    public function setInfoChannelRef(\StructType\InfoChannelRefStructure $infoChannelRef = null)
    {
        $this->InfoChannelRef = $infoChannelRef;
        return $this;
    }
    /**
     * Get ValidUntilTime value
     * @return string|null
     */
    public function getValidUntilTime()
    {
        return $this->ValidUntilTime;
    }
    /**
     * Set ValidUntilTime value
     * @param string $validUntilTime
     * @return \StructType\InfoMessageStructure
     */
    public function setValidUntilTime($validUntilTime = null)
    {
        // validation for constraint: string
        if (!is_null($validUntilTime) && !is_string($validUntilTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($validUntilTime)), __LINE__);
        }
        $this->ValidUntilTime = $validUntilTime;
        return $this;
    }
    /**
     * Get SituationRef value
     * @return \StructType\SituationRefStructure|null
     */
    public function getSituationRef()
    {
        return $this->SituationRef;
    }
    /**
     * Set SituationRef value
     * @param \StructType\SituationRefStructure $situationRef
     * @return \StructType\InfoMessageStructure
     */
    public function setSituationRef(\StructType\SituationRefStructure $situationRef = null)
    {
        $this->SituationRef = $situationRef;
        return $this;
    }
    /**
     * Get Content value
     * @return mixed|null
     */
    public function getContent()
    {
        return $this->Content;
    }
    /**
     * Set Content value
     * @param mixed $content
     * @return \StructType\InfoMessageStructure
     */
    public function setContent($content = null)
    {
        $this->Content = $content;
        return $this;
    }
    /**
     * Get Extensions value
     * @return \StructType\ExtensionsStructure|null
     */
    public function getExtensions()
    {
        return $this->Extensions;
    }
    /**
     * Set Extensions value
     * @param \StructType\ExtensionsStructure $extensions
     * @return \StructType\InfoMessageStructure
     */
    public function setExtensions(\StructType\ExtensionsStructure $extensions = null)
    {
        $this->Extensions = $extensions;
        return $this;
    }
    /**
     * Get formatRef value
     * @return string|null
     */
    public function getFormatRef()
    {
        return $this->formatRef;
    }
    /**
     * Set formatRef value
     * @param string $formatRef
     * @return \StructType\InfoMessageStructure
     */
    public function setFormatRef($formatRef = null)
    {
        // validation for constraint: string
        if (!is_null($formatRef) && !is_string($formatRef)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($formatRef)), __LINE__);
        }
        $this->formatRef = $formatRef;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\InfoMessageStructure
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
