<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for InfoMessageCancellationStructure StructType
 * Meta informations extracted from the WSDL
 * - documentation: Type for Revocation of a previous message.
 * @subpackage Structs
 */
class InfoMessageCancellationStructure extends AbstractReferencingItemStructure
{
    /**
     * The InfoMessageIdentifier
     * Meta informations extracted from the WSDL
     * - documentation: Identifier of message. Unique within service and Producer participant.
     * @var \StructType\InfoMessageRefStructure
     */
    public $InfoMessageIdentifier;
    /**
     * The InfoChannelRef
     * Meta informations extracted from the WSDL
     * - documentation: Info Channel to which message belongs.
     * - minOccurs: 0
     * @var \StructType\InfoChannelRefStructure
     */
    public $InfoChannelRef;
    /**
     * The Extensions
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - ref: Extensions
     * @var \StructType\ExtensionsStructure
     */
    public $Extensions;
    /**
     * Constructor method for InfoMessageCancellationStructure
     * @uses InfoMessageCancellationStructure::setInfoMessageIdentifier()
     * @uses InfoMessageCancellationStructure::setInfoChannelRef()
     * @uses InfoMessageCancellationStructure::setExtensions()
     * @param \StructType\InfoMessageRefStructure $infoMessageIdentifier
     * @param \StructType\InfoChannelRefStructure $infoChannelRef
     * @param \StructType\ExtensionsStructure $extensions
     */
    public function __construct(\StructType\InfoMessageRefStructure $infoMessageIdentifier = null, \StructType\InfoChannelRefStructure $infoChannelRef = null, \StructType\ExtensionsStructure $extensions = null)
    {
        $this
            ->setInfoMessageIdentifier($infoMessageIdentifier)
            ->setInfoChannelRef($infoChannelRef)
            ->setExtensions($extensions);
    }
    /**
     * Get InfoMessageIdentifier value
     * @return \StructType\InfoMessageRefStructure|null
     */
    public function getInfoMessageIdentifier()
    {
        return $this->InfoMessageIdentifier;
    }
    /**
     * Set InfoMessageIdentifier value
     * @param \StructType\InfoMessageRefStructure $infoMessageIdentifier
     * @return \StructType\InfoMessageCancellationStructure
     */
    public function setInfoMessageIdentifier(\StructType\InfoMessageRefStructure $infoMessageIdentifier = null)
    {
        $this->InfoMessageIdentifier = $infoMessageIdentifier;
        return $this;
    }
    /**
     * Get InfoChannelRef value
     * @return \StructType\InfoChannelRefStructure|null
     */
    public function getInfoChannelRef()
    {
        return $this->InfoChannelRef;
    }
    /**
     * Set InfoChannelRef value
     * @param \StructType\InfoChannelRefStructure $infoChannelRef
     * @return \StructType\InfoMessageCancellationStructure
     */
    public function setInfoChannelRef(\StructType\InfoChannelRefStructure $infoChannelRef = null)
    {
        $this->InfoChannelRef = $infoChannelRef;
        return $this;
    }
    /**
     * Get Extensions value
     * @return \StructType\ExtensionsStructure|null
     */
    public function getExtensions()
    {
        return $this->Extensions;
    }
    /**
     * Set Extensions value
     * @param \StructType\ExtensionsStructure $extensions
     * @return \StructType\InfoMessageCancellationStructure
     */
    public function setExtensions(\StructType\ExtensionsStructure $extensions = null)
    {
        $this->Extensions = $extensions;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\InfoMessageCancellationStructure
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
