<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for InfoLinkStructure StructType
 * Meta informations extracted from the WSDL
 * - documentation: Type for a general hyperlink. | Type for Info Link.
 * @subpackage Structs
 */
class InfoLinkStructure extends AbstractStructBase
{
    /**
     * The _
     * @var string
     */
    public $_;
    /**
     * The Uri
     * Meta informations extracted from the WSDL
     * - documentation: URI for link.
     * @var string
     */
    public $Uri;
    /**
     * The Label
     * Meta informations extracted from the WSDL
     * - documentation: Label for Link. (Unbounded since SIRI 2.0)
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\NaturalLanguageStringStructure[]
     */
    public $Label;
    /**
     * The Image
     * Meta informations extracted from the WSDL
     * - documentation: Image to use when presenting hyperlink.
     * - minOccurs: 0
     * @var \StructType\ImageStructure
     */
    public $Image;
    /**
     * The LinkContent
     * Meta informations extracted from the WSDL
     * - documentation: Categorisation of link content.
     * - minOccurs: 0
     * @var string
     */
    public $LinkContent;
    /**
     * Constructor method for InfoLinkStructure
     * @uses InfoLinkStructure::set_()
     * @uses InfoLinkStructure::setUri()
     * @uses InfoLinkStructure::setLabel()
     * @uses InfoLinkStructure::setImage()
     * @uses InfoLinkStructure::setLinkContent()
     * @param string $_
     * @param string $uri
     * @param \StructType\NaturalLanguageStringStructure[] $label
     * @param \StructType\ImageStructure $image
     * @param string $linkContent
     */
    public function __construct($_ = null, $uri = null, array $label = array(), \StructType\ImageStructure $image = null, $linkContent = null)
    {
        $this
            ->set_($_)
            ->setUri($uri)
            ->setLabel($label)
            ->setImage($image)
            ->setLinkContent($linkContent);
    }
    /**
     * Get _ value
     * @return string|null
     */
    public function get_()
    {
        return $this->_;
    }
    /**
     * Set _ value
     * @param string $_
     * @return \StructType\InfoLinkStructure
     */
    public function set_($_ = null)
    {
        // validation for constraint: string
        if (!is_null($_) && !is_string($_)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($_)), __LINE__);
        }
        $this->_ = $_;
        return $this;
    }
    /**
     * Get Uri value
     * @return string|null
     */
    public function getUri()
    {
        return $this->Uri;
    }
    /**
     * Set Uri value
     * @param string $uri
     * @return \StructType\InfoLinkStructure
     */
    public function setUri($uri = null)
    {
        // validation for constraint: string
        if (!is_null($uri) && !is_string($uri)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($uri)), __LINE__);
        }
        $this->Uri = $uri;
        return $this;
    }
    /**
     * Get Label value
     * @return \StructType\NaturalLanguageStringStructure[]|null
     */
    public function getLabel()
    {
        return $this->Label;
    }
    /**
     * Set Label value
     * @throws \InvalidArgumentException
     * @param \StructType\NaturalLanguageStringStructure[] $label
     * @return \StructType\InfoLinkStructure
     */
    public function setLabel(array $label = array())
    {
        foreach ($label as $infoLinkStructureLabelItem) {
            // validation for constraint: itemType
            if (!$infoLinkStructureLabelItem instanceof \StructType\NaturalLanguageStringStructure) {
                throw new \InvalidArgumentException(sprintf('The Label property can only contain items of \StructType\NaturalLanguageStringStructure, "%s" given', is_object($infoLinkStructureLabelItem) ? get_class($infoLinkStructureLabelItem) : gettype($infoLinkStructureLabelItem)), __LINE__);
            }
        }
        $this->Label = $label;
        return $this;
    }
    /**
     * Add item to Label value
     * @throws \InvalidArgumentException
     * @param \StructType\NaturalLanguageStringStructure $item
     * @return \StructType\InfoLinkStructure
     */
    public function addToLabel(\StructType\NaturalLanguageStringStructure $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\NaturalLanguageStringStructure) {
            throw new \InvalidArgumentException(sprintf('The Label property can only contain items of \StructType\NaturalLanguageStringStructure, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Label[] = $item;
        return $this;
    }
    /**
     * Get Image value
     * @return \StructType\ImageStructure|null
     */
    public function getImage()
    {
        return $this->Image;
    }
    /**
     * Set Image value
     * @param \StructType\ImageStructure $image
     * @return \StructType\InfoLinkStructure
     */
    public function setImage(\StructType\ImageStructure $image = null)
    {
        $this->Image = $image;
        return $this;
    }
    /**
     * Get LinkContent value
     * @return string|null
     */
    public function getLinkContent()
    {
        return $this->LinkContent;
    }
    /**
     * Set LinkContent value
     * @uses \EnumType\LinkContentEnumeration::valueIsValid()
     * @uses \EnumType\LinkContentEnumeration::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $linkContent
     * @return \StructType\InfoLinkStructure
     */
    public function setLinkContent($linkContent = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\LinkContentEnumeration::valueIsValid($linkContent)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $linkContent, implode(', ', \EnumType\LinkContentEnumeration::getValidValues())), __LINE__);
        }
        $this->LinkContent = $linkContent;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\InfoLinkStructure
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
