<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for InfoChannelPermissions StructType
 * Meta informations extracted from the WSDL
 * - documentation: The monitoring points that the participant may access.
 * @subpackage Structs
 */
class InfoChannelPermissions extends AbstractStructBase
{
    /**
     * The AllowAll
     * Meta informations extracted from the WSDL
     * - ref: AllowAll
     * @var bool
     */
    public $AllowAll;
    /**
     * The InfoChannelPermission
     * Meta informations extracted from the WSDL
     * - documentation: Participant's permission for this InfoChannel.
     * - maxOccurs: unbounded
     * @var \StructType\InfoChannelPermissionStructure[]
     */
    public $InfoChannelPermission;
    /**
     * Constructor method for InfoChannelPermissions
     * @uses InfoChannelPermissions::setAllowAll()
     * @uses InfoChannelPermissions::setInfoChannelPermission()
     * @param bool $allowAll
     * @param \StructType\InfoChannelPermissionStructure[] $infoChannelPermission
     */
    public function __construct($allowAll = null, array $infoChannelPermission = array())
    {
        $this
            ->setAllowAll($allowAll)
            ->setInfoChannelPermission($infoChannelPermission);
    }
    /**
     * Get AllowAll value
     * @return bool|null
     */
    public function getAllowAll()
    {
        return $this->AllowAll;
    }
    /**
     * Set AllowAll value
     * @param bool $allowAll
     * @return \StructType\InfoChannelPermissions
     */
    public function setAllowAll($allowAll = null)
    {
        // validation for constraint: boolean
        if (!is_null($allowAll) && !is_bool($allowAll)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($allowAll)), __LINE__);
        }
        $this->AllowAll = $allowAll;
        return $this;
    }
    /**
     * Get InfoChannelPermission value
     * @return \StructType\InfoChannelPermissionStructure[]|null
     */
    public function getInfoChannelPermission()
    {
        return $this->InfoChannelPermission;
    }
    /**
     * Set InfoChannelPermission value
     * @throws \InvalidArgumentException
     * @param \StructType\InfoChannelPermissionStructure[] $infoChannelPermission
     * @return \StructType\InfoChannelPermissions
     */
    public function setInfoChannelPermission(array $infoChannelPermission = array())
    {
        foreach ($infoChannelPermission as $infoChannelPermissionsInfoChannelPermissionItem) {
            // validation for constraint: itemType
            if (!$infoChannelPermissionsInfoChannelPermissionItem instanceof \StructType\InfoChannelPermissionStructure) {
                throw new \InvalidArgumentException(sprintf('The InfoChannelPermission property can only contain items of \StructType\InfoChannelPermissionStructure, "%s" given', is_object($infoChannelPermissionsInfoChannelPermissionItem) ? get_class($infoChannelPermissionsInfoChannelPermissionItem) : gettype($infoChannelPermissionsInfoChannelPermissionItem)), __LINE__);
            }
        }
        $this->InfoChannelPermission = $infoChannelPermission;
        return $this;
    }
    /**
     * Add item to InfoChannelPermission value
     * @throws \InvalidArgumentException
     * @param \StructType\InfoChannelPermissionStructure $item
     * @return \StructType\InfoChannelPermissions
     */
    public function addToInfoChannelPermission(\StructType\InfoChannelPermissionStructure $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\InfoChannelPermissionStructure) {
            throw new \InvalidArgumentException(sprintf('The InfoChannelPermission property can only contain items of \StructType\InfoChannelPermissionStructure, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->InfoChannelPermission[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\InfoChannelPermissions
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
