<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for HeightCharacteristic StructType
 * @subpackage Structs
 */
class HeightCharacteristic extends AbstractStructBase
{
    /**
     * The comparisonOperator
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $comparisonOperator;
    /**
     * The vehicleHeight
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $vehicleHeight;
    /**
     * The heightCharacteristicExtension
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\ExtensionType
     */
    public $heightCharacteristicExtension;
    /**
     * Constructor method for HeightCharacteristic
     * @uses HeightCharacteristic::setComparisonOperator()
     * @uses HeightCharacteristic::setVehicleHeight()
     * @uses HeightCharacteristic::setHeightCharacteristicExtension()
     * @param string $comparisonOperator
     * @param float $vehicleHeight
     * @param \StructType\ExtensionType $heightCharacteristicExtension
     */
    public function __construct($comparisonOperator = null, $vehicleHeight = null, \StructType\ExtensionType $heightCharacteristicExtension = null)
    {
        $this
            ->setComparisonOperator($comparisonOperator)
            ->setVehicleHeight($vehicleHeight)
            ->setHeightCharacteristicExtension($heightCharacteristicExtension);
    }
    /**
     * Get comparisonOperator value
     * @return string
     */
    public function getComparisonOperator()
    {
        return $this->comparisonOperator;
    }
    /**
     * Set comparisonOperator value
     * @uses \EnumType\ComparisonOperatorEnum::valueIsValid()
     * @uses \EnumType\ComparisonOperatorEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $comparisonOperator
     * @return \StructType\HeightCharacteristic
     */
    public function setComparisonOperator($comparisonOperator = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\ComparisonOperatorEnum::valueIsValid($comparisonOperator)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $comparisonOperator, implode(', ', \EnumType\ComparisonOperatorEnum::getValidValues())), __LINE__);
        }
        $this->comparisonOperator = $comparisonOperator;
        return $this;
    }
    /**
     * Get vehicleHeight value
     * @return float
     */
    public function getVehicleHeight()
    {
        return $this->vehicleHeight;
    }
    /**
     * Set vehicleHeight value
     * @param float $vehicleHeight
     * @return \StructType\HeightCharacteristic
     */
    public function setVehicleHeight($vehicleHeight = null)
    {
        $this->vehicleHeight = $vehicleHeight;
        return $this;
    }
    /**
     * Get heightCharacteristicExtension value
     * @return \StructType\ExtensionType|null
     */
    public function getHeightCharacteristicExtension()
    {
        return $this->heightCharacteristicExtension;
    }
    /**
     * Set heightCharacteristicExtension value
     * @param \StructType\ExtensionType $heightCharacteristicExtension
     * @return \StructType\HeightCharacteristic
     */
    public function setHeightCharacteristicExtension(\StructType\ExtensionType $heightCharacteristicExtension = null)
    {
        $this->heightCharacteristicExtension = $heightCharacteristicExtension;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\HeightCharacteristic
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
