<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GroupOfVehiclesInvolved StructType
 * @subpackage Structs
 */
class GroupOfVehiclesInvolved extends AbstractStructBase
{
    /**
     * The numberOfVehicles
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $numberOfVehicles;
    /**
     * The vehicleStatus
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $vehicleStatus;
    /**
     * The vehicleCharacteristics
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\VehicleCharacteristics
     */
    public $vehicleCharacteristics;
    /**
     * The groupOfVehiclesInvolvedExtension
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\ExtensionType
     */
    public $groupOfVehiclesInvolvedExtension;
    /**
     * Constructor method for GroupOfVehiclesInvolved
     * @uses GroupOfVehiclesInvolved::setNumberOfVehicles()
     * @uses GroupOfVehiclesInvolved::setVehicleStatus()
     * @uses GroupOfVehiclesInvolved::setVehicleCharacteristics()
     * @uses GroupOfVehiclesInvolved::setGroupOfVehiclesInvolvedExtension()
     * @param int $numberOfVehicles
     * @param string $vehicleStatus
     * @param \StructType\VehicleCharacteristics $vehicleCharacteristics
     * @param \StructType\ExtensionType $groupOfVehiclesInvolvedExtension
     */
    public function __construct($numberOfVehicles = null, $vehicleStatus = null, \StructType\VehicleCharacteristics $vehicleCharacteristics = null, \StructType\ExtensionType $groupOfVehiclesInvolvedExtension = null)
    {
        $this
            ->setNumberOfVehicles($numberOfVehicles)
            ->setVehicleStatus($vehicleStatus)
            ->setVehicleCharacteristics($vehicleCharacteristics)
            ->setGroupOfVehiclesInvolvedExtension($groupOfVehiclesInvolvedExtension);
    }
    /**
     * Get numberOfVehicles value
     * @return int|null
     */
    public function getNumberOfVehicles()
    {
        return $this->numberOfVehicles;
    }
    /**
     * Set numberOfVehicles value
     * @param int $numberOfVehicles
     * @return \StructType\GroupOfVehiclesInvolved
     */
    public function setNumberOfVehicles($numberOfVehicles = null)
    {
        // validation for constraint: int
        if (!is_null($numberOfVehicles) && !is_numeric($numberOfVehicles)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($numberOfVehicles)), __LINE__);
        }
        $this->numberOfVehicles = $numberOfVehicles;
        return $this;
    }
    /**
     * Get vehicleStatus value
     * @return string|null
     */
    public function getVehicleStatus()
    {
        return $this->vehicleStatus;
    }
    /**
     * Set vehicleStatus value
     * @uses \EnumType\VehicleStatusEnum::valueIsValid()
     * @uses \EnumType\VehicleStatusEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $vehicleStatus
     * @return \StructType\GroupOfVehiclesInvolved
     */
    public function setVehicleStatus($vehicleStatus = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\VehicleStatusEnum::valueIsValid($vehicleStatus)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $vehicleStatus, implode(', ', \EnumType\VehicleStatusEnum::getValidValues())), __LINE__);
        }
        $this->vehicleStatus = $vehicleStatus;
        return $this;
    }
    /**
     * Get vehicleCharacteristics value
     * @return \StructType\VehicleCharacteristics|null
     */
    public function getVehicleCharacteristics()
    {
        return $this->vehicleCharacteristics;
    }
    /**
     * Set vehicleCharacteristics value
     * @param \StructType\VehicleCharacteristics $vehicleCharacteristics
     * @return \StructType\GroupOfVehiclesInvolved
     */
    public function setVehicleCharacteristics(\StructType\VehicleCharacteristics $vehicleCharacteristics = null)
    {
        $this->vehicleCharacteristics = $vehicleCharacteristics;
        return $this;
    }
    /**
     * Get groupOfVehiclesInvolvedExtension value
     * @return \StructType\ExtensionType|null
     */
    public function getGroupOfVehiclesInvolvedExtension()
    {
        return $this->groupOfVehiclesInvolvedExtension;
    }
    /**
     * Set groupOfVehiclesInvolvedExtension value
     * @param \StructType\ExtensionType $groupOfVehiclesInvolvedExtension
     * @return \StructType\GroupOfVehiclesInvolved
     */
    public function setGroupOfVehiclesInvolvedExtension(\StructType\ExtensionType $groupOfVehiclesInvolvedExtension = null)
    {
        $this->groupOfVehiclesInvolvedExtension = $groupOfVehiclesInvolvedExtension;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\GroupOfVehiclesInvolved
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
