<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GroupOfPeopleInvolved StructType
 * @subpackage Structs
 */
class GroupOfPeopleInvolved extends AbstractStructBase
{
    /**
     * The numberOfPeople
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $numberOfPeople;
    /**
     * The injuryStatus
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $injuryStatus;
    /**
     * The involvementRole
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $involvementRole;
    /**
     * The categoryOfPeopleInvolved
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $categoryOfPeopleInvolved;
    /**
     * The groupOfPeopleInvolvedExtension
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\ExtensionType
     */
    public $groupOfPeopleInvolvedExtension;
    /**
     * Constructor method for GroupOfPeopleInvolved
     * @uses GroupOfPeopleInvolved::setNumberOfPeople()
     * @uses GroupOfPeopleInvolved::setInjuryStatus()
     * @uses GroupOfPeopleInvolved::setInvolvementRole()
     * @uses GroupOfPeopleInvolved::setCategoryOfPeopleInvolved()
     * @uses GroupOfPeopleInvolved::setGroupOfPeopleInvolvedExtension()
     * @param int $numberOfPeople
     * @param string $injuryStatus
     * @param string $involvementRole
     * @param string $categoryOfPeopleInvolved
     * @param \StructType\ExtensionType $groupOfPeopleInvolvedExtension
     */
    public function __construct($numberOfPeople = null, $injuryStatus = null, $involvementRole = null, $categoryOfPeopleInvolved = null, \StructType\ExtensionType $groupOfPeopleInvolvedExtension = null)
    {
        $this
            ->setNumberOfPeople($numberOfPeople)
            ->setInjuryStatus($injuryStatus)
            ->setInvolvementRole($involvementRole)
            ->setCategoryOfPeopleInvolved($categoryOfPeopleInvolved)
            ->setGroupOfPeopleInvolvedExtension($groupOfPeopleInvolvedExtension);
    }
    /**
     * Get numberOfPeople value
     * @return int|null
     */
    public function getNumberOfPeople()
    {
        return $this->numberOfPeople;
    }
    /**
     * Set numberOfPeople value
     * @param int $numberOfPeople
     * @return \StructType\GroupOfPeopleInvolved
     */
    public function setNumberOfPeople($numberOfPeople = null)
    {
        // validation for constraint: int
        if (!is_null($numberOfPeople) && !is_numeric($numberOfPeople)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($numberOfPeople)), __LINE__);
        }
        $this->numberOfPeople = $numberOfPeople;
        return $this;
    }
    /**
     * Get injuryStatus value
     * @return string|null
     */
    public function getInjuryStatus()
    {
        return $this->injuryStatus;
    }
    /**
     * Set injuryStatus value
     * @uses \EnumType\InjuryStatusTypeEnum::valueIsValid()
     * @uses \EnumType\InjuryStatusTypeEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $injuryStatus
     * @return \StructType\GroupOfPeopleInvolved
     */
    public function setInjuryStatus($injuryStatus = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\InjuryStatusTypeEnum::valueIsValid($injuryStatus)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $injuryStatus, implode(', ', \EnumType\InjuryStatusTypeEnum::getValidValues())), __LINE__);
        }
        $this->injuryStatus = $injuryStatus;
        return $this;
    }
    /**
     * Get involvementRole value
     * @return string|null
     */
    public function getInvolvementRole()
    {
        return $this->involvementRole;
    }
    /**
     * Set involvementRole value
     * @uses \EnumType\InvolvementRolesEnum::valueIsValid()
     * @uses \EnumType\InvolvementRolesEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $involvementRole
     * @return \StructType\GroupOfPeopleInvolved
     */
    public function setInvolvementRole($involvementRole = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\InvolvementRolesEnum::valueIsValid($involvementRole)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $involvementRole, implode(', ', \EnumType\InvolvementRolesEnum::getValidValues())), __LINE__);
        }
        $this->involvementRole = $involvementRole;
        return $this;
    }
    /**
     * Get categoryOfPeopleInvolved value
     * @return string|null
     */
    public function getCategoryOfPeopleInvolved()
    {
        return $this->categoryOfPeopleInvolved;
    }
    /**
     * Set categoryOfPeopleInvolved value
     * @uses \EnumType\PersonCategoryEnum::valueIsValid()
     * @uses \EnumType\PersonCategoryEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $categoryOfPeopleInvolved
     * @return \StructType\GroupOfPeopleInvolved
     */
    public function setCategoryOfPeopleInvolved($categoryOfPeopleInvolved = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\PersonCategoryEnum::valueIsValid($categoryOfPeopleInvolved)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $categoryOfPeopleInvolved, implode(', ', \EnumType\PersonCategoryEnum::getValidValues())), __LINE__);
        }
        $this->categoryOfPeopleInvolved = $categoryOfPeopleInvolved;
        return $this;
    }
    /**
     * Get groupOfPeopleInvolvedExtension value
     * @return \StructType\ExtensionType|null
     */
    public function getGroupOfPeopleInvolvedExtension()
    {
        return $this->groupOfPeopleInvolvedExtension;
    }
    /**
     * Set groupOfPeopleInvolvedExtension value
     * @param \StructType\ExtensionType $groupOfPeopleInvolvedExtension
     * @return \StructType\GroupOfPeopleInvolved
     */
    public function setGroupOfPeopleInvolvedExtension(\StructType\ExtensionType $groupOfPeopleInvolvedExtension = null)
    {
        $this->groupOfPeopleInvolvedExtension = $groupOfPeopleInvolvedExtension;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\GroupOfPeopleInvolved
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
