<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GenericPublication StructType
 * @subpackage Structs
 */
class GenericPublication extends PayloadPublication
{
    /**
     * The genericPublicationName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - maxLength: 1024
     * @var string
     */
    public $genericPublicationName;
    /**
     * The genericPublicationExtension
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\ExtensionType
     */
    public $genericPublicationExtension;
    /**
     * Constructor method for GenericPublication
     * @uses GenericPublication::setGenericPublicationName()
     * @uses GenericPublication::setGenericPublicationExtension()
     * @param string $genericPublicationName
     * @param \StructType\ExtensionType $genericPublicationExtension
     */
    public function __construct($genericPublicationName = null, \StructType\ExtensionType $genericPublicationExtension = null)
    {
        $this
            ->setGenericPublicationName($genericPublicationName)
            ->setGenericPublicationExtension($genericPublicationExtension);
    }
    /**
     * Get genericPublicationName value
     * @return string
     */
    public function getGenericPublicationName()
    {
        return $this->genericPublicationName;
    }
    /**
     * Set genericPublicationName value
     * @param string $genericPublicationName
     * @return \StructType\GenericPublication
     */
    public function setGenericPublicationName($genericPublicationName = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($genericPublicationName) && strlen($genericPublicationName) > 1024) || (is_array($genericPublicationName) && count($genericPublicationName) > 1024)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 1024 element(s) or a scalar of 1024 character(s) at most, "%d" length given', is_scalar($genericPublicationName) ? strlen($genericPublicationName) : count($genericPublicationName)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($genericPublicationName) && !is_string($genericPublicationName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($genericPublicationName)), __LINE__);
        }
        $this->genericPublicationName = $genericPublicationName;
        return $this;
    }
    /**
     * Get genericPublicationExtension value
     * @return \StructType\ExtensionType|null
     */
    public function getGenericPublicationExtension()
    {
        return $this->genericPublicationExtension;
    }
    /**
     * Set genericPublicationExtension value
     * @param \StructType\ExtensionType $genericPublicationExtension
     * @return \StructType\GenericPublication
     */
    public function setGenericPublicationExtension(\StructType\ExtensionType $genericPublicationExtension = null)
    {
        $this->genericPublicationExtension = $genericPublicationExtension;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\GenericPublication
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
