<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GeneralMessageCapabilitiesResponseStructure StructType
 * Meta informations extracted from the WSDL
 * - documentation: Type for Delivery for General MessageService.
 * @subpackage Structs
 */
class GeneralMessageCapabilitiesResponseStructure extends AbstractServiceCapabilitiesResponseStructure
{
    /**
     * The GeneralMessageServiceCapabilities
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - ref: GeneralMessageServiceCapabilities
     * @var \StructType\GeneralMessageServiceCapabilitiesStructure
     */
    public $GeneralMessageServiceCapabilities;
    /**
     * The GeneralMessagePermissions
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - ref: GeneralMessagePermissions
     * @var \StructType\GeneralMessagePermissions
     */
    public $GeneralMessagePermissions;
    /**
     * The Extensions
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - ref: Extensions
     * @var \StructType\ExtensionsStructure
     */
    public $Extensions;
    /**
     * The version
     * Meta informations extracted from the WSDL
     * - default: 2.0
     * - documentation: Version number of response. Fixed | A string indicating the versioin of a SIRI data structure.
     * @var string
     */
    public $version;
    /**
     * Constructor method for GeneralMessageCapabilitiesResponseStructure
     * @uses GeneralMessageCapabilitiesResponseStructure::setGeneralMessageServiceCapabilities()
     * @uses GeneralMessageCapabilitiesResponseStructure::setGeneralMessagePermissions()
     * @uses GeneralMessageCapabilitiesResponseStructure::setExtensions()
     * @uses GeneralMessageCapabilitiesResponseStructure::setVersion()
     * @param \StructType\GeneralMessageServiceCapabilitiesStructure $generalMessageServiceCapabilities
     * @param \StructType\GeneralMessagePermissions $generalMessagePermissions
     * @param \StructType\ExtensionsStructure $extensions
     * @param string $version
     */
    public function __construct(\StructType\GeneralMessageServiceCapabilitiesStructure $generalMessageServiceCapabilities = null, \StructType\GeneralMessagePermissions $generalMessagePermissions = null, \StructType\ExtensionsStructure $extensions = null, $version = '2.0')
    {
        $this
            ->setGeneralMessageServiceCapabilities($generalMessageServiceCapabilities)
            ->setGeneralMessagePermissions($generalMessagePermissions)
            ->setExtensions($extensions)
            ->setVersion($version);
    }
    /**
     * Get GeneralMessageServiceCapabilities value
     * @return \StructType\GeneralMessageServiceCapabilitiesStructure|null
     */
    public function getGeneralMessageServiceCapabilities()
    {
        return $this->GeneralMessageServiceCapabilities;
    }
    /**
     * Set GeneralMessageServiceCapabilities value
     * @param \StructType\GeneralMessageServiceCapabilitiesStructure $generalMessageServiceCapabilities
     * @return \StructType\GeneralMessageCapabilitiesResponseStructure
     */
    public function setGeneralMessageServiceCapabilities(\StructType\GeneralMessageServiceCapabilitiesStructure $generalMessageServiceCapabilities = null)
    {
        $this->GeneralMessageServiceCapabilities = $generalMessageServiceCapabilities;
        return $this;
    }
    /**
     * Get GeneralMessagePermissions value
     * @return \StructType\GeneralMessagePermissions|null
     */
    public function getGeneralMessagePermissions()
    {
        return $this->GeneralMessagePermissions;
    }
    /**
     * Set GeneralMessagePermissions value
     * @param \StructType\GeneralMessagePermissions $generalMessagePermissions
     * @return \StructType\GeneralMessageCapabilitiesResponseStructure
     */
    public function setGeneralMessagePermissions(\StructType\GeneralMessagePermissions $generalMessagePermissions = null)
    {
        $this->GeneralMessagePermissions = $generalMessagePermissions;
        return $this;
    }
    /**
     * Get Extensions value
     * @return \StructType\ExtensionsStructure|null
     */
    public function getExtensions()
    {
        return $this->Extensions;
    }
    /**
     * Set Extensions value
     * @param \StructType\ExtensionsStructure $extensions
     * @return \StructType\GeneralMessageCapabilitiesResponseStructure
     */
    public function setExtensions(\StructType\ExtensionsStructure $extensions = null)
    {
        $this->Extensions = $extensions;
        return $this;
    }
    /**
     * Get version value
     * @return string|null
     */
    public function getVersion()
    {
        return $this->version;
    }
    /**
     * Set version value
     * @param string $version
     * @return \StructType\GeneralMessageCapabilitiesResponseStructure
     */
    public function setVersion($version = '2.0')
    {
        // validation for constraint: string
        if (!is_null($version) && !is_string($version)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($version)), __LINE__);
        }
        $this->version = $version;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\GeneralMessageCapabilitiesResponseStructure
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
