<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for FacilityRequestStructure StructType
 * Meta informations extracted from the WSDL
 * - documentation: Requests for info channels for use in service requests.
 * @subpackage Structs
 */
class FacilityRequestStructure extends AbstractDiscoveryRequestStructure
{
    /**
     * The BoundingBox
     * @var \StructType\BoundingBoxStructure
     */
    public $BoundingBox;
    /**
     * The PlaceRef
     * @var string
     */
    public $PlaceRef;
    /**
     * The OperatorRef
     * @var \StructType\OperatorRefStructure
     */
    public $OperatorRef;
    /**
     * The LineRef
     * @var \StructType\LineRefStructure
     */
    public $LineRef;
    /**
     * The Language
     * @var string
     */
    public $Language;
    /**
     * The FacilityDetailLevel
     * @var string
     */
    public $FacilityDetailLevel;
    /**
     * The Extensions
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - ref: Extensions
     * @var \StructType\ExtensionsStructure
     */
    public $Extensions;
    /**
     * The version
     * Meta informations extracted from the WSDL
     * - default: 2.0
     * - documentation: Version number of request. Fixed | A string indicating the versioin of a SIRI data structure.
     * @var string
     */
    public $version;
    /**
     * Constructor method for FacilityRequestStructure
     * @uses FacilityRequestStructure::setBoundingBox()
     * @uses FacilityRequestStructure::setPlaceRef()
     * @uses FacilityRequestStructure::setOperatorRef()
     * @uses FacilityRequestStructure::setLineRef()
     * @uses FacilityRequestStructure::setLanguage()
     * @uses FacilityRequestStructure::setFacilityDetailLevel()
     * @uses FacilityRequestStructure::setExtensions()
     * @uses FacilityRequestStructure::setVersion()
     * @param \StructType\BoundingBoxStructure $boundingBox
     * @param string $placeRef
     * @param \StructType\OperatorRefStructure $operatorRef
     * @param \StructType\LineRefStructure $lineRef
     * @param string $language
     * @param string $facilityDetailLevel
     * @param \StructType\ExtensionsStructure $extensions
     * @param string $version
     */
    public function __construct(\StructType\BoundingBoxStructure $boundingBox = null, $placeRef = null, \StructType\OperatorRefStructure $operatorRef = null, \StructType\LineRefStructure $lineRef = null, $language = null, $facilityDetailLevel = null, \StructType\ExtensionsStructure $extensions = null, $version = '2.0')
    {
        $this
            ->setBoundingBox($boundingBox)
            ->setPlaceRef($placeRef)
            ->setOperatorRef($operatorRef)
            ->setLineRef($lineRef)
            ->setLanguage($language)
            ->setFacilityDetailLevel($facilityDetailLevel)
            ->setExtensions($extensions)
            ->setVersion($version);
    }
    /**
     * Get BoundingBox value
     * @return \StructType\BoundingBoxStructure|null
     */
    public function getBoundingBox()
    {
        return $this->BoundingBox;
    }
    /**
     * Set BoundingBox value
     * @param \StructType\BoundingBoxStructure $boundingBox
     * @return \StructType\FacilityRequestStructure
     */
    public function setBoundingBox(\StructType\BoundingBoxStructure $boundingBox = null)
    {
        $this->BoundingBox = $boundingBox;
        return $this;
    }
    /**
     * Get PlaceRef value
     * @return string|null
     */
    public function getPlaceRef()
    {
        return $this->PlaceRef;
    }
    /**
     * Set PlaceRef value
     * @param string $placeRef
     * @return \StructType\FacilityRequestStructure
     */
    public function setPlaceRef($placeRef = null)
    {
        // validation for constraint: string
        if (!is_null($placeRef) && !is_string($placeRef)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($placeRef)), __LINE__);
        }
        $this->PlaceRef = $placeRef;
        return $this;
    }
    /**
     * Get OperatorRef value
     * @return \StructType\OperatorRefStructure|null
     */
    public function getOperatorRef()
    {
        return $this->OperatorRef;
    }
    /**
     * Set OperatorRef value
     * @param \StructType\OperatorRefStructure $operatorRef
     * @return \StructType\FacilityRequestStructure
     */
    public function setOperatorRef(\StructType\OperatorRefStructure $operatorRef = null)
    {
        $this->OperatorRef = $operatorRef;
        return $this;
    }
    /**
     * Get LineRef value
     * @return \StructType\LineRefStructure|null
     */
    public function getLineRef()
    {
        return $this->LineRef;
    }
    /**
     * Set LineRef value
     * @param \StructType\LineRefStructure $lineRef
     * @return \StructType\FacilityRequestStructure
     */
    public function setLineRef(\StructType\LineRefStructure $lineRef = null)
    {
        $this->LineRef = $lineRef;
        return $this;
    }
    /**
     * Get Language value
     * @return string|null
     */
    public function getLanguage()
    {
        return $this->Language;
    }
    /**
     * Set Language value
     * @param string $language
     * @return \StructType\FacilityRequestStructure
     */
    public function setLanguage($language = null)
    {
        // validation for constraint: string
        if (!is_null($language) && !is_string($language)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($language)), __LINE__);
        }
        $this->Language = $language;
        return $this;
    }
    /**
     * Get FacilityDetailLevel value
     * @return string|null
     */
    public function getFacilityDetailLevel()
    {
        return $this->FacilityDetailLevel;
    }
    /**
     * Set FacilityDetailLevel value
     * @uses \EnumType\FacilityDetailEnumeration::valueIsValid()
     * @uses \EnumType\FacilityDetailEnumeration::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $facilityDetailLevel
     * @return \StructType\FacilityRequestStructure
     */
    public function setFacilityDetailLevel($facilityDetailLevel = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\FacilityDetailEnumeration::valueIsValid($facilityDetailLevel)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $facilityDetailLevel, implode(', ', \EnumType\FacilityDetailEnumeration::getValidValues())), __LINE__);
        }
        $this->FacilityDetailLevel = $facilityDetailLevel;
        return $this;
    }
    /**
     * Get Extensions value
     * @return \StructType\ExtensionsStructure|null
     */
    public function getExtensions()
    {
        return $this->Extensions;
    }
    /**
     * Set Extensions value
     * @param \StructType\ExtensionsStructure $extensions
     * @return \StructType\FacilityRequestStructure
     */
    public function setExtensions(\StructType\ExtensionsStructure $extensions = null)
    {
        $this->Extensions = $extensions;
        return $this;
    }
    /**
     * Get version value
     * @return string|null
     */
    public function getVersion()
    {
        return $this->version;
    }
    /**
     * Set version value
     * @param string $version
     * @return \StructType\FacilityRequestStructure
     */
    public function setVersion($version = '2.0')
    {
        // validation for constraint: string
        if (!is_null($version) && !is_string($version)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($version)), __LINE__);
        }
        $this->version = $version;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\FacilityRequestStructure
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
