<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for FacilityLocationStructure StructType
 * Meta informations extracted from the WSDL
 * - documentation: Location of the MONITORED FACILITY. | Group of Facility accessibility elements. | Group of Facility accessibility elements.
 * @subpackage Structs
 */
class FacilityLocationStructure extends AbstractStructBase
{
    /**
     * The LineRef
     * @var \StructType\LineRefStructure
     */
    public $LineRef;
    /**
     * The StopPointRef
     * @var \StructType\StopPointRefStructure
     */
    public $StopPointRef;
    /**
     * The VehicleRef
     * @var \StructType\VehicleRefStructure
     */
    public $VehicleRef;
    /**
     * The DatedVehicleJourneyRef
     * @var \StructType\DatedVehicleJourneyRefStructure
     */
    public $DatedVehicleJourneyRef;
    /**
     * The ConnectionLinkRef
     * @var \StructType\ConnectionLinkRefStructure
     */
    public $ConnectionLinkRef;
    /**
     * The InterchangeRef
     * @var \StructType\InterchangeRefStructure
     */
    public $InterchangeRef;
    /**
     * The StopPlaceRef
     * @var \StructType\StopPlaceRefStructure
     */
    public $StopPlaceRef;
    /**
     * The StopPlaceComponentId
     * @var \StructType\StopPlaceComponentRefStructure
     */
    public $StopPlaceComponentId;
    /**
     * The OperatorRef
     * @var \StructType\OperatorRefStructure
     */
    public $OperatorRef;
    /**
     * The ProductCategoryRef
     * @var \StructType\ProductCategoryRefStructure
     */
    public $ProductCategoryRef;
    /**
     * The ServiceFeatureRef
     * @var \StructType\ServiceFeatureRefStructure
     */
    public $ServiceFeatureRef;
    /**
     * The VehicleFeatureRef
     * @var \StructType\VehicleFeatureRefStructure
     */
    public $VehicleFeatureRef;
    /**
     * Constructor method for FacilityLocationStructure
     * @uses FacilityLocationStructure::setLineRef()
     * @uses FacilityLocationStructure::setStopPointRef()
     * @uses FacilityLocationStructure::setVehicleRef()
     * @uses FacilityLocationStructure::setDatedVehicleJourneyRef()
     * @uses FacilityLocationStructure::setConnectionLinkRef()
     * @uses FacilityLocationStructure::setInterchangeRef()
     * @uses FacilityLocationStructure::setStopPlaceRef()
     * @uses FacilityLocationStructure::setStopPlaceComponentId()
     * @uses FacilityLocationStructure::setOperatorRef()
     * @uses FacilityLocationStructure::setProductCategoryRef()
     * @uses FacilityLocationStructure::setServiceFeatureRef()
     * @uses FacilityLocationStructure::setVehicleFeatureRef()
     * @param \StructType\LineRefStructure $lineRef
     * @param \StructType\StopPointRefStructure $stopPointRef
     * @param \StructType\VehicleRefStructure $vehicleRef
     * @param \StructType\DatedVehicleJourneyRefStructure $datedVehicleJourneyRef
     * @param \StructType\ConnectionLinkRefStructure $connectionLinkRef
     * @param \StructType\InterchangeRefStructure $interchangeRef
     * @param \StructType\StopPlaceRefStructure $stopPlaceRef
     * @param \StructType\StopPlaceComponentRefStructure $stopPlaceComponentId
     * @param \StructType\OperatorRefStructure $operatorRef
     * @param \StructType\ProductCategoryRefStructure $productCategoryRef
     * @param \StructType\ServiceFeatureRefStructure $serviceFeatureRef
     * @param \StructType\VehicleFeatureRefStructure $vehicleFeatureRef
     */
    public function __construct(\StructType\LineRefStructure $lineRef = null, \StructType\StopPointRefStructure $stopPointRef = null, \StructType\VehicleRefStructure $vehicleRef = null, \StructType\DatedVehicleJourneyRefStructure $datedVehicleJourneyRef = null, \StructType\ConnectionLinkRefStructure $connectionLinkRef = null, \StructType\InterchangeRefStructure $interchangeRef = null, \StructType\StopPlaceRefStructure $stopPlaceRef = null, \StructType\StopPlaceComponentRefStructure $stopPlaceComponentId = null, \StructType\OperatorRefStructure $operatorRef = null, \StructType\ProductCategoryRefStructure $productCategoryRef = null, \StructType\ServiceFeatureRefStructure $serviceFeatureRef = null, \StructType\VehicleFeatureRefStructure $vehicleFeatureRef = null)
    {
        $this
            ->setLineRef($lineRef)
            ->setStopPointRef($stopPointRef)
            ->setVehicleRef($vehicleRef)
            ->setDatedVehicleJourneyRef($datedVehicleJourneyRef)
            ->setConnectionLinkRef($connectionLinkRef)
            ->setInterchangeRef($interchangeRef)
            ->setStopPlaceRef($stopPlaceRef)
            ->setStopPlaceComponentId($stopPlaceComponentId)
            ->setOperatorRef($operatorRef)
            ->setProductCategoryRef($productCategoryRef)
            ->setServiceFeatureRef($serviceFeatureRef)
            ->setVehicleFeatureRef($vehicleFeatureRef);
    }
    /**
     * Get LineRef value
     * @return \StructType\LineRefStructure|null
     */
    public function getLineRef()
    {
        return $this->LineRef;
    }
    /**
     * Set LineRef value
     * @param \StructType\LineRefStructure $lineRef
     * @return \StructType\FacilityLocationStructure
     */
    public function setLineRef(\StructType\LineRefStructure $lineRef = null)
    {
        $this->LineRef = $lineRef;
        return $this;
    }
    /**
     * Get StopPointRef value
     * @return \StructType\StopPointRefStructure|null
     */
    public function getStopPointRef()
    {
        return $this->StopPointRef;
    }
    /**
     * Set StopPointRef value
     * @param \StructType\StopPointRefStructure $stopPointRef
     * @return \StructType\FacilityLocationStructure
     */
    public function setStopPointRef(\StructType\StopPointRefStructure $stopPointRef = null)
    {
        $this->StopPointRef = $stopPointRef;
        return $this;
    }
    /**
     * Get VehicleRef value
     * @return \StructType\VehicleRefStructure|null
     */
    public function getVehicleRef()
    {
        return $this->VehicleRef;
    }
    /**
     * Set VehicleRef value
     * @param \StructType\VehicleRefStructure $vehicleRef
     * @return \StructType\FacilityLocationStructure
     */
    public function setVehicleRef(\StructType\VehicleRefStructure $vehicleRef = null)
    {
        $this->VehicleRef = $vehicleRef;
        return $this;
    }
    /**
     * Get DatedVehicleJourneyRef value
     * @return \StructType\DatedVehicleJourneyRefStructure|null
     */
    public function getDatedVehicleJourneyRef()
    {
        return $this->DatedVehicleJourneyRef;
    }
    /**
     * Set DatedVehicleJourneyRef value
     * @param \StructType\DatedVehicleJourneyRefStructure $datedVehicleJourneyRef
     * @return \StructType\FacilityLocationStructure
     */
    public function setDatedVehicleJourneyRef(\StructType\DatedVehicleJourneyRefStructure $datedVehicleJourneyRef = null)
    {
        $this->DatedVehicleJourneyRef = $datedVehicleJourneyRef;
        return $this;
    }
    /**
     * Get ConnectionLinkRef value
     * @return \StructType\ConnectionLinkRefStructure|null
     */
    public function getConnectionLinkRef()
    {
        return $this->ConnectionLinkRef;
    }
    /**
     * Set ConnectionLinkRef value
     * @param \StructType\ConnectionLinkRefStructure $connectionLinkRef
     * @return \StructType\FacilityLocationStructure
     */
    public function setConnectionLinkRef(\StructType\ConnectionLinkRefStructure $connectionLinkRef = null)
    {
        $this->ConnectionLinkRef = $connectionLinkRef;
        return $this;
    }
    /**
     * Get InterchangeRef value
     * @return \StructType\InterchangeRefStructure|null
     */
    public function getInterchangeRef()
    {
        return $this->InterchangeRef;
    }
    /**
     * Set InterchangeRef value
     * @param \StructType\InterchangeRefStructure $interchangeRef
     * @return \StructType\FacilityLocationStructure
     */
    public function setInterchangeRef(\StructType\InterchangeRefStructure $interchangeRef = null)
    {
        $this->InterchangeRef = $interchangeRef;
        return $this;
    }
    /**
     * Get StopPlaceRef value
     * @return \StructType\StopPlaceRefStructure|null
     */
    public function getStopPlaceRef()
    {
        return $this->StopPlaceRef;
    }
    /**
     * Set StopPlaceRef value
     * @param \StructType\StopPlaceRefStructure $stopPlaceRef
     * @return \StructType\FacilityLocationStructure
     */
    public function setStopPlaceRef(\StructType\StopPlaceRefStructure $stopPlaceRef = null)
    {
        $this->StopPlaceRef = $stopPlaceRef;
        return $this;
    }
    /**
     * Get StopPlaceComponentId value
     * @return \StructType\StopPlaceComponentRefStructure|null
     */
    public function getStopPlaceComponentId()
    {
        return $this->StopPlaceComponentId;
    }
    /**
     * Set StopPlaceComponentId value
     * @param \StructType\StopPlaceComponentRefStructure $stopPlaceComponentId
     * @return \StructType\FacilityLocationStructure
     */
    public function setStopPlaceComponentId(\StructType\StopPlaceComponentRefStructure $stopPlaceComponentId = null)
    {
        $this->StopPlaceComponentId = $stopPlaceComponentId;
        return $this;
    }
    /**
     * Get OperatorRef value
     * @return \StructType\OperatorRefStructure|null
     */
    public function getOperatorRef()
    {
        return $this->OperatorRef;
    }
    /**
     * Set OperatorRef value
     * @param \StructType\OperatorRefStructure $operatorRef
     * @return \StructType\FacilityLocationStructure
     */
    public function setOperatorRef(\StructType\OperatorRefStructure $operatorRef = null)
    {
        $this->OperatorRef = $operatorRef;
        return $this;
    }
    /**
     * Get ProductCategoryRef value
     * @return \StructType\ProductCategoryRefStructure|null
     */
    public function getProductCategoryRef()
    {
        return $this->ProductCategoryRef;
    }
    /**
     * Set ProductCategoryRef value
     * @param \StructType\ProductCategoryRefStructure $productCategoryRef
     * @return \StructType\FacilityLocationStructure
     */
    public function setProductCategoryRef(\StructType\ProductCategoryRefStructure $productCategoryRef = null)
    {
        $this->ProductCategoryRef = $productCategoryRef;
        return $this;
    }
    /**
     * Get ServiceFeatureRef value
     * @return \StructType\ServiceFeatureRefStructure|null
     */
    public function getServiceFeatureRef()
    {
        return $this->ServiceFeatureRef;
    }
    /**
     * Set ServiceFeatureRef value
     * @param \StructType\ServiceFeatureRefStructure $serviceFeatureRef
     * @return \StructType\FacilityLocationStructure
     */
    public function setServiceFeatureRef(\StructType\ServiceFeatureRefStructure $serviceFeatureRef = null)
    {
        $this->ServiceFeatureRef = $serviceFeatureRef;
        return $this;
    }
    /**
     * Get VehicleFeatureRef value
     * @return \StructType\VehicleFeatureRefStructure|null
     */
    public function getVehicleFeatureRef()
    {
        return $this->VehicleFeatureRef;
    }
    /**
     * Set VehicleFeatureRef value
     * @param \StructType\VehicleFeatureRefStructure $vehicleFeatureRef
     * @return \StructType\FacilityLocationStructure
     */
    public function setVehicleFeatureRef(\StructType\VehicleFeatureRefStructure $vehicleFeatureRef = null)
    {
        $this->VehicleFeatureRef = $vehicleFeatureRef;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\FacilityLocationStructure
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
