<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ExternalReferencing StructType
 * @subpackage Structs
 */
class ExternalReferencing extends AbstractStructBase
{
    /**
     * The externalLocationCode
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - maxLength: 1024
     * @var string
     */
    public $externalLocationCode;
    /**
     * The externalReferencingSystem
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - maxLength: 1024
     * @var string
     */
    public $externalReferencingSystem;
    /**
     * The externalReferencingExtension
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\ExtensionType
     */
    public $externalReferencingExtension;
    /**
     * Constructor method for ExternalReferencing
     * @uses ExternalReferencing::setExternalLocationCode()
     * @uses ExternalReferencing::setExternalReferencingSystem()
     * @uses ExternalReferencing::setExternalReferencingExtension()
     * @param string $externalLocationCode
     * @param string $externalReferencingSystem
     * @param \StructType\ExtensionType $externalReferencingExtension
     */
    public function __construct($externalLocationCode = null, $externalReferencingSystem = null, \StructType\ExtensionType $externalReferencingExtension = null)
    {
        $this
            ->setExternalLocationCode($externalLocationCode)
            ->setExternalReferencingSystem($externalReferencingSystem)
            ->setExternalReferencingExtension($externalReferencingExtension);
    }
    /**
     * Get externalLocationCode value
     * @return string
     */
    public function getExternalLocationCode()
    {
        return $this->externalLocationCode;
    }
    /**
     * Set externalLocationCode value
     * @param string $externalLocationCode
     * @return \StructType\ExternalReferencing
     */
    public function setExternalLocationCode($externalLocationCode = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($externalLocationCode) && strlen($externalLocationCode) > 1024) || (is_array($externalLocationCode) && count($externalLocationCode) > 1024)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 1024 element(s) or a scalar of 1024 character(s) at most, "%d" length given', is_scalar($externalLocationCode) ? strlen($externalLocationCode) : count($externalLocationCode)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($externalLocationCode) && !is_string($externalLocationCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($externalLocationCode)), __LINE__);
        }
        $this->externalLocationCode = $externalLocationCode;
        return $this;
    }
    /**
     * Get externalReferencingSystem value
     * @return string
     */
    public function getExternalReferencingSystem()
    {
        return $this->externalReferencingSystem;
    }
    /**
     * Set externalReferencingSystem value
     * @param string $externalReferencingSystem
     * @return \StructType\ExternalReferencing
     */
    public function setExternalReferencingSystem($externalReferencingSystem = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($externalReferencingSystem) && strlen($externalReferencingSystem) > 1024) || (is_array($externalReferencingSystem) && count($externalReferencingSystem) > 1024)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 1024 element(s) or a scalar of 1024 character(s) at most, "%d" length given', is_scalar($externalReferencingSystem) ? strlen($externalReferencingSystem) : count($externalReferencingSystem)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($externalReferencingSystem) && !is_string($externalReferencingSystem)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($externalReferencingSystem)), __LINE__);
        }
        $this->externalReferencingSystem = $externalReferencingSystem;
        return $this;
    }
    /**
     * Get externalReferencingExtension value
     * @return \StructType\ExtensionType|null
     */
    public function getExternalReferencingExtension()
    {
        return $this->externalReferencingExtension;
    }
    /**
     * Set externalReferencingExtension value
     * @param \StructType\ExtensionType $externalReferencingExtension
     * @return \StructType\ExternalReferencing
     */
    public function setExternalReferencingExtension(\StructType\ExtensionType $externalReferencingExtension = null)
    {
        $this->externalReferencingExtension = $externalReferencingExtension;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ExternalReferencing
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
